/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPELFaultAdapter;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.bpmn.engine.model.common.FaultHandlers;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.FlowNode;

public class TryBlock<T extends FlowNode>
extends BaseBPMNActivityBlock<T> {
    private FaultHandlers faultHandlers;

    protected TryBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T flowElement) {
        super(context, idSuffix, name, "TRY", flowElement);
    }

    public void setFaultHandlers(FaultHandlers fh) {
        this.faultHandlers = fh;
    }

    public FaultHandlers getFaultHandlers() {
        return this.faultHandlers;
    }

    public boolean __handleException(IScope sc, Throwable exception, ICubeContext ctx) throws Exception {
        IScope thHolderScope = sc;
        IScope tkHolderScope = sc.getParentScope();
        if (!(exception instanceof BPELFault)) {
            return false;
        }
        BPELFault bpelFault = (BPELFault)exception;
        if (this.faultHandlers != null) {
            HashMap<String, Object> token = TryBlock.getTokenMetadata(ctx);
            int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(token);
            int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(token);
            int step = BPMNTokenMetadataUtils.getStepFromTokenMetadata(token) + 1;
            String activationIds = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(token);
            BPELFaultAdapter adaptedFault = new BPELFaultAdapter(bpelFault);
            for (FaultHandler handler : this.faultHandlers.getFaultHandlers()) {
                if (!handler.handles(adaptedFault)) continue;
                BPMNTokenManager.generateOpenToken(tkHolderScope, this, handler.getId(), activationIds, parentThread, thread, step, BPMNTokenMetadataUtils.createFaultTokenMetadata(bpelFault));
                return true;
            }
            FaultHandler defaultHandler = this.faultHandlers.getDefaultHandler();
            if (defaultHandler != null && defaultHandler.handles(adaptedFault)) {
                BPMNTokenManager.generateOpenToken(tkHolderScope, this, defaultHandler.getId(), activationIds, parentThread, thread, step, BPMNTokenMetadataUtils.createFaultTokenMetadata(bpelFault));
                return true;
            }
        }
        return false;
    }

    private static HashMap<String, Object> getTokenMetadata(ICubeContext ctx) {
        HashMap result = (HashMap)ctx.getFromEnvironment("__node_activation-context");
        assert (result != null) : "handleException in TryBlock must have a node activation context Map defined in the context";
        return result;
    }
}

