/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.EventBasedGatewayBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.soa.management.ComponentDN;

public class MultiStartBlock<T extends FlowNode>
extends BaseBPMNActivityBlock<T> {
    private static final String TOKEN_SET = "TOKEN_SET";

    public MultiStartBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T element) {
        super(context, idSuffix, name, "MultiStartBlock", element);
    }

    public static boolean isInitiate(ICubeContext ctx, FlowNode flowElement) {
        String initiateId = EventBasedGatewayBlock.getInstanceInitiateId(ctx);
        List<String> elementInitiateIds = EventBasedGatewayBlock.getElementInitiateIds(flowElement);
        return initiateId != null && elementInitiateIds.contains(initiateId);
    }

    @Override
    protected IScopeImpl[] doActivate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl[] scs;
        for (IScopeImpl scope : scs = super.doActivate(sc, pScope, ctx)) {
            if (scope.containsLocally(TOKEN_SET)) continue;
            ComponentDN componentDN = CubeContextHelper.getProcessDN((ICubeContext)ctx);
            throw new CubeException(75004, new Object[]{componentDN.getStringDN()});
        }
        return scs;
    }

    @Override
    protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
        if (MultiStartBlock.isInitiate(ctx, element.getFlowElement())) {
            super.activateEntryElement(token, scope, element, ctx);
            if (!scope.containsLocally(TOKEN_SET)) {
                scope.declareAndSet(TOKEN_SET, true);
            }
        }
    }
}

