/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.common.BPMNRuntimeConstants;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.runtime.features.ManualInitiatorStartFeature;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventDefinition;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.SignalEventDefinition;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.conversational.Conversational;

public abstract class EventBasedGatewayBlock<T extends EventBasedGateway>
extends BaseBPMNActivityBlock<T> {
    public EventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T gateway) {
        super(context, idSuffix, name, "EventBasedGatewayBlock", gateway);
    }

    protected static List<String> getElementInitiateIds(FlowNode element) {
        ArrayList<String> result = new ArrayList<String>();
        if (element.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY) {
            for (SequenceFlow sequenceFlow : element.getOutgoingSequenceFlows()) {
                result.add(EventBasedGatewayBlock.getElementInitiateId(sequenceFlow.getTarget()));
            }
        } else {
            result.add(EventBasedGatewayBlock.getElementInitiateId(element));
        }
        return result;
    }

    protected static String getInstanceInitiateId(ICubeContext ctx) {
        String result = (String)ctx.getFromEnvironment("__call-operation-name");
        if (result.equals(BPMNRuntimeConstants.CREATE_COMPONENT_INSTANCE_EVENT_QNAME.toString())) {
            result = (String)((Map)ctx.getFromEnvironment("__call-properties")).get("START_EVENT_ID_PROPERTY");
        }
        return result;
    }

    @Override
    protected void initMicroInstructions(BPMNCubeMapBuilderContext context) {
        super.initMicroInstructions(context);
        MISequenceBlock block = new MISequenceBlock();
        block.addMicroInstruction(AuditTrailVisitorHelper.createAndAddPreAuditMI(context, this.getFlowElement(), this, null));
        block.addMicroInstruction(new MIInsertInstance2Track(false));
        this.addMicroInstruction("BLOCK_ACTIVATE", block);
    }

    @Override
    protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
        this.generateOpenToken(token, scope, element);
    }

    @Override
    protected void generateOpenToken(HashMap<String, Object> token, IScope scope, BPMNCubeElement element) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, this, element.getId(), token);
    }

    @Override
    protected IScopeImpl[] doActivate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl[] iScopes;
        for (IScopeImpl scope : iScopes = super.doActivate(sc, pScope, ctx)) {
            ThreadCountManager.increaseThreadCount((IScope)scope);
        }
        return iScopes;
    }

    @Override
    protected void generateExitTokens(IScope scope) throws CubeException {
    }

    private static String getElementInitiateId(FlowNode element) {
        String result = null;
        if (element.getBpmnType() == BpmnType.RECEIVE_TASK) {
            OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)element.asAnyNode(Conversational.class));
            result = operationReference.getName();
        } else {
            CatchEvent event = (CatchEvent)element.asAnyNode(CatchEvent.class);
            if (event != null) {
                if (event.getEventTriggerType() == EventTriggerType.MESSAGE) {
                    OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)element.asAnyNode(Conversational.class));
                    result = operationReference.getName();
                } else if (event.getEventTriggerType() == EventTriggerType.TIMER) {
                    result = element.getId();
                } else if (event.getEventTriggerType() == EventTriggerType.SIGNAL) {
                    EventDefinition eventDefinition = event.getEventDefinition();
                    assert (eventDefinition != null) : "Event definition for Signal can not be null";
                    result = ((SignalEventDefinition)eventDefinition.as(SignalEventDefinition.class)).getSignal().getEventQName().toString();
                } else if (event.getEventTriggerType() == EventTriggerType.NONE) {
                    result = event.isStart() && ManualInitiatorStartFeature.isUserInitiator((StartEvent)event.asAnyNode(StartEvent.class)) ? "START_EVENT_USER_INITIATE" : "";
                }
            }
        }
        return result;
    }

    public static class NonInitiateEventBasedGatewayBlock<T extends EventBasedGateway>
    extends EventBasedGatewayBlock<T> {
        public NonInitiateEventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T gateway) {
            super(context, idSuffix, name, gateway);
        }
    }

    public static class InitiateEventBasedGatewayBlock<T extends EventBasedGateway>
    extends EventBasedGatewayBlock<T> {
        private static final String TOKEN_SET = "TOKEN_SET";

        public InitiateEventBasedGatewayBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, T gateway) {
            super(context, idSuffix, name, gateway);
        }

        @Override
        protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
            boolean tokenAlreadySet = scope.containsLocally(TOKEN_SET);
            if (!tokenAlreadySet) {
                String initiateId = InitiateEventBasedGatewayBlock.getInstanceInitiateId(ctx);
                List<String> elementInitiateIds = InitiateEventBasedGatewayBlock.getElementInitiateIds(element.getFlowElement());
                if (initiateId != null && elementInitiateIds.contains(initiateId)) {
                    super.activateEntryElement(token, scope, element, ctx);
                    scope.declareAndSet(TOKEN_SET, true);
                }
            }
        }
    }
}

