/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BPELExecutionLogger;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeInstanceObserver;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.ext.bpel.common.BaseBPELCubeBlock;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.blocks.BlockSequenceFlowMetadata;
import oracle.bpm.bpmn.engine.model.blocks.BlockSequenceFlowMetadataSupport;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.tip.pc.infra.exception.collaxa.CubeRuntimeException;

public abstract class BaseBPMNBlock<T extends FlowNode>
extends BaseBPELCubeBlock
implements BPMNCubeElement<T> {
    private boolean boundaryFlowEndElement = false;
    private T flowElement;
    private Map<String, IMicroInstruction> microInstructionsMap = new HashMap<String, IMicroInstruction>();
    private BlockSequenceFlowMetadata sequenceFlowMetadata = new BlockSequenceFlowMetadataSupport();
    private boolean startOfMainFlow = true;
    private String type;
    public static final String BLOCK_ACTIVATE = "BLOCK_ACTIVATE";
    public static final String BLOCK_COMPLETE = "BLOCK_COMPLETE";
    public static final String BLOCK_EXCEPTION = "BLOCK_EXCEPTION";
    public static final String BLOCK_CANCEL = "BLOCK_CANCEL";

    public BaseBPMNBlock(BPMNCubeMapBuilderContext context, T flowElement) {
        this.flowElement = flowElement;
        this.initMicroInstructions(context);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public BlockSequenceFlowMetadata getSequenceFlowMetadata() {
        return this.sequenceFlowMetadata;
    }

    public String[] getEntryTokens() {
        if (this.getSequenceFlowMetadata().getEntryElements().isEmpty()) {
            return super.getEntryTokens();
        }
        return BaseBPMNBlock.convertToEntryTokensArray(this.getSequenceFlowMetadata().getEntryElements());
    }

    @Override
    public void addMicroInstruction(String tag, IMicroInstruction mi) {
        this.microInstructionsMap.put(tag, mi);
    }

    @Override
    public IMicroInstruction getMicroInstruction(String tag) {
        return this.microInstructionsMap.get(tag);
    }

    @Override
    public Map<String, IMicroInstruction> getMicroInstructionMap() {
        return Collections.unmodifiableMap(this.microInstructionsMap);
    }

    public void onComplete(IScopeImpl scope, ICubeContext ctx) {
        int threadCount;
        try {
            threadCount = ThreadCountManager.getThreadCount((IScope)scope);
        }
        catch (CubeException e) {
            throw new CubeRuntimeException((Throwable)e);
        }
        if (threadCount == 0) {
            this.executeProcedureControlledWithoutException((IScope)scope, ctx, BLOCK_COMPLETE, null, null);
        } else {
            this.executeProcedureControlledWithoutException((IScope)scope, ctx, BLOCK_CANCEL, null, null);
        }
        super.onComplete(scope, ctx);
    }

    public boolean handleException(IScope scope, Throwable exception, ICubeContext ctx) throws Exception {
        this.executeProcedureControlledWithoutException(scope, ctx, BLOCK_EXCEPTION, null, exception);
        return super.handleException(scope, exception, ctx);
    }

    @Override
    public T getFlowElement() {
        return this.flowElement;
    }

    @Override
    public boolean isNonMainFlowEndElement() {
        return this.boundaryFlowEndElement;
    }

    @Override
    public void setNonMainFlowEndElement(boolean value) {
        this.boundaryFlowEndElement = value;
    }

    @Override
    public boolean isStartOfMainFlow() {
        return this.startOfMainFlow;
    }

    @Override
    public void setStartOfMainFlow(boolean value) {
        this.startOfMainFlow = value;
    }

    protected void setType(String value) {
        this.type = value;
    }

    protected void initMicroInstructions(BPMNCubeMapBuilderContext context) {
        this.addMicroInstruction(BLOCK_ACTIVATE, new MINop());
        this.addMicroInstruction(BLOCK_COMPLETE, new MINop());
        this.addMicroInstruction(BLOCK_CANCEL, new MINop());
        this.addMicroInstruction(BLOCK_EXCEPTION, new MINop());
    }

    protected void doActivateScope(HashMap<String, Object> token, IScopeImpl scope, ICubeContext ctx) throws CubeException {
        BPMNTokenMetadataUtils.saveActivationToken(token, (IScope)scope);
        this.executeProcedureControlledWithoutException((IScope)scope, ctx, BLOCK_ACTIVATE, null, null);
        for (BPMNCubeElement element : this.getSequenceFlowMetadata().getEntryElements()) {
            this.activateEntryElement(token, (IScope)scope, element, ctx);
        }
    }

    protected void activateEntryElement(HashMap<String, Object> token, IScope scope, BPMNCubeElement element, ICubeContext ctx) throws CubeException {
        if (element.isStartOfMainFlow()) {
            ThreadCountManager.increaseThreadCount((IScope)scope);
        }
        this.generateOpenToken(token, scope, element);
    }

    protected void generateOpenToken(HashMap<String, Object> token, IScope scope, BPMNCubeElement element) throws CubeException {
        BPMNTokenManager.generateOpenToken(scope, null, element.getId(), token);
    }

    protected MicroInstructionContext createMicroInstructionContext(IScope scope, ICubeContext ctx) throws CubeException {
        HashMap<String, Object> nodeActivationContext = BPMNTokenMetadataUtils.getActivationToken(scope);
        return new MicroInstructionContext(ctx, scope, (BPMNCubeElement)this, nodeActivationContext);
    }

    protected Object executeProcedureControlledWithoutException(IScope scope, ICubeContext ctx, String procedure, String procedure_exception, Throwable exception) {
        MicroInstructionContext context;
        try {
            context = this.createMicroInstructionContext(scope, ctx);
        }
        catch (CubeException e) {
            throw new RuntimeException(e);
        }
        context.setLastException(exception);
        return context.executeProcedureControlledWithoutException(procedure, procedure_exception);
    }

    protected IScopeImpl[] activate(IScopeContext sc, IScopeImpl pScope, boolean isCompensable, ICubeContext ctx, int startCounterValue, int finalCounterValue) throws Exception {
        ICubeInstanceObserver obs = sc.getCubeInstance().getObserver();
        ICubeInstanceImpl ci = sc.getCubeInstance();
        int size = finalCounterValue - startCounterValue;
        IScopeImpl[] scs = new IScopeImpl[]{};
        if (size >= 0) {
            scs = new IScopeImpl[size + 1];
            for (int i = 0; i <= size; ++i) {
                BPELExecutionLogger.LOG.debug(this.getClass(), "activate", new Object[]{ci.getComponentDN(), " (pid=", ci.getId(), ") entering <", this.getType(), "/> at line ", this.getLineNumber()});
                IScopeImpl scope = sc.createScope(this.getId(), pScope, sc.getNextScopeId(), false, isCompensable, ctx);
                String sId = scope.getAbsoluteScopeId();
                CubeEngineLogger.LOG.debug(this.getClass(), "activate", new Object[]{"Create scope '", sId, "' in block '", this.getId(), "'"});
                this.__initScope(i + startCounterValue, (IScope)scope, ctx);
                obs.onActivityActivate(this.getName(), scope.getBlockId(), this.getType(), String.valueOf(this.getLineNumber()), (IScope)scope, ctx);
                this.consumeOpenToken(pScope, ctx, this.getId());
                if (i != 0) {
                    ThreadCountManager.increaseThreadCount((IScope)scope.getParentScope());
                }
                scs[i] = scope;
            }
        }
        this.generateOpenTokens(scs, sc, pScope, ctx);
        return scs;
    }

    protected void consumeOpenToken(IScopeImpl pScope, ICubeContext ctx, String id) throws CubeException {
        BPMNTokenManager.consumeOpenToken((IScope)pScope, ctx, id);
    }

    private static String[] convertToEntryTokensArray(List<BPMNCubeElement> list) {
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (BPMNCubeElement element : list) {
            result.add(element.getId());
        }
        return result.toArray(new String[list.size()]);
    }

    private void notifyObserver(IScopeImpl scope, ICubeContext ctx) {
        ICubeInstanceObserver obs = scope.getCubeInstance().getObserver();
        obs.onActivityComplete(this.getName(), scope.getBlockId(), this.getType(), String.valueOf(this.getLineNumber()), (IScope)scope, ctx);
    }
}

