/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.util.EventCountManager;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.HashMap;
import java.util.Queue;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;

public abstract class BaseBPMNActivityBlock<T extends FlowNode>
extends BaseBPMNBlock<T> {
    private String[] exitTokens;

    public BaseBPMNActivityBlock(BPMNCubeMapBuilderContext context, String name, String type, T flowElement) {
        this(context, "", name, type, flowElement);
    }

    public BaseBPMNActivityBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, String type, T flowElement) {
        super(context, flowElement);
        super.setId(flowElement == null ? name + idSuffix : context.getCubeElementId((ProjectObject)flowElement, idSuffix));
        this.setName(name);
        this.setType(type);
    }

    public final String getId() {
        return super.getId();
    }

    public final void setId(String id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExitTokens() {
        BaseBPMNActivityBlock baseBPMNActivityBlock = this;
        synchronized (baseBPMNActivityBlock) {
            if (this.exitTokens == null) {
                this.exitTokens = new String[]{this.getExitToken()};
            }
        }
        return this.exitTokens;
    }

    public IScopeImpl[] activate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl[] iScopes = this.doActivate(sc, pScope, ctx);
        this.initScopes((IScope[])iScopes);
        return iScopes;
    }

    public boolean until(IScope scope, ICubeContext ctx) throws Exception {
        if (EventCountManager.getEventCount((IScope)scope) == 0) {
            boolean result = super.until(scope, ctx);
            return result;
        }
        return false;
    }

    protected IScopeImpl[] doActivate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl[] scs;
        Queue tokenQueue = BPMNTokenManager.getTokenObject((IScope)pScope, this.getId());
        HashMap<String, Object> token = BPMNTokenMetadataUtils.convertToToken(tokenQueue.peek());
        for (IScopeImpl scope : scs = this.activate(sc, pScope, false, ctx)) {
            this.doActivateScope(token, scope, ctx);
        }
        return scs;
    }

    protected void generateOpenTokens(IScopeImpl[] scs, IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
    }

    protected void generateExitTokens(IScope scope) throws CubeException {
        IScope parentScope = scope.getParentScope();
        if (!scope.getBoolean("++exit-block-with-exception")) {
            for (String exitToken : this.getExitTokens()) {
                HashMap<String, Object> tokenMetadata = this.getExitTokenMetadata(scope);
                if (exitToken.equals(this.getParentBlockId())) {
                    this.decreaseThreadCount(parentScope);
                    this.propagetExitTokenMetadata(parentScope, tokenMetadata);
                    continue;
                }
                BPMNTokenManager.generateOpenToken(parentScope, this, exitToken, tokenMetadata);
            }
        }
    }

    protected HashMap<String, Object> getExitTokenMetadata(IScope scope) throws CubeException {
        return (HashMap)scope.getAsObject("EXIT_TOKEN_METADATA");
    }

    protected void propagetExitTokenMetadata(IScope parentScope, HashMap<String, Object> tokenMetadata) throws CubeException {
        if (tokenMetadata != null) {
            parentScope.declareAndSet("EXIT_TOKEN_METADATA", tokenMetadata);
        }
    }

    protected void decreaseThreadCount(IScope scope) throws CubeException {
        if (this.isNonMainFlowEndElement()) {
            EventCountManager.decreaseEventCount((IScope)scope);
        } else {
            ThreadCountManager.decreaseThreadCount((IScope)scope);
        }
    }

    protected void __initScope(IScope scope, ICubeContext ctx) throws Exception {
        super.__initScope(scope, ctx);
        EventCountManager.initEventCount((IScope)scope);
    }

    private String getExitToken() {
        UnconditionalSequenceFlowInfo flowInfo = this.getSequenceFlowMetadata().getOutgoingSequenceFlow();
        String token = flowInfo != null ? flowInfo.getTargetNodeId() : this.getParentBlock().getId();
        return token;
    }

    private void initScopes(IScope[] scopes) throws CubeException {
        for (IScope scope : scopes) {
            scope.declareAndSet("++exit-block-with-exception", false);
        }
    }
}

