/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ConfigurationHelper;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.CubeEngineLogger;
import com.collaxa.cube.engine.EngineException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.CubeInstanceImpl;
import com.collaxa.cube.engine.core.ICubeInstanceImpl;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.core.map.Storage;
import com.collaxa.cube.engine.util.CubeNamespaceContext;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.lang.compiler.bpel.BPELDefs;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.ServiceLink;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.blocks.ProcessToFlowNodeAdapter;
import oracle.bpm.bpmn.engine.model.runtime.common.BPMNRuntimeConstants;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.ConversationUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.runtime.ProcessInstanceAttribute;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.correlations.CorrelationKeyContainer;
import oracle.bpm.util.Locales;
import oracle.fabric.composite.model.PropertyModel;
import oracle.soa.common.util.NonSyncStringBuffer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPMNProcessBlock
extends BaseBPMNBlock<FlowNode> {
    int mInitialStorageSize = 16;
    Storage mStorage;
    private Process model;
    private final Set<ServiceLink> serviceLinks;
    private final Set<ServiceLink> extraServiceLinks;
    private static Boolean DISABLE_PROCESS_INSTANCES_ATTRIBUTES = Boolean.getBoolean("oracle.bpm.runtime.processInstanceAttr.disable");
    private static final String logClassName = BPMNProcessBlock.class.getName();

    public BPMNProcessBlock(BPMNCubeMapBuilderContext context, String id, Process model, Set<ServiceLink> extraServiceLinks) throws CubeException {
        super(context, new ProcessToFlowNodeAdapter(model));
        this.setId(id);
        this.setName(model.getLabel(Locales.getDefaultLocale()));
        this.setType("process");
        this.model = model;
        this.setBit((short)2, true);
        this.extraServiceLinks = extraServiceLinks;
        this.serviceLinks = ConversationUtils.getServiceLinksFromConversations(context, (NodeContainer)model);
    }

    public Process getModel() {
        return this.model;
    }

    public IScopeImpl[] activate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        ICubeInstanceImpl ci = sc.getCubeInstance();
        if (ci.getTitle() == null) {
            NonSyncStringBuffer sb = new NonSyncStringBuffer(128);
            sb.append("Instance #").append(ci.getId()).append(" of ").append(ci.getProcessClass().getScaComponent().getName());
            ci.setTitle(sb.toString());
        }
        CubeEngineLogger.LOG.debug((Object)("BPMNProcessBlock activated for instance " + ci.getTitle()));
        ci.setStatus("initiated");
        pScope.declareAndSet("++default-status", true);
        pScope.declareAndSet("++active-sync-call", null);
        List headers = (List)ctx.getFromEnvironment("__call-headers");
        if (BPMRuntimeLogger.isRuntimeTestEnabled()) {
            for (int i = 0; i < headers.size(); ++i) {
                Element element = (Element)headers.get(i);
                this.lookForLogKey(pScope, element);
            }
        }
        IScopeImpl scImpl = this.__activate(sc, pScope, ctx);
        HashMap<String, Object> token = BPMNTokenMetadataUtils.createNewTokenMetadata((IScope)pScope);
        this.doActivateScope(token, scImpl, ctx);
        return new IScopeImpl[]{scImpl};
    }

    public boolean until(IScope scope, ICubeContext ctx) throws Exception {
        if (ThreadCountManager.getThreadCount((IScope)scope) == 0) {
            CubeEngineLogger.LOG.debug("ProcessBlock", "until", new Object[]{"ProcessBlock '", this.getId(), "' until() true"});
            if (!scope.getBoolean("++default-status")) {
                scope.getCubeInstance().setStatus("completed");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleException(IScope scope, Throwable exception, ICubeContext ctx) throws Exception {
        BPELFault bf;
        super.handleException(scope, exception, ctx);
        if (exception instanceof BPELFault && BPELDefs.QN_ROLLBACK.equals((bf = (BPELFault)exception).getFaultName())) {
            CubeEngineLogger.LOG.error("BPELScopeBlock", "__handleException", new Object[]{"Caught rollbackFault ... throwing exception"});
            throw new EngineException(2180);
        }
        return false;
    }

    public String getInitialTrackingLevel(ICubeContext ctx) throws CubeException {
        ICubeInstanceImpl ci = CubeContextHelper.getCubeInstance((ICubeContext)ctx);
        String level = ConfigurationHelper.getPropertyFromInstance((ICubeInstanceImpl)ci, (String)"auditLevel");
        if (level != null) {
            return level;
        }
        PropertyModel prop = CubeContextHelper.getCubeInstance((ICubeContext)ctx).getProcessClass().getScaComponent().getComposite().getProperty("auditLevel");
        if (prop != null) {
            level = prop.getValue();
        }
        if (level != null) {
            return level;
        }
        level = CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine().getSoaInfraConfig().getAuditConfig().getLevel();
        return level;
    }

    public <T> T adapt(Class<T> clazz) {
        if (clazz == Storage.class) {
            return (T)this.getStorage();
        }
        return (T)super.adapt(clazz);
    }

    public void init(ICubeContext ctx) throws CubeException {
        super.init(ctx);
        Number mapSize = (Number)ctx.getFromEnvironment("__map-size");
        if (mapSize != null) {
            this.mInitialStorageSize = Math.max(16, 0 * mapSize.intValue());
        }
    }

    @Override
    protected void initMicroInstructions(BPMNCubeMapBuilderContext context) {
        super.initMicroInstructions(context);
        MISequenceBlock completeBlock = new MISequenceBlock();
        completeBlock.addMicroInstruction(AuditTrailVisitorHelper.createAndAddPostAuditMI(context, this.getFlowElement(), this, null));
        completeBlock.addMicroInstruction(new MIInsertInstance2Track.MIInsertInstance2TrackProcess("COMPLETED"));
        MISequenceBlock cancelBlock = new MISequenceBlock();
        cancelBlock.addMicroInstruction(AuditTrailVisitorHelper.createAndAddPostAuditMI(context, this.getFlowElement(), this, null, Tag.POST_AUDIT_CANCEL));
        cancelBlock.addMicroInstruction(new MIInsertInstance2Track.MIInsertInstance2TrackProcess("CANCELED"));
        MISequenceBlock exceptionBlock = new MISequenceBlock();
        exceptionBlock.addMicroInstruction(AuditTrailVisitorHelper.createAndAddPostAuditMI(context, this.getFlowElement(), this, null, Tag.POST_AUDIT_EXCEPTION));
        exceptionBlock.addMicroInstruction(new MIInsertInstance2Track.MIInsertInstance2TrackProcess("ERRORED"));
        this.addMicroInstruction("BLOCK_ACTIVATE", AuditTrailVisitorHelper.createAndAddPreAuditMI(context, this.getFlowElement(), this, null));
        this.addMicroInstruction("BLOCK_COMPLETE", completeBlock);
        this.addMicroInstruction("BLOCK_CANCEL", completeBlock);
        this.addMicroInstruction("BLOCK_EXCEPTION", exceptionBlock);
    }

    protected Storage getStorage() {
        if (this.mStorage == null) {
            this.mStorage = new Storage(this.mInitialStorageSize);
        }
        return this.mStorage;
    }

    protected NamespaceContext parentNamespaceContext() {
        return CubeNamespaceContext.EMPTY;
    }

    protected void __initScope(IScope sc, ICubeContext ctx) throws Exception {
        super.__initScope(sc, ctx);
        DataHandlingUtils.declareDataObjects(sc, ctx, (DataDeclarationContainer)this.getModel());
        DataHandlingUtils.declareProjectDataObjects(sc, ctx, this.getModel().getProject());
        ConversationUtils.declareServiceLinks(sc, this.serviceLinks);
        ConversationUtils.declareServiceLinks(sc, this.extraServiceLinks);
        this.__setProcessInstanceAttributes(ctx, sc);
        DataHandlingUtils.declareCorrelationKeys(sc, (CorrelationKeyContainer)this.model);
        this.__initScopeBPEL(sc, ctx);
    }

    protected IScopeImpl __activate(IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        IScopeImpl ms = sc.createScope(this.getId(), pScope, sc.getNextScopeId(), true, false, ctx);
        String sId = ms.getAbsoluteScopeId();
        CubeEngineLogger.LOG.debug("MethodCubeBlock", "activate", new Object[]{"Create method scope '", sId, "' in block '", this.getId(), "'"});
        this.__initScope((IScope)ms, ctx);
        String methodName = "process";
        ms.declareAndSet("_$$method-map", (Object)methodName);
        return ms;
    }

    private void __setProcessInstanceAttributes(ICubeContext ctx, IScope sc) throws CubeException {
        for (ProcessInstanceAttribute attr : ProcessInstanceAttribute.values()) {
            attr.declareAndSetAutoValue(sc, ctx);
        }
    }

    private void lookForLogKey(IScopeImpl pScope, Element element) throws CubeException {
        if (BPMNRuntimeConstants.LOGKEY_HEADER.getNamespaceURI().equals(element.getNamespaceURI()) && BPMNRuntimeConstants.LOGKEY_HEADER.getLocalPart().equals(element.getLocalName())) {
            Node firstChild = element.getFirstChild();
            if (firstChild != null) {
                String logKey = firstChild.getNodeValue();
                if (!logKey.endsWith("-")) {
                    logKey = logKey + "-";
                }
                pScope.declareAndSet("LOG_EXECUTION_PATH_KEY", (Object)logKey);
            }
        } else {
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(0);
                if (!(node instanceof Element)) continue;
                this.lookForLogKey(pScope, (Element)node);
            }
        }
    }

    private void __initScopeBPEL(IScope sc, ICubeContext ctx) throws CubeException {
        Map instProps = sc.getProperties();
        Map props = (Map)ctx.getFromEnvironment("__call-properties");
        if (props != null) {
            instProps.putAll(props);
        }
        List instHeaders = sc.getHeaders();
        List headers = (List)ctx.getFromEnvironment("__call-headers");
        if (headers != null) {
            for (int i = 0; i < headers.size(); ++i) {
                Element header = (Element)headers.get(i);
                instHeaders.add(header);
            }
        }
        CubeInstanceImpl ci = (CubeInstanceImpl)sc.getCubeInstance();
        ci.setParentRefId((String)sc.getProperties().get("tracking.parentReferenceId"));
        Object obj = instProps.get("priority");
        try {
            if (obj != null) {
                ci.setPriority(Integer.parseInt(String.valueOf(obj)));
            }
        }
        catch (Exception e) {
            CubeEngineLogger.LOG.debug("ProcessBlock", "initializeHeader", new Object[]{"For instance '", this.getId(), "' cannot set priority to '", obj, "'"});
        }
    }
}

