/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IScopeContext;
import com.collaxa.cube.engine.core.IScopeImpl;
import com.collaxa.cube.engine.util.ThreadCountManager;
import com.collaxa.cube.engine.util.TokenManager;
import com.oracle.bpel.client.BPELFault;
import java.util.HashMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.model.blocks.ScopeBlock;
import oracle.bpm.bpmn.engine.model.runtime.MultiInstanceRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenManager;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNTokenMetadataUtils;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.MultiInstance;

public class BPMNMultiInstanceInnerBlock
extends ScopeBlock<Activity> {
    private MultiInstanceRuntimeHelper runtimeHelper;

    public BPMNMultiInstanceInnerBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, Activity activity, MultiInstance multiInstance) {
        super(context, idSuffix, name, activity);
        this.runtimeHelper = new MultiInstanceRuntimeHelper((FlowNode)activity, multiInstance);
    }

    public MultiInstanceRuntimeHelper getRuntimeHelper() {
        return this.runtimeHelper;
    }

    @Override
    protected void consumeOpenToken(IScopeImpl pScope, ICubeContext ctx, String id) throws CubeException {
        TokenManager.consumeOpenToken((IScope)pScope, (String)id);
    }

    @Override
    protected void __initScope(int index, IScope sc, ICubeContext ctx) throws Exception {
        super.__initScope(sc, ctx);
        if (this.getRuntimeHelper().isParallel()) {
            this.getRuntimeHelper().getLoopCounterInstanceAttribute().declareAndSet(sc, ctx, index);
        }
    }

    @Override
    protected int getFinalCounterValue(IScope scope, ICubeContext ctx) throws CubeException {
        int result = this.getRuntimeHelper().isParallel() ? this.getRuntimeHelper().getNumberOfInstancesInstanceAttribute().getValue(scope, ctx).intValue() : super.getFinalCounterValue(scope, ctx);
        return result;
    }

    protected boolean __handleException(IScope scope, Throwable exception, ICubeContext ctx) throws Exception {
        boolean isCompletionSignal;
        super.__handleException(scope, exception, ctx);
        boolean bl = isCompletionSignal = exception instanceof BPELFault && MultiInstanceRuntimeHelper.COMPLETIONCONDITIONSIGNAL.equals(((BPELFault)exception).getFaultName());
        if (!isCompletionSignal) {
            int numberOfTerminatedInstances = this.getRuntimeHelper().getNumberOfTerminatedInstancesInstanceAttribute().getValue(scope, ctx);
            this.getRuntimeHelper().getNumberOfTerminatedInstancesInstanceAttribute().setValue(scope, ctx, numberOfTerminatedInstances + 1);
            int numberOfActiveInstances = this.getRuntimeHelper().getNumberOfActiveInstancesInstanceAttribute().getValue(scope, ctx);
            this.getRuntimeHelper().getNumberOfActiveInstancesInstanceAttribute().setValue(scope, ctx, numberOfActiveInstances - 1);
            if (((MultiInstance)this.getRuntimeHelper().getCharacteristics()).hasCompletionCondition()) {
                boolean completionCondition = this.getRuntimeHelper().evaluateCompletionCondition(scope, ctx);
                if (this.getRuntimeHelper().isSequential()) {
                    this.getRuntimeHelper().getCompletionConditionInstanceAttribute().setValue(scope, ctx, completionCondition);
                } else if (completionCondition) {
                    return false;
                }
            }
            String targetNodeId = this.getSequenceFlowMetadata().getOutgoingSequenceFlow().getTargetNodeId();
            HashMap token = (HashMap)ctx.getFromEnvironment("__node_activation-context");
            int thread = BPMNTokenMetadataUtils.getThreadFromTokenMetadata(token);
            int parentThread = BPMNTokenMetadataUtils.getParentThreadFromTokenMetadata(token);
            int step = BPMNTokenMetadataUtils.getStepFromTokenMetadata(token) + 1;
            String activationIds = BPMNTokenMetadataUtils.getActivationIdsFromTokenMetadata(token);
            BPMNTokenManager.generateOpenToken(scope.getParentScope(), this, targetNodeId, activationIds, parentThread, thread, step);
            if (this.getRuntimeHelper().isParallel()) {
                this.decreaseThreadCount(scope.getParentScope());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void propagetExitTokenMetadata(IScope parentScope, HashMap<String, Object> tokenMetadata) throws CubeException {
        if (!parentScope.containsLocally("EXIT_TOKEN_METADATA")) {
            super.propagetExitTokenMetadata(parentScope, tokenMetadata);
        }
    }

    @Override
    protected void doActivateScope(HashMap<String, Object> token, IScopeImpl scope, ICubeContext ctx) throws CubeException {
        HashMap<String, Object> innerToken;
        if (this.getRuntimeHelper().isParallel()) {
            innerToken = new HashMap();
            innerToken.putAll(token);
            innerToken.put("PARENT_THREAD", BPMNTokenMetadataUtils.getThreadFromTokenMetadata(token));
            innerToken.put("THREAD", BPMNTokenMetadataUtils.getNewThreadNumber((IScope)scope));
        } else {
            innerToken = token;
        }
        super.doActivateScope(innerToken, scope, ctx);
    }

    @Override
    protected void generateOpenTokens(IScopeImpl[] scs, IScopeContext sc, IScopeImpl pScope, ICubeContext ctx) throws Exception {
        super.generateOpenTokens(scs, sc, pScope, ctx);
        if (scs.length == 0) {
            ThreadCountManager.decreaseThreadCount((IScope)pScope);
            return;
        }
    }
}

