/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model.blocks;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.model.blocks.ScopeBlock;
import oracle.bpm.bpmn.engine.model.runtime.LoopRuntimeHelper;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Loop;

public class BPMNLoopBlock
extends ScopeBlock<Activity> {
    private LoopRuntimeHelper loopRuntimeHelper;

    protected BPMNLoopBlock(BPMNCubeMapBuilderContext context, String idSuffix, String name, Activity activity, Loop loop) {
        super(context, idSuffix, name, activity);
        this.loopRuntimeHelper = new LoopRuntimeHelper((FlowNode)activity, loop);
    }

    public LoopRuntimeHelper getRuntimeHelper() {
        return this.loopRuntimeHelper;
    }

    @Override
    protected void __initScope(int index, IScope sc, ICubeContext ctx) throws Exception {
        super.__initScope(sc, ctx);
        int loopCounter = this.getRuntimeHelper().isTestBefore() ? 0 : 1;
        this.getRuntimeHelper().getLoopCounterInstanceAttribute().declareAndSet(sc, ctx, loopCounter);
    }

    @Override
    protected void initMicroInstructions(BPMNCubeMapBuilderContext context) {
        super.initMicroInstructions(context);
        this.addMicroInstruction("BLOCK_ACTIVATE", AuditTrailVisitorHelper.createAndAddPreAuditMI(context, this.getFlowElement(), this, null, Tag.PRE_AUDIT_CHARACTERIC));
        this.addMicroInstruction("BLOCK_COMPLETE", AuditTrailVisitorHelper.createAndAddPostAuditMI(context, this.getFlowElement(), this, null, Tag.POST_NORMAL_AUDIT_CHARACTERIC));
        this.addMicroInstruction("BLOCK_CANCEL", AuditTrailVisitorHelper.createAndAddPostAuditMI(context, this.getFlowElement(), this, null, Tag.POST_CANCEL_AUDIT_CHARACTERIC));
        this.addMicroInstruction("BLOCK_EXCEPTION", AuditTrailVisitorHelper.createAndAddPostAuditMI(context, this.getFlowElement(), this, null, Tag.POST_EXCEPTION_AUDIT_CHARACTERIC));
    }
}

