/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.xml.schema.XMLSchemaUtils;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import oracle.bpm.bpmn.engine.model.RulesCalendar;
import oracle.bpm.bpmn.engine.model.ScheduleEntryToCronExpression;
import oracle.bpm.bpmn.engine.model.SchedulingLogger;
import oracle.bpm.bpmn.engine.model.TimerStartEventListener;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMNNamespaceContext;
import oracle.bpm.bpmn.engine.model.runtime.util.SchedulingHelper;
import oracle.bpm.bpmn.engine.runtime.DeploymentDescriptorUtil;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathFunctionResolver;
import oracle.bpm.bpmn.engine.runtime.xpath.BPMNXPathUtil;
import oracle.bpm.bpmn.engine.service.BPMNServiceEngine;
import oracle.bpm.bpmn.engine.service.ClassloaderHelper;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.OutOfCalendarPolicy;
import oracle.bpm.project.model.RescheduleRestrictionsPolicy;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.features.TimerFeature;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.services.organization.model.OrganizationalUnit;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerFactory;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerService;
import oracle.integration.platform.blocks.scheduler.StringProperties;

public class TimerStartEventScheduler {
    public static final String START_DATE = "START_DATE";
    public static final String END_DATE = "END_DATE";
    public static final String CALENDAR = "CALENDAR";
    public static final String OUT_OF_CALENDAR_POLICY = "OUT_OF_CALENDAR_POLICY";
    public static final String DATE_PATTERN = "yyyy.MM.dd.HH.mm.ss";
    public static final String NO_DATE = "NO_DATE";
    public static final String NO_CALENDAR = "NO_CALENDAR";

    public static void schedule(ICubeContext ctx, String compositeDN, String componentName, Collection<CatchEvent> timerEvents) {
        for (CatchEvent timerEvent : timerEvents) {
            String ou;
            String timerStartEventId = timerEvent.getId();
            StringProperties stringProperties = new StringProperties();
            stringProperties.put((Object)"COMPONENT_NAME", (Object)componentName);
            stringProperties.put((Object)"START_TIMER_ID", (Object)timerStartEventId);
            TimerEventDefinition timerEventDefinition = (TimerEventDefinition)timerEvent.getEventDefinition().as(TimerEventDefinition.class);
            Schedule schedule = timerEventDefinition.getSchedule();
            TimerEventDefinition.OptionalFeatures optionalFeatures = timerEventDefinition.getOptionalFeatures();
            Date startDate = optionalFeatures.getStartDate() != null ? optionalFeatures.getStartDate().getDateValue() : null;
            Date endDate = optionalFeatures.getEndDate() != null ? optionalFeatures.getEndDate().getDateValue() : null;
            boolean isUsingCalendar = optionalFeatures.isUseCalendarRules();
            OutOfCalendarPolicy outOfCalendarPolicy = optionalFeatures.getOutOfCalendarPolicy();
            RescheduleRestrictionsPolicy rescheduleRestrictionsPolicy = optionalFeatures.getRescheduleRestrictionsPolicy();
            String calendar = null;
            if (isUsingCalendar && !Str.isEmpty((String)(ou = DeploymentDescriptorUtil.getBPMOrganization(compositeDN).getProcessOrganizationalUnitName()))) {
                List organizationalUnitList = DeploymentDescriptorUtil.getBPMOrganization(compositeDN).getOrganizationalUnits().getOrganizationalUnit();
                for (OrganizationalUnit organizationalUnit : organizationalUnitList) {
                    if (!organizationalUnit.getOrganizationalUnitName().equals(ou) || organizationalUnit.getCalendarRuleName() == null) continue;
                    calendar = RulesCalendar.buildName(compositeDN, organizationalUnit.getCalendarRuleName());
                    break;
                }
            }
            SchedulingLogger.log("-------------");
            SchedulingLogger.log("Start date: " + startDate);
            SchedulingLogger.log("End date: " + endDate);
            SchedulingLogger.log("Calendar: " + calendar);
            if (calendar != null) {
                SchedulingLogger.log("Rescheduling policy: " + outOfCalendarPolicy.getString());
                SchedulingLogger.log("Rescheduling restrictions: " + rescheduleRestrictionsPolicy.getString());
            }
            SchedulingLogger.log("-------------");
            int uniqueSufix = 1;
            if (schedule == null) {
                Expression cycleExpression = ((TimerFeature)timerEvent.getFeature(TimerFeature.class)).getTimeCycleExpression();
                Expression timeDateExpression = ((TimerFeature)timerEvent.getFeature(TimerFeature.class)).getTimeDateExpression();
                if (startDate != null || endDate != null || isUsingCalendar) {
                    SimpleDateFormat formatter = new SimpleDateFormat(DATE_PATTERN);
                    stringProperties.put((Object)START_DATE, (Object)(startDate != null ? formatter.format(startDate) : NO_DATE));
                    stringProperties.put((Object)END_DATE, (Object)(endDate != null ? formatter.format(endDate) : NO_DATE));
                    if (calendar != null) {
                        stringProperties.put((Object)CALENDAR, (Object)calendar);
                        stringProperties.put((Object)OUT_OF_CALENDAR_POLICY, (Object)outOfCalendarPolicy.toString());
                    } else {
                        stringProperties.put((Object)CALENDAR, (Object)NO_CALENDAR);
                    }
                    SchedulingHelper.schedule(compositeDN, TimerStartEventScheduler.buildJobName(componentName, timerStartEventId, uniqueSufix), stringProperties, TimerStartEventScheduler.getExpirationDate(ctx, stringProperties, cycleExpression, timeDateExpression), startDate, endDate, calendar, outOfCalendarPolicy, TimerStartEventListener.class, false);
                    continue;
                }
                SchedulingHelper.schedule(compositeDN, TimerStartEventScheduler.buildJobName(componentName, timerStartEventId, uniqueSufix), stringProperties, TimerStartEventScheduler.getExpirationDate(ctx, stringProperties, cycleExpression, timeDateExpression), TimerStartEventListener.class, false);
                continue;
            }
            if (rescheduleRestrictionsPolicy == RescheduleRestrictionsPolicy.EACH_ENTRY_AS_DIFFERENT_EVENT || !ClassloaderHelper.isLoaded("oracle.bpm.runtime.quartz.trigger.UniqueTriggerWithReschedule")) {
                for (ScheduleEntry scheduleEntry : schedule.getAllEntries()) {
                    String cronExpression = ScheduleEntryToCronExpression.toCronExpression(scheduleEntry);
                    SchedulingHelper.schedule(compositeDN, TimerStartEventScheduler.buildJobName(componentName, timerStartEventId, uniqueSufix), stringProperties, cronExpression, startDate, endDate, calendar, outOfCalendarPolicy, TimerStartEventListener.class, false);
                    ++uniqueSufix;
                }
                continue;
            }
            LinkedList<String> cronExpressions = new LinkedList<String>();
            for (ScheduleEntry scheduleEntry : schedule.getAllEntries()) {
                String cronExpression = ScheduleEntryToCronExpression.toCronExpression(scheduleEntry);
                cronExpressions.add(cronExpression);
            }
            SchedulingHelper.schedule(compositeDN, TimerStartEventScheduler.buildJobName(componentName, timerStartEventId, uniqueSufix), stringProperties, cronExpressions, startDate, endDate, calendar, outOfCalendarPolicy, TimerStartEventListener.class, false);
        }
    }

    public static void updateSchedulers(String compositeDN, String componentName, Collection<CatchEvent> timerEvents, boolean pause) {
        for (CatchEvent timerEvent : timerEvents) {
            String timerStartEventId = timerEvent.getId();
            TimerStartEventScheduler.updateScheduler(compositeDN, componentName, timerStartEventId, pause);
        }
    }

    public static void updateScheduler(String compositeDN, String componentName, String timerStartEventId, boolean pause) {
        FabricSchedulerService schd = FabricSchedulerFactory.getInstance().getSchedulerService();
        int uniqueSufix = 1;
        if (pause) {
            schd.pauseJob(TimerStartEventScheduler.buildJobName(componentName, timerStartEventId, uniqueSufix), compositeDN);
        } else {
            schd.resumeJob(TimerStartEventScheduler.buildJobName(componentName, timerStartEventId, uniqueSufix), compositeDN);
        }
    }

    public static Date getExpirationDate(ICubeContext ctx, StringProperties props, Expression cycleExpression, Expression timeDateExpression) {
        Expression xpathExpression = cycleExpression != null ? cycleExpression : timeDateExpression;
        String expressionResult = null;
        try {
            expressionResult = TimerStartEventScheduler.evalXPath(ctx, xpathExpression);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (CubeException e) {
            e.printStackTrace();
        }
        Date expDate = null;
        if (expressionResult != null) {
            if (cycleExpression != null) {
                long duration = XMLSchemaUtils.parseDuration((String)expressionResult);
                expDate = new Date(System.currentTimeMillis() + duration);
                props.put((Object)"CYCLE_EXPRESSION_PROPERTY", (Object)cycleExpression.getExpressionValue());
                for (Map.Entry entry : cycleExpression.getNamespaces().entrySet()) {
                    props.put((Object)("xmlns:" + (String)entry.getKey()), (Object)((URI)entry.getValue()).toString());
                }
            } else if (timeDateExpression != null) {
                expDate = XMLSchemaUtils.parseDateTime((String)expressionResult).getTime();
            }
        }
        return expDate;
    }

    private static String buildJobName(String componentName, String timerStartEventId, int uniqueSufix) {
        return componentName + "." + timerStartEventId + "." + uniqueSufix;
    }

    private static String evalXPath(ICubeContext ctx, Expression expression) throws XPathExpressionException, CubeException {
        XPath xpath = BPMNXPathUtil.getXPath((NamespaceContext)new BPMNNamespaceContext(expression.getNamespaces()));
        xpath.setXPathFunctionResolver((XPathFunctionResolver)((Object)TimerStartEventScheduler.getFunctionResolver(ctx)));
        return (String)BPMNXPathUtil.evaluate(expression.getExpressionValue(), xpath, ctx, XPathConstants.STRING, null);
    }

    private static BPMNXPathFunctionResolver getFunctionResolver(ICubeContext ctx) throws CubeException {
        return ((BPMNServiceEngine)CubeContextHelper.getServerManager((ICubeContext)ctx).getCubeServiceEngine()).getBPMNXPathFunctionResolver();
    }
}

