/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.CubeContextFactory;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.dispatch.DispatchHelper;
import com.collaxa.cube.engine.dispatch.message.IMessage;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.bpmn.engine.model.TimerStartEventScheduler;
import oracle.bpm.bpmn.engine.model.runtime.util.SchedulingHelper;
import oracle.bpm.bpmn.engine.service.CreateComponentInstanceMessage;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.OutOfCalendarPolicy;
import oracle.dms.context.ExecutionContext;
import oracle.integration.platform.blocks.scheduler.SchedulerJob;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import oracle.soa.management.ComponentDN;

public class TimerStartEventListener
implements SchedulerJob {
    public static final String CYCLE_EXPRESSION_PROPERTY = "CYCLE_EXPRESSION_PROPERTY";
    public static final String COMPONENT_NAME = "COMPONENT_NAME";
    public static final String START_TIMER_ID = "START_TIMER_ID";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String compositeDN, String key, StringProperties stringProperties) {
        block7: {
            ICubeContext ctx = null;
            String timerStartEventId = stringProperties.get(START_TIMER_ID);
            String componentName = stringProperties.get(COMPONENT_NAME);
            ExecutionContext.get();
            ExecutionContext.deactivateContext();
            ExecutionContext.get();
            try {
                try {
                    ctx = CubeContextFactory.newInstance().create("bpmn");
                }
                catch (CubeException e) {
                    e.printStackTrace();
                }
                if (ctx == null) break block7;
                try {
                    this.createInstance(ctx, compositeDN, componentName, timerStartEventId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.scheduleAgain(ctx, compositeDN, key, stringProperties);
            }
            finally {
                ExecutionContext.deactivateContext();
            }
        }
    }

    private void createInstance(ICubeContext ctx, String compositeDN, String componentName, String timerStartEventId) throws Exception {
        ComponentDN componentId = new ComponentDN(compositeDN, componentName);
        Properties properties = this.prepareTrackingProperties();
        CreateComponentInstanceMessage em = new CreateComponentInstanceMessage(componentId, "bpmn", timerStartEventId, properties);
        DispatchHelper.scheduleLocal((IMessage)em, (ICubeContext)ctx);
    }

    private Properties prepareTrackingProperties() {
        Properties properties = new Properties();
        properties.put("tracking.ecwrap", ExecutionContext.wrapContext());
        return properties;
    }

    private void scheduleAgain(ICubeContext ctx, String compositeDN, String key, StringProperties stringProperties) {
        String cycleExpression = stringProperties.get(CYCLE_EXPRESSION_PROPERTY);
        if (cycleExpression != null) {
            HashMap<String, URI> namespaces = new HashMap<String, URI>();
            for (Map.Entry entry : stringProperties.entrySet()) {
                if (!((String)entry.getKey()).startsWith("xmlns:")) continue;
                String prefix = ((String)entry.getKey()).substring("xmlns:".length());
                URI uri = URI.create((String)entry.getValue());
                namespaces.put(prefix, uri);
            }
            XPathExpression xpathCycleExpression = new XPathExpression(cycleExpression, namespaces);
            if (stringProperties.contains((Object)"START_DATE")) {
                String startDateString = stringProperties.get("START_DATE");
                String endDateString = stringProperties.get("END_DATE");
                Date startDate = null;
                Date endDate = null;
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
                    startDate = !startDateString.equals("NO_DATE") ? formatter.parse(startDateString) : null;
                    endDate = !endDateString.equals("NO_DATE") ? formatter.parse(endDateString) : null;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                String calendarString = stringProperties.get("CALENDAR");
                String calendar = null;
                OutOfCalendarPolicy outOfCalendarPolicy = null;
                if (!calendarString.equals("NO_CALENDAR")) {
                    calendar = calendarString;
                    outOfCalendarPolicy = OutOfCalendarPolicy.valueOf((String)stringProperties.get("OUT_OF_CALENDAR_POLICY"));
                }
                SchedulingHelper.schedule(compositeDN, key, stringProperties, TimerStartEventScheduler.getExpirationDate(ctx, stringProperties, (Expression)xpathCycleExpression, null), startDate, endDate, calendar, outOfCalendarPolicy, TimerStartEventListener.class, true);
            } else {
                SchedulingHelper.schedule(compositeDN, key, stringProperties, TimerStartEventScheduler.getExpirationDate(ctx, stringProperties, (Expression)xpathCycleExpression, null), TimerStartEventListener.class, true);
            }
        }
    }
}

