/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class SchedulingLogger {
    private static Logger logger;

    public static void log(String msg) {
        if (SchedulingLogger.hasToLog()) {
            logger.log(Level.ALL, msg);
        }
    }

    private static boolean hasToLog() {
        return Boolean.parseBoolean(System.getProperty("log.scheduling"));
    }

    static {
        if (SchedulingLogger.hasToLog()) {
            logger = Logger.getAnonymousLogger();
            logger.setLevel(Level.ALL);
            try {
                FileHandler handler = new FileHandler(File.createTempFile("scheduling", ".log").getAbsolutePath());
                handler.setFormatter(new MySimpleFormatter());
                logger.addHandler(handler);
                handler.setLevel(Level.ALL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MySimpleFormatter
    extends SimpleFormatter {
        private MySimpleFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            return "[" + record.getLevel() + "]: " + record.getMessage() + "\n";
        }
    }
}

