/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import oracle.bpm.bpmn.engine.service.ClassloaderHelper;
import oracle.bpm.project.model.OutOfCalendarPolicy;
import oracle.bpm.runtime.classloader.util.ContextClassloaderProxy;
import oracle.bpm.runtime.quartz.trigger.MultipleTriggerWithReschedule;
import oracle.bpm.runtime.quartz.trigger.ReschedulingPolicy;
import oracle.bpm.runtime.quartz.trigger.TriggerWithReschedule;
import oracle.bpm.runtime.quartz.trigger.TriggerWithRescheduleListener;
import oracle.bpm.runtime.quartz.trigger.UniqueCronTriggerWithReschedule;
import oracle.bpm.runtime.quartz.trigger.UniqueSimpleTriggerWithReschedule;
import oracle.fabric.common.FabricException;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerFactory;
import oracle.integration.platform.blocks.scheduler.FabricSchedulerService;
import oracle.integration.platform.blocks.scheduler.ScheduledJob;
import oracle.integration.platform.blocks.scheduler.StringProperties;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class SchedulerServiceHelper {
    public static final String NEW_QUARTZ_CLASS = "oracle.bpm.runtime.quartz.trigger.UniqueTriggerWithReschedule";
    private static final String JOB_NAME = "Soa-";

    public static void addJob(FabricSchedulerService fabricSchedulerService, String jobName, String jobGroup, StringProperties opaqueProperties, Trigger trigger, Class scheduleJobClass) throws SchedulerException {
        SchedulerServiceHelper.getScheduler(fabricSchedulerService).scheduleJob(SchedulerServiceHelper.createJobDetail(jobName, jobGroup, scheduleJobClass, opaqueProperties), trigger);
    }

    public static void deleteJob(FabricSchedulerService fabricSchedulerService, String compositeDN, String key) throws SchedulerException {
        SchedulerServiceHelper.getScheduler(fabricSchedulerService).deleteJob(key, compositeDN);
    }

    public static void addCalendar(FabricSchedulerService fabricSchedulerService, String name, Calendar calendar, Boolean replace, Boolean updateTriggers) throws SchedulerException {
        Calendar proxy = (Calendar)ContextClassloaderProxy.createProxy(Calendar.class, (Object)calendar);
        SchedulerServiceHelper.getScheduler(fabricSchedulerService).addCalendar(name, proxy, replace.booleanValue(), updateTriggers.booleanValue());
    }

    public static void scheduleJob(FabricSchedulerService fabricSchedulerService, String compositeDN, String key, StringProperties opaqueProperties, List<String> cronExpressions, Date startTime, Date endTime, String calendar, OutOfCalendarPolicy outOfCalendarPolicy, Class scheduleJobClass) throws FabricException {
        String jobGroup;
        String jobName = key == null ? JOB_NAME : key;
        String string = jobGroup = compositeDN == null ? "DEFAULT" : compositeDN;
        if (jobGroup.equals("")) {
            jobGroup = "DEFAULT";
        }
        SchedulerServiceHelper.Log("Schedule job request " + jobName + ":" + jobGroup + ":" + cronExpressions + "\n" + SchedulerServiceHelper.listProperties(opaqueProperties));
        try {
            LinkedList<CronTrigger> listCronTrigger = new LinkedList<CronTrigger>();
            for (String cronExpression : cronExpressions) {
                CronTrigger cronTrigger = new CronTrigger(jobName, jobGroup, cronExpression);
                listCronTrigger.add(cronTrigger);
            }
            MultipleTriggerWithReschedule multipleTriggerWithReschedule = new MultipleTriggerWithReschedule(listCronTrigger);
            SchedulerServiceHelper.setUpCalendar(fabricSchedulerService, (TriggerWithReschedule)multipleTriggerWithReschedule, calendar, outOfCalendarPolicy);
            SchedulerServiceHelper.setUpStartEndTime((Trigger)multipleTriggerWithReschedule, startTime, endTime);
            SchedulerServiceHelper.addJob(fabricSchedulerService, jobName, jobGroup, opaqueProperties, (Trigger)multipleTriggerWithReschedule, scheduleJobClass);
        }
        catch (ObjectAlreadyExistsException e) {
            SchedulerServiceHelper.unscheduleJob(fabricSchedulerService, compositeDN, key);
            SchedulerServiceHelper.scheduleJob(fabricSchedulerService, compositeDN, key, opaqueProperties, cronExpressions, startTime, endTime, calendar, outOfCalendarPolicy, scheduleJobClass);
        }
        catch (SchedulerException e) {
            SchedulerServiceHelper.Log("Schedule cron job Failed with SchedulerException: " + FabricSchedulerFactory.getStackTrace((Throwable)e));
            throw new FabricException("Schedule cron job failed with SchedulerException...", (Throwable)e);
        }
        catch (ParseException e) {
            SchedulerServiceHelper.Log("Schedule cron job Failed with ParseException: " + FabricSchedulerFactory.getStackTrace((Throwable)e));
            throw new FabricException("Schedule cron job failed with ParseException...", (Throwable)e);
        }
    }

    public static void scheduleJob(FabricSchedulerService fabricSchedulerService, String compositeDN, String key, StringProperties opaqueProperties, String cronExpression, Date startTime, Date endTime, String calendar, OutOfCalendarPolicy outOfCalendarPolicy, Class scheduleJobClass) throws FabricException {
        String jobGroup;
        String jobName = key == null ? JOB_NAME : key;
        String string = jobGroup = compositeDN == null ? "DEFAULT" : compositeDN;
        if (jobGroup.equals("")) {
            jobGroup = "DEFAULT";
        }
        SchedulerServiceHelper.Log("Schedule job request " + jobName + ":" + jobGroup + ":" + cronExpression + "\n" + SchedulerServiceHelper.listProperties(opaqueProperties));
        try {
            CronTrigger trigger;
            if (ClassloaderHelper.isLoaded(NEW_QUARTZ_CLASS) && calendar != null && Arrays.asList(SchedulerServiceHelper.getScheduler(fabricSchedulerService).getCalendarNames()).contains(calendar)) {
                UniqueCronTriggerWithReschedule uniqueCronTriggerWithReschedule = new UniqueCronTriggerWithReschedule(new CronTrigger(jobName, jobGroup, cronExpression));
                SchedulerServiceHelper.setUpCalendar(fabricSchedulerService, (TriggerWithReschedule)uniqueCronTriggerWithReschedule, calendar, outOfCalendarPolicy);
                trigger = uniqueCronTriggerWithReschedule;
            } else {
                trigger = new CronTrigger(jobName, jobGroup, cronExpression);
            }
            SchedulerServiceHelper.setUpStartEndTime((Trigger)trigger, startTime, endTime);
            SchedulerServiceHelper.addJob(fabricSchedulerService, jobName, jobGroup, opaqueProperties, (Trigger)trigger, scheduleJobClass);
        }
        catch (ObjectAlreadyExistsException oae) {
            SchedulerServiceHelper.unscheduleJob(fabricSchedulerService, compositeDN, key);
            SchedulerServiceHelper.scheduleJob(fabricSchedulerService, compositeDN, key, opaqueProperties, cronExpression, startTime, endTime, calendar, outOfCalendarPolicy, scheduleJobClass);
        }
        catch (SchedulerException e) {
            SchedulerServiceHelper.Log("Schedule cron job Failed with SchedulerException: " + FabricSchedulerFactory.getStackTrace((Throwable)e));
            throw new FabricException("Schedule cron job failed with SchedulerException...", (Throwable)e);
        }
        catch (ParseException e) {
            SchedulerServiceHelper.Log("Schedule cron job Failed with ParseException: " + FabricSchedulerFactory.getStackTrace((Throwable)e));
            throw new FabricException("Schedule cron job failed with ParseException...", (Throwable)e);
        }
    }

    public static void scheduleJob(FabricSchedulerService fabricSchedulerService, String compositeDN, String key, StringProperties opaqueProperties, Date expDate, Date startTime, Date endTime, String calendar, OutOfCalendarPolicy outOfCalendarPolicy, Class scheduleJobClass) throws FabricException {
        String jobGroup;
        String jobName = key == null ? JOB_NAME : key;
        String string = jobGroup = compositeDN == null ? "DEFAULT" : compositeDN;
        if (jobGroup.equals("")) {
            jobGroup = "DEFAULT";
        }
        SchedulerServiceHelper.Log("Schedule job request " + jobName + ":" + jobGroup + ":" + expDate.getTime() + "\n" + SchedulerServiceHelper.listProperties(opaqueProperties));
        try {
            SimpleTrigger trigger;
            if (ClassloaderHelper.isLoaded(NEW_QUARTZ_CLASS) && calendar != null && Arrays.asList(SchedulerServiceHelper.getScheduler(fabricSchedulerService).getCalendarNames()).contains(calendar)) {
                UniqueSimpleTriggerWithReschedule uniqueSimpleTriggerWithReschedule = new UniqueSimpleTriggerWithReschedule(new SimpleTrigger(jobName, jobGroup, expDate));
                SchedulerServiceHelper.setUpCalendar(fabricSchedulerService, (TriggerWithReschedule)uniqueSimpleTriggerWithReschedule, calendar, outOfCalendarPolicy);
                trigger = uniqueSimpleTriggerWithReschedule;
            } else {
                trigger = new SimpleTrigger(jobName, jobGroup, expDate);
            }
            SchedulerServiceHelper.setUpStartEndTime((Trigger)trigger, startTime, endTime);
            SchedulerServiceHelper.addJob(fabricSchedulerService, jobName, jobGroup, opaqueProperties, (Trigger)trigger, scheduleJobClass);
        }
        catch (ObjectAlreadyExistsException oae) {
            SchedulerServiceHelper.unscheduleJob(fabricSchedulerService, compositeDN, key);
            SchedulerServiceHelper.scheduleJob(fabricSchedulerService, compositeDN, key, opaqueProperties, expDate, startTime, endTime, calendar, outOfCalendarPolicy, scheduleJobClass);
        }
        catch (SchedulerException e) {
            SchedulerServiceHelper.Log("Schedule cron Failed with SchedulerException: " + FabricSchedulerFactory.getStackTrace((Throwable)e));
            throw new FabricException("Schedule job failed with SchedulerException...", (Throwable)e);
        }
    }

    public static void unscheduleJob(FabricSchedulerService fabricSchedulerService, String compositeDN, String key) throws FabricException {
        SchedulerServiceHelper.Log("Start unschedule Job " + key + ":" + compositeDN);
        if (key == null) {
            key = JOB_NAME;
        }
        if (compositeDN == null) {
            compositeDN = "DEFAULT";
        }
        if (compositeDN.equals("")) {
            compositeDN = "DEFAULT";
        }
        try {
            SchedulerServiceHelper.deleteJob(fabricSchedulerService, compositeDN, key);
            SchedulerServiceHelper.Log("Done unschedule Job " + key + ":" + compositeDN);
        }
        catch (SchedulerException e) {
            SchedulerServiceHelper.Log("UnSchedule cron job Failed with SchedulerException: " + FabricSchedulerFactory.getStackTrace((Throwable)e));
            throw new FabricException("Unschedule job failed...", (Throwable)e);
        }
    }

    private static void addListener(FabricSchedulerService fabricSchedulerService, TriggerListener triggerListener) throws SchedulerException {
        SchedulerServiceHelper.getScheduler(fabricSchedulerService).addTriggerListener(triggerListener);
    }

    private static void setUpCalendar(FabricSchedulerService fabricSchedulerService, TriggerWithReschedule triggerWithReschedule, String calendar, OutOfCalendarPolicy outOfCalendarPolicy) throws SchedulerException {
        triggerWithReschedule.setCalendarName(calendar);
        triggerWithReschedule.setReschedulingPolicy(SchedulerServiceHelper.outOfCalendarToReschedulingPolicy(outOfCalendarPolicy));
        SchedulerServiceHelper.setUpTrigger(fabricSchedulerService, (Trigger)triggerWithReschedule);
    }

    private static void setUpTrigger(FabricSchedulerService fabricSchedulerService, Trigger trigger) throws SchedulerException {
        TriggerWithRescheduleListener cronTriggerListener = new TriggerWithRescheduleListener();
        SchedulerServiceHelper.addListener(fabricSchedulerService, (TriggerListener)cronTriggerListener);
        trigger.addTriggerListener(cronTriggerListener.getName());
    }

    private static ReschedulingPolicy outOfCalendarToReschedulingPolicy(OutOfCalendarPolicy outOfCalendarPolicy) {
        ReschedulingPolicy reschedulingPolicy = null;
        switch (outOfCalendarPolicy) {
            case NO_RESCHEDULE: {
                reschedulingPolicy = ReschedulingPolicy.NO_RESCHEDULE;
                break;
            }
            case RESCHEDULE_AS_SOON_AS_POSSIBLE: {
                reschedulingPolicy = ReschedulingPolicy.RESCHEDULE_AS_SOON_AS_POSSIBLE;
                break;
            }
            case RESCHEDULE_AT_THE_SAME_HOUR: {
                reschedulingPolicy = ReschedulingPolicy.RESCHEDULE_AT_THE_SAME_HOUR;
            }
        }
        return reschedulingPolicy;
    }

    private static void setUpStartEndTime(Trigger trigger, Date startTime, Date endTime) {
        if (startTime != null) {
            trigger.setStartTime(startTime);
        }
        if (endTime != null) {
            trigger.setEndTime(endTime);
        }
    }

    private static JobDetail createJobDetail(String jobName, String jobGroup, Class scheduleJobClass, StringProperties opaqueProperties) {
        JobDetail jobDetail = new JobDetail(jobName, jobGroup, ScheduledJob.class);
        jobDetail.getJobDataMap().put("Fabric_classToSchedule", scheduleJobClass.getName());
        jobDetail.setRequestsRecovery(true);
        if (opaqueProperties != null) {
            String propName = null;
            Enumeration e = opaqueProperties.propertyNames();
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                jobDetail.getJobDataMap().put(propName, opaqueProperties.get(propName));
            }
        }
        return jobDetail;
    }

    private static String listProperties(StringProperties prop) {
        if (prop == null) {
            return " ";
        }
        String propName = null;
        StringBuffer buf = new StringBuffer();
        Enumeration e = prop.propertyNames();
        while (e.hasMoreElements()) {
            propName = (String)e.nextElement();
            buf.append("Key[" + propName + "]\tValue=" + prop.get(propName) + "\n");
        }
        return buf.toString();
    }

    private static void Log(String str) {
        FabricSchedulerFactory.getLogger().log(Level.FINE, "Soa-Scheduler:" + str);
    }

    private static Scheduler getScheduler(FabricSchedulerService fabricSchedulerService) {
        return SchedulerServiceHelper.getFieldValue(fabricSchedulerService, "mScheduler", Scheduler.class);
    }

    private static <T> T getFieldValue(FabricSchedulerService service, String fieldName, Class<T> clazz) {
        try {
            Field field = service.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return clazz.cast(field.get(service));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static class UnknownTriggerTypeException
    extends RuntimeException {
        public UnknownTriggerTypeException() {
            super("Error: Only CronTrigger and SimpleTrigger are supported.");
        }
    }
}

