/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import oracle.bpm.bpmn.engine.model.CronExpressionSchedule;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Week;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.WeeklySchedule;

public class ScheduleEntryToCronExpression {
    public static String toCronExpression(ScheduleEntry scheduleEntry) {
        int seconds = scheduleEntry.getWhen().getSecondsOnly();
        int minutes = scheduleEntry.getWhen().getMinutesOnly();
        int hours = scheduleEntry.getWhen().getHoursOnly();
        String cronExpression = seconds + " " + minutes + " " + hours;
        if (scheduleEntry instanceof MonthlySchedule) {
            MonthlySchedule monthlySchedule = (MonthlySchedule)scheduleEntry;
            Week week = monthlySchedule.getWeek();
            Day dayOfWeek = monthlySchedule.getDayOfWeek();
            Month month = monthlySchedule.getMonth();
            int dayOfMonth = monthlySchedule.getDayOfMonth();
            if (week == null) {
                cronExpression = cronExpression + " " + dayOfMonth + " " + (month == null ? "*" : Integer.valueOf(month.ordinal() + 1)) + " ?";
            } else {
                String suffixDayOfWeek = week != Week.LAST ? "#" + (week.ordinal() + 1) : "L";
                cronExpression = cronExpression + " ? " + (month == null ? "*" : Integer.valueOf(month.ordinal() + 1)) + " " + (dayOfWeek.ordinal() + 1) + suffixDayOfWeek;
            }
        } else if (scheduleEntry instanceof WeeklySchedule) {
            WeeklySchedule weeklySchedule = (WeeklySchedule)scheduleEntry;
            Day dayOfWeek = weeklySchedule.getDayOfWeek();
            cronExpression = cronExpression + " ? * " + (dayOfWeek.ordinal() + 1);
        } else {
            cronExpression = scheduleEntry instanceof CronExpressionSchedule ? ((CronExpressionSchedule)scheduleEntry).getCronExpression() : cronExpression + " ? * *";
        }
        return cronExpression;
    }
}

