/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import java.util.Date;
import java.util.List;
import oracle.bpm.services.organization.model.CalendarRule;
import oracle.bpm.services.organization.model.HolidayRule;
import oracle.bpm.services.organization.model.HolidayType;
import oracle.bpm.services.organization.model.WorkPeriodType;
import oracle.bpm.services.organization.model.WorkdayType;
import oracle.fabric.composite.CompositeDN;
import org.quartz.Calendar;
import org.quartz.impl.calendar.BaseCalendar;

public class RulesCalendar
extends BaseCalendar
implements Calendar {
    CalendarRule calendarRule;
    HolidayRule holidayRule;
    Boolean isNotIncludedInHolidays;
    private static final long serialVersionUID = 23456L;

    public RulesCalendar(CalendarRule calendarRule, HolidayRule holidayRule) {
        this.calendarRule = calendarRule;
        this.holidayRule = holidayRule;
    }

    public static String buildName(String compositeDN, String calendarName) {
        return compositeDN.replaceAll(new CompositeDN(compositeDN).getLabel(), "") + calendarName;
    }

    public boolean isTimeIncluded(long timeStamp) {
        return this.isNotIncludedInHolidays(timeStamp) && this.isIncludedInWorkdays(timeStamp);
    }

    public long getNextIncludedTime(long timeStamp) {
        do {
            if (this.wasNotIncludedInHolidays().booleanValue()) {
                timeStamp += 60000L;
                continue;
            }
            java.util.Calendar currentTime = this.getCalendarInMyTimeZone(timeStamp);
            this.setToMidnight(currentTime);
            timeStamp = currentTime.getTimeInMillis() + 86400000L + 1L;
        } while (!this.isTimeIncluded(timeStamp));
        return timeStamp;
    }

    public boolean isIncludedInWorkdays(long timeStamp) {
        boolean isIncludedInWorkdays = false;
        java.util.Calendar currentTime = this.getCalendarInMyTimeZone(timeStamp);
        int dayOfWeek = currentTime.get(7);
        List workdayTypeList = this.calendarRule.getWorkdayList().getWorkday();
        block0: for (WorkdayType workdayType : workdayTypeList) {
            if (this.toDayOfWeek(workdayType.getWeekDay().value()) != dayOfWeek) continue;
            List workPeriodTypeList = workdayType.getWorkPeriod();
            for (WorkPeriodType workPeriodType : workPeriodTypeList) {
                java.util.Calendar startTime = this.getCalendarInMyTimeZone(workPeriodType.getStartTime().toGregorianCalendar().getTimeInMillis());
                this.setDayMonthAndYearFromTo(currentTime, startTime);
                java.util.Calendar endTime = this.getCalendarInMyTimeZone(workPeriodType.getEndTime().toGregorianCalendar().getTimeInMillis());
                this.setDayMonthAndYearFromTo(currentTime, endTime);
                if (!this.isBetween(startTime, currentTime, endTime)) continue;
                isIncludedInWorkdays = true;
                continue block0;
            }
        }
        return isIncludedInWorkdays;
    }

    public int toDayOfWeek(String dayOfWeekStr) {
        int dayOfWeek = dayOfWeekStr.equals("Sunday") ? 1 : (dayOfWeekStr.equals("Monday") ? 2 : (dayOfWeekStr.equals("Tuesday") ? 3 : (dayOfWeekStr.equals("Wednesday") ? 4 : (dayOfWeekStr.equals("Thursday") ? 5 : (dayOfWeekStr.equals("Friday") ? 6 : 7)))));
        return dayOfWeek;
    }

    public boolean isNotIncludedInHolidays(long timeStamp) {
        this.isNotIncludedInHolidays = true;
        if (this.holidayRule != null) {
            java.util.Calendar currentTime = this.getCalendarInMyTimeZone(timeStamp);
            List holidayTypeList = this.holidayRule.getHolidays();
            for (HolidayType holidayType : holidayTypeList) {
                java.util.Calendar endTime;
                java.util.Calendar startTime;
                java.util.Calendar holidayTime = this.getCalendarInMyTimeZone(holidayType.getHolidayDate().toGregorianCalendar().getTimeInMillis());
                if (holidayType.getHolidayPattern().value().equals("OnlyForCurrentYear")) {
                    startTime = holidayTime;
                } else {
                    java.util.Calendar sameDayThisYear = this.getCalendarInMyTimeZone(timeStamp);
                    this.setDayAndMonthFromTo(holidayTime, sameDayThisYear);
                    this.setToMidnight(sameDayThisYear);
                    startTime = sameDayThisYear;
                }
                if (!this.isBetween(startTime, currentTime, endTime = this.getCalendarInMyTimeZone(startTime.getTimeInMillis() + 86400000L))) continue;
                this.isNotIncludedInHolidays = false;
                break;
            }
        }
        return this.isNotIncludedInHolidays;
    }

    public Boolean wasNotIncludedInHolidays() {
        return this.isNotIncludedInHolidays;
    }

    private boolean isBetween(java.util.Calendar startTime, java.util.Calendar currentTime, java.util.Calendar endTime) {
        return startTime.getTime().getTime() <= currentTime.getTime().getTime() && currentTime.getTime().getTime() <= endTime.getTime().getTime();
    }

    private java.util.Calendar getCalendarInMyTimeZone(long timeStamp) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeZone(this.getTimeZone());
        calendar.setTime(new Date(timeStamp));
        return calendar;
    }

    private void setDayAndMonthFromTo(java.util.Calendar from, java.util.Calendar to) {
        to.set(5, from.get(5));
        to.set(2, from.get(2));
    }

    private void setDayMonthAndYearFromTo(java.util.Calendar from, java.util.Calendar to) {
        this.setDayAndMonthFromTo(from, to);
        to.set(1, from.get(1));
    }

    private void setToMidnight(java.util.Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }
}

