/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.BaseCubeProcess;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.InitiationInfo;
import com.collaxa.cube.engine.core.map.ICubeMap;
import com.collaxa.cube.engine.types.bpel.CXPartnerLink;
import java.util.Collection;
import java.util.HashSet;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMap;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapFactory;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.model.ComponentModel;

public class BPMNProcess
extends BaseCubeProcess {
    private String[] correlationSetReceives;
    private BPMNCubeMapBuilderContext cubeMapBuilderContext;
    private InitiationInfo[] initiationInfos;
    private Process mProcessModel;
    private Collection<CatchEvent> timerEvents;
    public static final String CUBE_MAP_PROCESS_KEY = "process";

    public void initRootScope(IScope sc, ICubeContext ctx) throws CubeException {
        CXPartnerLink cxpl1 = new CXPartnerLink();
        cxpl1.setName("OracleRules1.OracleRules1_DecisionService_1");
        sc.declareAndSet(cxpl1.getName(), (Object)cxpl1);
        HashSet pas = new HashSet();
        sc.declareAndSet("__correlationAliases", pas);
    }

    public final void validateCompatibility(ICubeContext ctx) throws CubeException {
    }

    public void setProcessModel(Process processModel) {
        this.mProcessModel = processModel;
    }

    public Process getProcessModel() {
        return this.mProcessModel;
    }

    public InitiationInfo[] getInitiationInfos() {
        return this.initiationInfos;
    }

    public Collection<CatchEvent> getTimerEvents() {
        return this.timerEvents;
    }

    public BPMNCubeMap getBPMNCubeMap() {
        return (BPMNCubeMap)this.mMethods.get(CUBE_MAP_PROCESS_KEY);
    }

    public void setScaComponent(ComponentModel component) {
        super.setScaComponent(component);
        if (this.getBPMNCubeMap() != null) {
            try {
                DataHandlingUtils.restoreSchemaImportLocations(this.getBPMNCubeMap(), component);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public BPMNCubeMapBuilderContext getCubeMapBuilderContext() {
        return this.cubeMapBuilderContext;
    }

    public String[] getCorrelationSetReceives() {
        if (this.correlationSetReceives == null) {
            this.correlationSetReceives = this.mCorrelationSubscriptions.keySet().toArray(new String[this.mCorrelationSubscriptions.size()]);
        }
        return this.correlationSetReceives;
    }

    protected void buildMaps(ICubeContext ctx) throws CubeException {
        System.out.println("Building cube maps ...");
        BPMNCubeMap cubeMap = BPMNCubeMapFactory.create(this.mProcessModel, ctx, this.mComponent);
        this.cubeMapBuilderContext = cubeMap.getCubeMapBuilderContext();
        Collection<InitiationInfo> initiationInfos1 = cubeMap.getInitiationsInfo();
        this.initiationInfos = new InitiationInfo[initiationInfos1.size()];
        initiationInfos1.toArray(this.initiationInfos);
        this.timerEvents = cubeMap.getTimerEvents();
        this.mMethods.put(CUBE_MAP_PROCESS_KEY, cubeMap);
        this.setCorrelationSubscriptions(cubeMap.getCorrelationSubscriptions());
    }

    protected String getRootBlockId() {
        return ((ICubeMap)this.mMethods.get(CUBE_MAP_PROCESS_KEY)).getMethodBlock().getId();
    }
}

