/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.model;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeProcess;
import com.collaxa.cube.engine.deployment.DeploymentHelper;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import com.collaxa.cube.engine.deployment.ProcessInstantiationException;
import com.collaxa.cube.lang.compiler.BPELCompilerLogger;
import com.collaxa.cube.lang.compiler.ICubeProcessor;
import com.oracle.bpel.client.util.ExceptionUtils;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.ModelCreator;
import oracle.bpm.bpmn.engine.map.builder.ModelCreatorFactoryHelper;
import oracle.bpm.bpmn.engine.model.BPMNProcess;
import oracle.bpm.bpmn.engine.model.deploy.validation.StrictGatewayValidation;
import oracle.bpm.fusion.sca.validator.BPMNComponentValidator;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.fabric.composite.component.implementation.BaseProcessImplementation;
import oracle.fabric.composite.model.ComponentModel;
import oracle.soa.scac.FaultListener;
import oracle.soa.scac.FaultObject;
import oracle.soa.scac.ValidationFault;
import org.jetbrains.annotations.NotNull;

public class BPMNCubeProcessor
implements ICubeProcessor {
    private ComponentModel component;
    private Process processModel;
    private static final String ORACLE_BPM_RUNTIME_VALIDATION_SKIP = "oracle.bpm.runtime.validation.skip";
    private static final String OLD_VERSION = "11.1.1";

    public BPMNCubeProcessor(ComponentModel component) throws CubeException {
        this.component = component;
    }

    public static void checkComponent(@NotNull ValidationFault vf, @NotNull Process processModel) throws CubeException {
        ProcessContent processContent = (ProcessContent)processModel;
        String fileVersion = processContent.getFileVersion();
        if (!Boolean.getBoolean(ORACLE_BPM_RUNTIME_VALIDATION_SKIP) && fileVersion != null && !fileVersion.equals(OLD_VERSION)) {
            BPMNComponentValidator.isValidBpmProject((ValidationFault)vf, (Project)processModel.getProject());
            if (vf.hasErrors()) {
                throw new CubeException((Throwable)new Exception("BPMN compilation failed"));
            }
        }
    }

    public void setOptions(Map<String, String> options) {
    }

    public boolean process(ValidationFault vf) throws CubeException {
        ModelCreator modelCreator = ModelCreatorFactoryHelper.getFactory().getModelCreator(this.component);
        this.processModel = modelCreator.createModel();
        return true;
    }

    public ICubeProcess createCubeProcess(ICubeContext ctx) throws CubeException {
        String base = this.component.getComposite().getHome();
        try {
            if (this.processModel == null) {
                ValidationFault vf = new ValidationFault();
                vf.addListener((FaultListener)new L(base));
                this.process(vf);
                BPMNCubeProcessor.checkComponent(vf, this.processModel);
                StrictGatewayValidation validation = new StrictGatewayValidation();
                validation.validate(this.processModel, vf);
                if (vf.hasErrors()) {
                    throw new CubeException((Throwable)new Exception("BPEL compilation failed"));
                }
            }
            BPMNProcess cs = new BPMNProcess();
            cs.setScaComponent(this.component);
            cs.setProcessModel(this.processModel);
            cs.setExtractContentRoot(DeploymentHelper.getScratchDirectory((ComponentModel)this.component));
            cs.load(ctx);
            DeploymentLogger.LOG.debug(this.getClass(), "getCubeProcess", new Object[]{"Done loading process ", this.component.getComposite().getDN(), "/", this.component.getName()});
            return cs;
        }
        catch (CubeException ce) {
            DeploymentLogger.LOG.debug(this.getClass(), "create", new Object[]{"Error creating process", ce});
            throw ce;
        }
        catch (Throwable t) {
            DeploymentLogger.LOG.debug(this.getClass(), "create", new Object[]{"Error creating process", t});
            String msg = ExceptionUtils.getMessage((Throwable)t);
            throw new ProcessInstantiationException(5217, new Object[]{((BaseProcessImplementation)this.component.getImplementation()).getProcess(), this.component.getComposite().getDN(), this.component.getName(), msg}, t);
        }
    }

    public Object getProcessModel() {
        return this.processModel;
    }

    class L
    implements FaultListener {
        final String prefix;

        L(String base) {
            this.prefix = base;
        }

        public void faultAdded(FaultObject obj) {
            obj.fixDisplayName(this.prefix);
            obj.print1(BPELCompilerLogger.LOG.getLogger());
        }
    }
}

