/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.microkernel;

import com.collaxa.cube.CubeException;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;

public class MIIfBlock
extends MIBase {
    private IMicroInstruction<Boolean> expression;
    private IMicroInstruction ifBlock;
    private IMicroInstruction elseBlock;

    public MIIfBlock() {
    }

    public MIIfBlock(IMicroInstruction condition, IMicroInstruction ifBlock) {
        this.expression = condition;
        this.ifBlock = ifBlock;
    }

    public void setExpression(IMicroInstruction<Boolean> expression) {
        this.expression = expression;
    }

    public void setIfBlock(IMicroInstruction ifBlock) {
        this.ifBlock = ifBlock;
    }

    public void setElseBlock(IMicroInstruction elseBlock) {
        this.elseBlock = elseBlock;
    }

    @Override
    public String getMicroInstructionDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.expression.getMicroInstructionDescription());
        builder.append(" ? ");
        if (this.ifBlock != null) {
            builder.append(this.ifBlock.getMicroInstructionDescription());
        } else {
            builder.append("-");
        }
        if (this.elseBlock != null) {
            builder.append(" : ");
            builder.append(this.elseBlock.getMicroInstructionDescription());
        }
        builder.append("]");
        return builder.toString();
    }

    protected Object doExecute(MicroInstructionContext context) throws Throwable {
        Object value = null;
        if (this.expression.execute(context).booleanValue()) {
            if (this.ifBlock != null) {
                value = this.ifBlock.execute(context);
            }
        } else if (this.elseBlock != null) {
            value = this.elseBlock.execute(context);
        }
        return value;
    }

    @Override
    protected void logExecution(MicroInstructionContext context, String label) throws CubeException {
    }
}

