/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.microkernel;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.types.bpel.CXElementVariable;
import com.collaxa.cube.engine.types.bpel.CXMessageVariable;
import com.collaxa.cube.engine.types.bpel.CXTypeVariable;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;

public abstract class MIBase<T>
implements IMicroInstruction<T> {
    @Override
    public final T execute(MicroInstructionContext context) throws Throwable {
        context.incrementMicroInstructionStep();
        this.logExecution(context);
        return this.doExecute(context);
    }

    @Override
    public String getMicroInstructionDescription() {
        return this.getClass().getSimpleName();
    }

    protected abstract T doExecute(MicroInstructionContext var1) throws Throwable;

    protected void logExecution(MicroInstructionContext context) throws CubeException {
        this.logExecution(context, "executed");
    }

    protected void logExecution(MicroInstructionContext context, String label) throws CubeException {
        context.logExecution(label, this.getMicroInstructionDescription(context));
    }

    protected String getMicroInstructionDescription(MicroInstructionContext context) {
        return this.getMicroInstructionDescription();
    }

    protected final void setVariableValue(IScope scope, Object variable) throws CubeException {
        String name;
        if (variable instanceof CXMessageVariable) {
            name = ((CXMessageVariable)variable).getName();
        } else if (variable instanceof CXElementVariable) {
            name = ((CXElementVariable)variable).getName();
        } else if (variable instanceof CXTypeVariable) {
            name = ((CXTypeVariable)variable).getName();
        } else {
            throw new IllegalArgumentException("variable is of unknown type:" + variable.getClass().getName());
        }
        if (!scope.contains(name)) {
            scope.declareAndSet(name, variable);
        } else {
            scope.set(name, variable);
        }
    }
}

