/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import oracle.bpel.services.notification.payload.CommonPayloadType;
import oracle.bpel.services.notification.payload.CommonPayloadTypeFactory;
import oracle.bpel.services.notification.payload.ContentType;
import oracle.bpel.services.notification.payload.ContentTypeFactory;
import oracle.bpel.services.notification.payload.GenericPayloadType;
import oracle.bpel.services.notification.payload.GenericPayloadTypeFactory;
import oracle.bpel.services.notification.payload.ICommonPayloadType;
import oracle.bpel.services.notification.payload.IContentType;
import oracle.bpel.services.notification.payload.IGenericPayloadType;
import oracle.bpel.services.notification.payload.IUserNotificationPayloadType;
import oracle.bpel.services.notification.payload.IUserPropertiesParameterType;
import oracle.bpel.services.notification.payload.IUserPropertiesType;
import oracle.bpel.services.notification.payload.UserNotificationPayloadType;
import oracle.bpel.services.notification.payload.UserNotificationPayloadTypeFactory;
import oracle.bpel.services.notification.payload.UserPropertiesParameterType;
import oracle.bpel.services.notification.payload.UserPropertiesParameterTypeFactory;
import oracle.bpel.services.notification.payload.UserPropertiesType;
import oracle.bpel.services.notification.payload.UserPropertiesTypeFactory;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractNotificationTypeProcessInputMI;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExpressionEvaluator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.NotificationPayloadTypeProxy;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDNotificationTask;
import oracle.bpm.project.model.processes.notification.UserNotificationDefinition;
import oracle.bpm.project.model.processes.notification.UserNotificationProperty;
import org.collaxa.xml.IBaseFacade;

public class UserNotificationTypeProcessInputMI
extends AbstractNotificationTypeProcessInputMI {
    UserNotificationTypeProcessInputMI(MDNotificationTask mdNotificationTask) {
        super(mdNotificationTask);
    }

    @Override
    protected IBaseFacade createNotificationPayload(ICubeContext ctx, IWorkItem wi, IScope scope) throws Exception {
        UserNotificationDefinition definition = (UserNotificationDefinition)this.getMdNotificationTask().getNotificationDefinition().as(UserNotificationDefinition.class);
        UserNotificationPayloadType delegate = UserNotificationPayloadTypeFactory.createFacade();
        IUserNotificationPayloadType payloadType = NotificationPayloadTypeProxy.create(this.getClass().getClassLoader(), IUserNotificationPayloadType.class, delegate);
        AbstractNotificationTypeProcessInputMI.ExpressionEvaluatorImpl expressionEvaluator = new AbstractNotificationTypeProcessInputMI.ExpressionEvaluatorImpl(this, ctx, scope);
        for (UserNotificationField userNotificationField : UserNotificationField.values()) {
            userNotificationField.putValue(expressionEvaluator, definition, payloadType);
        }
        return delegate;
    }

    private static enum UserNotificationField {
        TO{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, UserNotificationDefinition definition, IUserNotificationPayloadType payload) throws Exception {
                GenericPayloadType genericPayload = GenericPayloadTypeFactory.createFacade();
                CommonPayloadType commonPayload = CommonPayloadTypeFactory.createFacade();
                commonPayload.setTo("");
                genericPayload.setCommonPayload((ICommonPayloadType)commonPayload);
                payload.setGenericPayload((IGenericPayloadType)genericPayload);
                String to = expressionEvaluator.evaluateStringExpression(definition.getTo());
                payload.setUserId(to);
            }
        }
        ,
        SUBJECT{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, UserNotificationDefinition definition, IUserNotificationPayloadType payload) throws Exception {
                ICommonPayloadType commonPayload = this.getCommonPayloadType(payload);
                String subject = expressionEvaluator.evaluateStringExpression(definition.getSubject());
                commonPayload.setSubject(subject);
            }
        }
        ,
        MESSAGE{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, UserNotificationDefinition definition, IUserNotificationPayloadType payload) throws Exception {
                String message = expressionEvaluator.evaluateStringExpression(definition.getMessage());
                ICommonPayloadType commonPayload = this.getCommonPayloadType(payload);
                ContentType contentType = ContentTypeFactory.createFacade();
                contentType.setContentBody((Object)message);
                commonPayload.setContent((IContentType)contentType);
            }
        }
        ,
        PROPERTIES{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, UserNotificationDefinition definition, IUserNotificationPayloadType payload) throws Exception {
                if (!definition.getProperties().isEmpty()) {
                    UserPropertiesType preferencesProperties = UserPropertiesTypeFactory.createFacade();
                    for (UserNotificationProperty userNotificationProperty : definition.getProperties()) {
                        UserPropertiesParameterType parameter = UserPropertiesParameterTypeFactory.createFacade();
                        String name = expressionEvaluator.evaluateStringExpression(userNotificationProperty.getHeader());
                        Object value = expressionEvaluator.evaluateObjectExpression(userNotificationProperty.getValue());
                        parameter.setName(name);
                        parameter.setValue(value);
                        preferencesProperties.addParameter((IUserPropertiesParameterType)parameter);
                    }
                    payload.setPreferenceProperties((IUserPropertiesType)preferencesProperties);
                }
            }
        };


        protected ICommonPayloadType getCommonPayloadType(IUserNotificationPayloadType payload) {
            return payload.getGenericPayload().getCommonPayload();
        }

        public abstract void putValue(ExpressionEvaluator var1, UserNotificationDefinition var2, IUserNotificationPayloadType var3) throws Exception;
    }
}

