/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.ThreadCountManager;
import java.util.Date;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIBooleanBase;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MIUpdateProcInstanceAttr;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.SchedulingLogger;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MITimerEventDefineExpirationDate;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDTimerEvent;
import oracle.bpm.bpmn.engine.model.runtime.util.ScopeUtils;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.soa.management.ComponentDN;

public class TimerEventExpireGenerator {
    public static IMicroInstruction compile(BPMNCubeMapBuilderContext context, CatchEvent element, MDTimerEvent mdTimerEvent) {
        MISequenceBlock block = new MISequenceBlock();
        if (ModelVisitorUtil.isEventHandler(element)) {
            MIIfBlock ifBlock = new MIIfBlock();
            block.addMicroInstruction(ifBlock);
            if (ModelVisitorUtil.isInlineEventHandler((FlowNode)element)) {
                ifBlock.setExpression(new ConditionInParentScope());
            } else {
                ifBlock.setExpression(new Condition());
            }
            MISequenceBlock ifBlockPart = new MISequenceBlock();
            ifBlock.setIfBlock(ifBlockPart);
            TimerEventExpireGenerator.completeScheduleMicroInstructions(ifBlockPart, mdTimerEvent);
        } else {
            TimerEventExpireGenerator.completeExpireMicroInstructions(block, mdTimerEvent);
        }
        return block;
    }

    private static void completeScheduleMicroInstructions(MISequenceBlock block, MDTimerEvent mdTimerEvent) {
        if (mdTimerEvent.getSchedule() != null) {
            MIIfBlock ifBlock = new MIIfBlock();
            ifBlock.setExpression(new ScheduleConditions(mdTimerEvent));
            MISequenceBlock ifBlockPart = new MISequenceBlock();
            ifBlockPart.addMicroInstruction(new DoUpdateScheduleConditions());
            ifBlockPart.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
            ifBlock.setIfBlock(ifBlockPart);
            MISequenceBlock elseBlockPart = new MISequenceBlock();
            elseBlockPart.addMicroInstruction(new DoUnschedule());
            elseBlockPart.addMicroInstruction(new DoExpire());
            elseBlockPart.addMicroInstruction(new MICall("POST_EXECUTION"));
            elseBlockPart.addMicroInstruction(new MIUpdateProcInstanceAttr(false));
            ifBlock.setElseBlock(elseBlockPart);
            block.addMicroInstruction(ifBlock);
        } else {
            TimerEventExpireGenerator.completeExpireMicroInstructions(block, mdTimerEvent);
        }
    }

    private static void completeExpireMicroInstructions(MISequenceBlock block, MDTimerEvent mdTimerEvent) {
        if (mdTimerEvent.getStartDate() != null || mdTimerEvent.getEndDate() != null || mdTimerEvent.isUsingCalendar()) {
            block.addMicroInstruction(new DoUnschedule());
        }
        block.addMicroInstruction(new DoExpire());
        block.addMicroInstruction(new MICall("POST_EXECUTION"));
        block.addMicroInstruction(new MIUpdateProcInstanceAttr(false));
        block.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
    }

    private static class ScheduleConditions
    extends MIBooleanBase {
        MDTimerEvent mdTimerEvent;

        ScheduleConditions(MDTimerEvent mdTimerEvent) {
            this.mdTimerEvent = mdTimerEvent;
        }

        @Override
        protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
            SchedulingLogger.log(new Date() + " " + "Executing check conditions MI...");
            IWorkItem wi = context.getWorkItem();
            int repetitions = (Integer)ScopeUtils.getWorkItemValue(wi, "TIMER_REPETITIONS");
            return repetitions == -1 || repetitions > 0;
        }
    }

    private static class DoUpdateScheduleConditions
    extends MIBase<Object> {
        private DoUpdateScheduleConditions() {
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            SchedulingLogger.log(new Date() + " " + "Executing update conditions MI...");
            IWorkItem wi = context.getWorkItem();
            int repetitions = (Integer)ScopeUtils.getWorkItemValue(wi, "TIMER_REPETITIONS");
            if (repetitions != -1) {
                wi.getNodeActivationContext().put("TIMER_REPETITIONS", repetitions - 1);
            }
            return null;
        }
    }

    private static class DoExpire
    extends MIBase<Object> {
        private DoExpire() {
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            context.getWorkItem().markAsComplete();
            return null;
        }
    }

    private static class ConditionInParentScope
    extends MIBooleanBase {
        private ConditionInParentScope() {
        }

        @Override
        protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
            return ThreadCountManager.getThreadCount((IScope)context.getWorkItem().getScope().getParentScope()) > 0;
        }
    }

    private static class Condition
    extends MIBooleanBase {
        private Condition() {
        }

        @Override
        protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
            return ThreadCountManager.getThreadCount((IScope)context.getWorkItem().getScope()) > 0;
        }
    }

    public static class DoUnschedule
    extends MIBase<Object> {
        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            SchedulingLogger.log(new Date() + " " + "Executing unschedule MI...(" + context.getWorkItem().getKey().toString() + ")");
            IWorkItem wi = context.getWorkItem();
            String jobName = (String)ScopeUtils.getWorkItemValue(wi, "JOB_NAME");
            ICubeContext ctx = context.getCubeContext();
            ComponentDN componentDN = CubeContextHelper.getProcessDN((ICubeContext)ctx);
            String compositeDN = componentDN.getCompositeDN();
            MITimerEventDefineExpirationDate.unschedule(compositeDN, jobName);
            return null;
        }
    }
}

