/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.InvokeMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.InvokeSignalActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.NotificationTaskActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ReceiveMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ReceiveSignalActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ReplyToMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorHelper;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDNotificationTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReply;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;

public abstract class ServiceActivitiesGeneratorFactory {
    public static InvokeMessageActivityGenerator createServiceTaskGenerator(MDServiceTask mdServiceTask) {
        return new InvokeMessageActivityGenerator(mdServiceTask, ServiceActivitiesGeneratorFactory.createMessageHelper(mdServiceTask));
    }

    public static InvokeMessageActivityGenerator createNotificationTaskGenerator(MDNotificationTask mdNotificationTask) {
        return new NotificationTaskActivityGenerator(mdNotificationTask, ServiceActivitiesGeneratorFactory.createMessageHelper(mdNotificationTask));
    }

    public static InvokeSignalActivityGenerator createSendSignalGenerator(MDServiceTask mdServiceTask) {
        return new InvokeSignalActivityGenerator(mdServiceTask, ServiceActivitiesGeneratorFactory.createSignalHelper(mdServiceTask));
    }

    public static ReceiveSignalActivityGenerator createReceiveSignalGenerator(MDReceive mdReceive) {
        return new ReceiveSignalActivityGenerator(mdReceive, ServiceActivitiesGeneratorFactory.createSignalHelper(mdReceive));
    }

    public static ReceiveMessageActivityGenerator createReceiveTaskGenerator(MDReceive mdReceive) {
        return new ReceiveMessageActivityGenerator(mdReceive, ServiceActivitiesGeneratorFactory.createMessageHelper(mdReceive));
    }

    public static ReplyToMessageActivityGenerator createReplyToGenerator(MDReply mdReply) {
        return new ReplyToMessageActivityGenerator(mdReply, ServiceActivitiesGeneratorFactory.createMessageHelper(mdReply));
    }

    private static ServiceActivitiesGeneratorHelper createMessageHelper(final MDServiceActivity serviceActivity) {
        return new ServiceActivitiesGeneratorHelper(){

            @Override
            public boolean hasToProcessOutput() {
                return serviceActivity.isTwoWay();
            }
        };
    }

    private static ServiceActivitiesGeneratorHelper createSignalHelper(MDServiceActivity serviceActivity) {
        return new ServiceActivitiesGeneratorHelper(){

            @Override
            public boolean hasToProcessOutput() {
                return false;
            }
        };
    }
}

