/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import oracle.bpel.services.notification.payload.ContentType;
import oracle.bpel.services.notification.payload.ContentTypeFactory;
import oracle.bpel.services.notification.payload.IContentType;
import oracle.bpel.services.notification.payload.ISMSPayloadType;
import oracle.bpel.services.notification.payload.SMSPayloadType;
import oracle.bpel.services.notification.payload.SMSPayloadTypeFactory;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractNotificationTypeProcessInputMI;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExpressionEvaluator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.NotificationPayloadTypeProxy;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDNotificationTask;
import oracle.bpm.project.model.processes.notification.SMSNotificationDefinition;
import org.collaxa.xml.IBaseFacade;

public class SMSNotificationTypeProcessInputMI
extends AbstractNotificationTypeProcessInputMI {
    SMSNotificationTypeProcessInputMI(MDNotificationTask mdNotificationTask) {
        super(mdNotificationTask);
    }

    @Override
    protected IBaseFacade createNotificationPayload(ICubeContext ctx, IWorkItem wi, IScope scope) throws Exception {
        SMSNotificationDefinition definition = (SMSNotificationDefinition)this.getMdNotificationTask().getNotificationDefinition().as(SMSNotificationDefinition.class);
        SMSPayloadType delegate = SMSPayloadTypeFactory.createFacade();
        ISMSPayloadType payloadType = NotificationPayloadTypeProxy.create(this.getClass().getClassLoader(), ISMSPayloadType.class, delegate);
        AbstractNotificationTypeProcessInputMI.ExpressionEvaluatorImpl expressionEvaluator = new AbstractNotificationTypeProcessInputMI.ExpressionEvaluatorImpl(this, ctx, scope);
        for (SMSField smsField : SMSField.values()) {
            smsField.putValue(expressionEvaluator, definition, payloadType);
        }
        return delegate;
    }

    private static enum SMSField {
        FROM{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, SMSNotificationDefinition definition, ISMSPayloadType payload) throws CubeException {
                String from = expressionEvaluator.evaluateStringExpression(definition.getFrom());
                payload.setFrom(from);
            }
        }
        ,
        TO{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, SMSNotificationDefinition definition, ISMSPayloadType payload) throws CubeException {
                String to = expressionEvaluator.evaluateStringExpression(definition.getTo());
                payload.setTo(to);
            }
        }
        ,
        SUBJECT{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, SMSNotificationDefinition definition, ISMSPayloadType payload) throws CubeException {
                String subject = expressionEvaluator.evaluateStringExpression(definition.getSubject());
                payload.setSubject(subject);
            }
        }
        ,
        BODY{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, SMSNotificationDefinition definition, ISMSPayloadType payload) throws Exception {
                String body = expressionEvaluator.evaluateStringExpression(definition.getBody());
                ContentType contentType = ContentTypeFactory.createFacade();
                contentType.setContentBody((Object)body);
                payload.setContent((IContentType)contentType);
            }
        };


        public abstract void putValue(ExpressionEvaluator var1, SMSNotificationDefinition var2, ISMSPayloadType var3) throws Exception;
    }
}

