/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.CubeContextHelper;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.xml.XMLHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.BaseActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorHelper;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageInputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReply;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReply;
import oracle.fabric.CubeFabricUtil;
import oracle.fabric.composite.model.ComponentModel;

public class ReplyToMessageActivityGenerator
extends BaseActivityGenerator {
    private ServiceActivitiesGeneratorHelper helper;
    private MDReply mdReply;

    public ReplyToMessageActivityGenerator(MDReply mdReply, ServiceActivitiesGeneratorHelper helper) {
        this.mdReply = mdReply;
        this.helper = helper;
    }

    public IMicroInstruction<Object> createReplyMI() {
        MDVariableDeclaration mdVariableDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(this.mdReply, this.mdReply);
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(this.getInitializeVariableMI(mdVariableDeclaration));
        result.addMicroInstruction(this.createSetDataAssociationInputVariable(mdVariableDeclaration));
        result.addMicroInstruction(this.getInputDataAssociationMI(this.mdReply));
        result.addMicroInstruction(new MIReply(this.mdReply));
        result.addMicroInstruction(new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                ICubeContext ctx = context.getCubeContext();
                IWorkItem workItem = context.getWorkItem();
                workItem.markAsComplete();
                boolean bIdempotent = true;
                ComponentModel component = CubeContextHelper.getScaComponent((ICubeContext)ctx);
                if (XMLHelper.isFalse((String)CubeFabricUtil.getConfigurationPropertyValue((ComponentModel)component, (String)"idempotentReply"))) {
                    bIdempotent = false;
                }
                workItem.markAsPerformerIdempotent(bIdempotent);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return "MarkAsPerformerIdempotentAndComplete";
            }
        });
        return result;
    }

    protected IMicroInstruction getInputDataAssociationMI(MDReply mdReply) {
        return new MIProcessMessageInputDataAssociationsForService(mdReply, mdReply);
    }

    @Override
    protected IMicroInstruction getInitializeVariableMI(MDVariableDeclaration declaration) {
        return new MIInitializeMessageVariable(declaration);
    }

    @Override
    protected IMicroInstruction getProcessOutputPart1MI(MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        return new MINop();
    }

    @Override
    protected IMicroInstruction getProcessOutputPart2MI(MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        return new MINop();
    }
}

