/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.util.EngineDBUtils;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.BaseActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorHelper;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MICaseManagementCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MICleanVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MICopyMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIEntryReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsActivityCompleted;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageOutputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceive;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceiveCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;

public class ReceiveMessageActivityGenerator
extends BaseActivityGenerator {
    private MDReceive mdReceive;

    public ReceiveMessageActivityGenerator(MDReceive mdReceive, ServiceActivitiesGeneratorHelper helper) {
        this.mdReceive = mdReceive;
    }

    public IMicroInstruction<Object> createReceiveMI() {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(this.mdReceive, this.mdReceive);
        MIIfBlock ifBlockWorkItemComplete = new MIIfBlock();
        ifBlockWorkItemComplete.setExpression(new MIIsActivityCompleted());
        MISequenceBlock sequenceBlock = new MISequenceBlock();
        this.addProcessOutputMI(sequenceBlock, this.mdReceive, this.mdReceive, mdInputVarDeclaration);
        ifBlockWorkItemComplete.setIfBlock(sequenceBlock);
        ifBlockWorkItemComplete.setElseBlock(new MIBase(){

            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.getWorkItem().markAsOpenPendingComplete();
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return "MarkWorkItemAsOpenPendingComplete";
            }
        });
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(new MIBase(){

            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.getWorkItem().markAsPerformerIdempotent(true);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return "MarkWorkItemAsPerformerIdempotent";
            }
        });
        result.addMicroInstruction(this.getInitializeVariableMI(mdInputVarDeclaration));
        result.addMicroInstruction(ifBlockWorkItemComplete);
        result.addMicroInstruction(new MIReceive(this.mdReceive));
        return result;
    }

    public IMicroInstruction<Object> createReceiveTaskCallbackMI() {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(this.mdReceive, this.mdReceive);
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(new MIReceiveCallback(this.mdReceive));
        result.addMicroInstruction(this.createOnVariableChange(this.mdReceive));
        this.addProcessOutputMI(result, this.mdReceive, this.mdReceive, mdInputVarDeclaration);
        if (this.mdReceive.isInEventHandler() && !this.mdReceive.isEventInterrupting()) {
            result.addMicroInstruction(new MIBase<Object>(){

                @Override
                protected Object doExecute(MicroInstructionContext context) throws Throwable {
                    context.getWmp().getCubeNode().finalize(context.getWorkItem().getScope(), context.getCubeContext());
                    return null;
                }

                @Override
                public String getMicroInstructionDescription() {
                    return "FinalizeNode";
                }
            });
        }
        result.addMicroInstruction(this.createOnActivityComplete());
        result.addMicroInstruction(new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.forceActivityCompleted();
                return null;
            }
        });
        return result;
    }

    public IMicroInstruction<Object> createEntryReceiveMI() {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(this.mdReceive, this.mdReceive);
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(this.getInitializeVariableMI(mdInputVarDeclaration));
        result.addMicroInstruction(new MIEntryReceive(this.mdReceive));
        result.addMicroInstruction(new MICaseManagementCallback());
        this.addProcessOutputMI(result, this.mdReceive, this.mdReceive, mdInputVarDeclaration);
        result.addMicroInstruction(new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                IWorkItem workItem = context.getWorkItem();
                workItem.markAsPerformerIdempotent(!EngineDBUtils.isNextKeyLockingSupported());
                workItem.markAsComplete();
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return "MarkAsPerformerIdempotentAndComplete";
            }
        });
        result.addMicroInstruction(new MIInsertInstance2Track(false));
        return result;
    }

    @Override
    protected IMicroInstruction getProcessOutputPart1MI(MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        return new MIProcessMessageOutputDataAssociationsForService.SetContext(mdServiceActivity, mdIncomingMessage, saveAsProperty);
    }

    @Override
    protected IMicroInstruction getProcessOutputPart2MI(MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(new MIProcessMessageOutputDataAssociationsForService.ProcessOutput(mdServiceActivity, mdIncomingMessage, saveAsProperty));
        if (!saveAsProperty) {
            result.addMicroInstruction(new MICleanVariable());
        }
        return result;
    }

    @Override
    protected IMicroInstruction getInitializeVariableMI(MDVariableDeclaration declaration) {
        return new MIInitializeMessageVariable(declaration);
    }

    @Override
    protected IMicroInstruction createCloneVariableMI(MDVariableDeclaration sourceVariableDeclaration, MDVariableDeclaration targetVariableDeclaration) {
        return new MICopyMessageVariable(sourceVariableDeclaration, targetVariableDeclaration);
    }
}

