/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.Collections;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.BaseActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorHelper;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvoke;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsActivityCompleted;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageInputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageOutputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;

public class InvokeMessageActivityGenerator
extends BaseActivityGenerator {
    private ServiceActivitiesGeneratorHelper helper;
    private MDServiceTask mdServiceTask;

    public InvokeMessageActivityGenerator(MDServiceTask mdServiceTask, ServiceActivitiesGeneratorHelper helper) {
        this.mdServiceTask = mdServiceTask;
        this.helper = helper;
    }

    public IMicroInstruction<Object> createInvokeMI() {
        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(this.mdServiceTask, this.mdServiceTask);
        MDVariableDeclaration mdOutputVarDeclaration = null;
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(this.getInitializeVariableMI(mdInputVarDeclaration));
        if (this.hasToProcessOutput()) {
            mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(this.mdServiceTask, this.mdServiceTask);
            result.addMicroInstruction(this.getInitializeVariableMI(mdOutputVarDeclaration));
        }
        result.addMicroInstruction(this.createSetDataAssociationInputVariable(mdInputVarDeclaration));
        result.addMicroInstruction(this.getInputDataAssociationMI());
        result.addMicroInstruction(new MIInvoke(this.mdServiceTask));
        if (this.hasToProcessOutput()) {
            assert (mdOutputVarDeclaration != null) : "For output data associations, output variable declaration must not be null";
            MIIfBlock ifBlockWorkItemComplete = new MIIfBlock();
            ifBlockWorkItemComplete.setExpression(new MIIsActivityCompleted());
            MISequenceBlock sequenceBlock = new MISequenceBlock();
            this.addProcessOutputMI(sequenceBlock, this.mdServiceTask, this.mdServiceTask, mdOutputVarDeclaration);
            ifBlockWorkItemComplete.setIfBlock(sequenceBlock);
            result.addMicroInstruction(ifBlockWorkItemComplete);
        } else if (this.mdServiceTask.getOutputDataAssociationSet() != null && !this.mdServiceTask.getOutputDataAssociationSet().getDataAssignments().isEmpty()) {
            result.addMicroInstruction(new MIBase(){

                protected Object doExecute(MicroInstructionContext context) throws Throwable {
                    IWorkItem wi = context.getWorkItem();
                    ICubeContext ctx = context.getCubeContext();
                    IScope sc = wi.getScope();
                    DataHandlingUtils.processOutputData(context.getNode().getFlowElement(), InvokeMessageActivityGenerator.this.mdServiceTask.getOutputDataAssociationSet(), sc, ctx, Collections.<String, Object>emptyMap(), wi);
                    return null;
                }

                @Override
                public String getMicroInstructionDescription() {
                    return "MIExecuteCustomOutputs";
                }
            });
        }
        return result;
    }

    public IMicroInstruction<Object> createInvokeMI(IMicroInstruction invokeMI) {
        MDVariableDeclaration mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(this.mdServiceTask, this.mdServiceTask);
        MISequenceBlock result = new MISequenceBlock();
        result.addMicroInstruction(invokeMI);
        MIIfBlock ifCompleted = new MIIfBlock();
        result.addMicroInstruction(ifCompleted);
        ifCompleted.setExpression(new MIIsActivityCompleted());
        MISequenceBlock ifCompletedBlock = new MISequenceBlock();
        ifCompleted.setIfBlock(ifCompletedBlock);
        if (this.helper.hasToProcessOutput()) {
            ifCompletedBlock.addMicroInstruction(this.createSetDataAssociationOutputVariable(mdOutputVarDeclaration));
            ifCompletedBlock.addMicroInstruction(this.getProcessOutputPart1MI(this.mdServiceTask, this.mdServiceTask, true));
            ifCompletedBlock.addMicroInstruction(this.getProcessOutputPart2MI(this.mdServiceTask, this.mdServiceTask, true));
        }
        return result;
    }

    public MDServiceTask getMdServiceTask() {
        return this.mdServiceTask;
    }

    protected IMicroInstruction<Map> getInputDataAssociationMI() {
        return new MIProcessMessageInputDataAssociationsForService(this.mdServiceTask, this.mdServiceTask);
    }

    @Override
    protected IMicroInstruction getInitializeVariableMI(MDVariableDeclaration declaration) {
        return new MIInitializeMessageVariable(declaration);
    }

    @Override
    protected IMicroInstruction getProcessOutputPart1MI(MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        return new MIProcessMessageOutputDataAssociationsForService.SetContext(mdServiceActivity, mdIncomingMessage, saveAsProperty);
    }

    @Override
    protected IMicroInstruction getProcessOutputPart2MI(MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        return new MIProcessMessageOutputDataAssociationsForService.ProcessOutput(mdServiceActivity, mdIncomingMessage, saveAsProperty);
    }

    private boolean hasToProcessOutput() {
        return this.helper.hasToProcessOutput();
    }
}

