/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.engine.ext.bpel.v1.nodes.BPELContext;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateExceptionMethod;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MIUpdateProcInstanceAttr;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsActivityCompleted;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;

public class HandleCallbackGenerator {
    public static IMicroInstruction generate(FlowNode element) {
        MISequenceBlock block = new MISequenceBlock();
        MIIfBlock ifWorkItemCompleted = new MIIfBlock();
        block.addMicroInstruction(new MIHandleCallback());
        block.addMicroInstruction(ifWorkItemCompleted);
        MISequenceBlock workitemCompleted = new MISequenceBlock();
        ifWorkItemCompleted.setIfBlock(workitemCompleted);
        ifWorkItemCompleted.setExpression(new MIIsActivityCompleted());
        workitemCompleted.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
        if (ModelVisitorUtil.isNotEventHandlerOrComesFromEventBasedGateway(element) || element.asAnyNode(CatchEvent.class) != null && ((CatchEvent)element.asAnyNode(CatchEvent.class)).getEventTriggerType() == EventTriggerType.ERROR) {
            workitemCompleted.addMicroInstruction(new MIInsertInstance2Track(true));
        }
        workitemCompleted.addMicroInstruction(new MICall("POST_EXECUTION"));
        workitemCompleted.addMicroInstruction(new MIUpdateProcInstanceAttr(false));
        return block;
    }

    public static IMicroInstruction generateExceptionMethod(FlowNode element, AbstractCompiler.RegisterDelegator delegator, BPMNCubeMapBuilderContext context) {
        return GenerateExceptionMethod.generateMethod(element, delegator, context, false);
    }

    public static class MIHandleCallback
    extends MIBase<Object> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            ICubeContext ctx = context.getCubeContext();
            try {
                BPELContext.pushThreadBPELContext((ICubeContext)ctx);
                this.doHandleCallback(context);
            }
            finally {
                BPELContext.popThreadBPELContext();
            }
            return null;
        }

        private void doHandleCallback(MicroInstructionContext context) throws Throwable {
            context.callMicroInstruction("DO_HANDLE_CALLBACK");
        }
    }
}

