/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.ext.bpel.common.BaseBPELCubeBlock;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.IPostCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MIBooleanBase;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.MultiStartBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIDecreaseEventCount;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIDecreaseThreadCount;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIGenerateTokenMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIncreaseEventCount;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MISetExitBlockAbnormalFlow;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MISetExitTokenMetadata;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDGenerateNextToken;
import oracle.bpm.bpmn.engine.model.runtime.sequenceflow.UnconditionalSequenceFlowInfo;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.runtime.features.SequenceFlowToEndActivityFeature;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.ThrowEvent;
import oracle.bpm.project.model.processes.TimerEventDefinition;

public class GenerateNextTokensCompiler<P extends FlowNode>
implements IPostCompiler {
    protected BPMNCubeMapBuilderContext context;
    protected P element;
    protected MIBPMNActivityNode node;

    public GenerateNextTokensCompiler(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, P element) {
        this.context = context;
        this.node = node;
        this.element = element;
    }

    @Override
    public void compile() {
        IMicroInstruction microInstruction = this.createMicroInstruction();
        this.node.addMicroInstruction("GENERATE_NEXT_TOKENS", microInstruction);
    }

    protected IMicroInstruction createMicroInstruction() {
        MISequenceBlock block = new MISequenceBlock();
        UnconditionalSequenceFlowInfo outgoingSequenceFlow = this.node.getSequenceFlowMetadata().getOutgoingSequenceFlow();
        String nextTokenId = outgoingSequenceFlow != null ? outgoingSequenceFlow.getTargetNodeId() : this.node.getParentBlockId();
        MDGenerateNextToken md = this.createMDGenerateNextTokenMetadata(this.node, nextTokenId);
        if (nextTokenId.equals(this.node.getParentBlockId())) {
            if (this.node.isNonMainFlowEndElement()) {
                block.addMicroInstruction(new MIDecreaseEventCount());
            } else {
                if (ModelVisitorUtil.isInlineEventHandler(this.node.getFlowElement()) && ((BaseBPMNActivityBlock)this.node.getParentBlock()).isNonMainFlowEndElement()) {
                    block.addMicroInstruction(new MIDecreaseEventCount.MIDecreaseEventCountInParentScope());
                } else {
                    block.addMicroInstruction(new MISetExitTokenMetadata());
                }
                block.addMicroInstruction(new MIDecreaseThreadCount());
            }
        } else if (((BaseBPELCubeBlock)this.node.getParentBlock()).containsChild(nextTokenId)) {
            SequenceFlowToEndActivityFeature feature = (SequenceFlowToEndActivityFeature)this.node.getFlowElement().getFeature(SequenceFlowToEndActivityFeature.class);
            if (feature != null) {
                block.addMicroInstruction(new MIGenerateTokenMicroInstruction.ToMergigGatewayAsDummy(md, false));
            }
            block.addMicroInstruction(new MIGenerateTokenMicroInstruction.ToNextActivity(md));
        } else {
            SequenceFlowToEndActivityFeature feature = (SequenceFlowToEndActivityFeature)this.node.getFlowElement().getFeature(SequenceFlowToEndActivityFeature.class);
            if (feature != null) {
                block.addMicroInstruction(new MIGenerateTokenMicroInstruction.ToMergigGatewayAsDummy(md, true));
            }
            block.addMicroInstruction(new MIGenerateTokenMicroInstruction.ToNextActivityInParentScope(md));
        }
        return block;
    }

    protected MDGenerateNextToken createMDGenerateNextTokenMetadata(BPMNCubeElement sourceNode, String nextTokenId) {
        return new MDGenerateNextToken(false, sourceNode, nextTokenId);
    }

    protected void addMIForEventBasedGateway(MISequenceBlock block) {
        if (ModelVisitorUtil.comesFromEventBasedGateway(this.element)) {
            FlowNode eventBasedGateway = ((SequenceFlow)this.element.getIncomingSequenceFlows().iterator().next()).getSource();
            AuditTrailVisitorHelper.createAndAddPostAuditMI(this.context, eventBasedGateway, this.node, block);
            AuditTrailVisitorHelper.createAndAddPreAuditMI(this.context, this.element, this.node, block);
            AuditTrailVisitorHelper.createAndAddPostAuditMI(this.context, this.element, this.node, block);
            block.addMicroInstruction(new MIInsertInstance2Track(false));
            block.addMicroInstruction(new MIDecreaseThreadCount());
        }
    }

    public static class GenerateNextTokensCompilerForTimerEvent
    extends GenerateNextTokensCompilerForCatchEvents<CatchEvent> {
        public GenerateNextTokensCompilerForTimerEvent(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, CatchEvent element) {
            super(context, node, element);
            assert (element.getEventTriggerType() == EventTriggerType.TIMER);
        }

        @Override
        protected MDGenerateNextToken createMDGenerateNextTokenMetadata(BPMNCubeElement sourceNode, String nextTokenId) {
            MDGenerateNextToken nextTokenMetadata = super.createMDGenerateNextTokenMetadata(sourceNode, nextTokenId);
            return nextTokenMetadata;
        }

        @Override
        protected void generatesTokenToItself(MISequenceBlock auxBlock) {
            TimerEventDefinition definition = (TimerEventDefinition)((CatchEvent)this.element).getEventDefinition().as(TimerEventDefinition.class);
            if (definition.getTimeCycleExpression() != null) {
                super.generatesTokenToItself(auxBlock);
            }
        }
    }

    public static class GenerateNextTokensCompilerForTerminateEvent
    extends GenerateNextTokensCompiler<ThrowEvent> {
        public GenerateNextTokensCompilerForTerminateEvent(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, ThrowEvent element) {
            super(context, node, element);
        }

        @Override
        protected IMicroInstruction createMicroInstruction() {
            return new MINop();
        }
    }

    public static class GenerateNextTokensCompilerForStartEvents
    extends GenerateNextTokensCompilerForCatchEvents<StartEvent> {
        public GenerateNextTokensCompilerForStartEvents(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, StartEvent element) {
            super(context, node, element);
        }

        @Override
        protected IMicroInstruction createMicroInstruction() {
            MISequenceBlock result = new MISequenceBlock();
            if (ModelVisitorUtil.isTopLevelStart(this.element) && this.node.getParentBlock() instanceof MultiStartBlock) {
                result.addMicroInstruction(new MIDecreaseThreadCount());
                result.addMicroInstruction(new MISetExitTokenMetadata());
            } else {
                result.addMicroInstruction(super.createMicroInstruction());
            }
            return result;
        }
    }

    public static class GenerateNextTokensCompilerForReceiveTask
    extends GenerateNextTokensCompiler<ReceiveTask> {
        public GenerateNextTokensCompilerForReceiveTask(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, ReceiveTask element) {
            super(context, node, element);
        }

        @Override
        protected IMicroInstruction createMicroInstruction() {
            IMicroInstruction miSuper = super.createMicroInstruction();
            MISequenceBlock block = new MISequenceBlock();
            this.addMIForEventBasedGateway(block);
            block.addMicroInstruction(miSuper);
            return block;
        }
    }

    public static class GenerateNextTokensCompilerForGateways
    extends GenerateNextTokensCompiler<Gateway> {
        public GenerateNextTokensCompilerForGateways(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, Gateway element) {
            super(context, node, element);
        }

        @Override
        protected IMicroInstruction createMicroInstruction() {
            return new MINop();
        }
    }

    public static class GenerateNextTokensCompilerForCatchEvents<P extends CatchEvent>
    extends GenerateNextTokensCompiler<P> {
        public GenerateNextTokensCompilerForCatchEvents(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node, P element) {
            super(context, node, element);
        }

        @Override
        protected IMicroInstruction createMicroInstruction() {
            IMicroInstruction miSuper = super.createMicroInstruction();
            MISequenceBlock block = new MISequenceBlock();
            if (ModelVisitorUtil.isEventHandler((CatchEvent)this.element)) {
                if (ModelVisitorUtil.isInterrupting((CatchEvent)this.element)) {
                    block.addMicroInstruction(new MISetExitBlockAbnormalFlow());
                    block.addMicroInstruction(new MIDecreaseThreadCount());
                } else {
                    MISequenceBlock auxBlock;
                    if (BPMRuntimeLogger.isRuntimeTestEnabled()) {
                        MIIfBlock ifBlock = new MIIfBlock();
                        ifBlock.setExpression(new MIBooleanBase(){

                            @Override
                            public String getMicroInstructionDescription() {
                                return "TestReentrantLimit";
                            }

                            @Override
                            protected String getMicroInstructionDescription(MicroInstructionContext context) {
                                IScope sc = context.getWorkItem().getScope();
                                String varName = "REENTRANT_COUNTER_" + ((CatchEvent)GenerateNextTokensCompilerForCatchEvents.this.element).getId();
                                int result = 0;
                                if (sc.contains(varName)) {
                                    try {
                                        result = sc.getInt(varName);
                                    }
                                    catch (CubeException e) {
                                        // empty catch block
                                    }
                                }
                                return this.getMicroInstructionDescription() + "(" + result + ")";
                            }

                            @Override
                            protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
                                int counter;
                                String varName;
                                IScope sc = context.getWorkItem().getScope();
                                if (!sc.contains(varName = "REENTRANT_COUNTER_" + ((CatchEvent)GenerateNextTokensCompilerForCatchEvents.this.element).getId())) {
                                    sc.declareAndSet(varName, 1);
                                    counter = 1;
                                } else {
                                    counter = sc.postIncInt(varName);
                                }
                                return counter < 2;
                            }
                        });
                        MISequenceBlock ifBlockPart = new MISequenceBlock();
                        ifBlock.setIfBlock(ifBlockPart);
                        block.addMicroInstruction(ifBlock);
                        auxBlock = ifBlockPart;
                    } else {
                        auxBlock = block;
                    }
                    if (((CatchEvent)this.element).getEventTriggerType() == EventTriggerType.TIMER) {
                        this.generatesTokenToItself(auxBlock);
                    }
                    block.addMicroInstruction(new MIIncreaseEventCount());
                }
            }
            this.addAuditMIForEventHandlers(block);
            this.addMIForEventBasedGateway(block);
            block.addMicroInstruction(miSuper);
            return block;
        }

        protected void addAuditMIForEventHandlers(MISequenceBlock block) {
            if (ModelVisitorUtil.isEventHandler((CatchEvent)this.element) && ((CatchEvent)this.element).getEventTriggerType() != EventTriggerType.ERROR) {
                if (!ModelVisitorUtil.isInterrupting((CatchEvent)this.element)) {
                    block.addMicroInstruction(new MIBase<Object>(){

                        @Override
                        protected Object doExecute(MicroInstructionContext context) throws Throwable {
                            context.createNewThread();
                            return null;
                        }

                        @Override
                        public String getMicroInstructionDescription() {
                            return "CreateNewThread";
                        }
                    });
                }
                if (((CatchEvent)this.element).isBoundaryEvent()) {
                    AuditTrailVisitorHelper.createAndAddPreAuditMI(this.context, this.element, this.node, block);
                    AuditTrailVisitorHelper.createAndAddPostAuditMI(this.context, this.element, this.node, block);
                    block.addMicroInstruction(new MIInsertInstance2Track(false));
                }
            }
        }

        protected void generatesTokenToItself(MISequenceBlock auxBlock) {
            auxBlock.addMicroInstruction(new MIGenerateTokenMicroInstruction.ToNextActivity(new MDGenerateNextToken(false, this.node, this.node.getId())));
        }
    }
}

