/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.MITrapSelectionFailure;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBooleanBase;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIThrowException;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.TrappableException;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import org.jetbrains.annotations.NotNull;

public class GenerateExceptionMethod {
    public static IMicroInstruction generateMethod(FlowNode element, AbstractCompiler.RegisterDelegator delegator, BPMNCubeMapBuilderContext context, boolean mustPropagate) {
        boolean suspendInstanceOnDataAssociationError = element.getProcess().isSuspendInstanceOnDataAssociationError();
        if (suspendInstanceOnDataAssociationError && !GenerateExceptionMethod.isCreateInstanceElement(element)) {
            MIIfBlock have2Trap = new MIIfBlock();
            have2Trap.setExpression(new MIMustCatchException());
            MISequenceBlock thenBlock = new MISequenceBlock();
            thenBlock.addMicroInstruction(new MIInsertInstance2Track("SUSPENDED"));
            MDAuditLog postAuditMD = AuditTrailVisitorHelper.getPostAuditMD(context, element, Tag.POST_AUDIT_NORMAL);
            postAuditMD.setAuditInstanceOperation(AuditInstanceOperation.INSTANCE_SUSPENDED);
            IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(postAuditMD);
            thenBlock.addMicroInstruction(auditMI);
            thenBlock.addMicroInstruction(new MITrapSelectionFailure(false));
            have2Trap.setIfBlock(thenBlock);
            MISequenceBlock elseBlock = new MISequenceBlock();
            elseBlock.addMicroInstruction(GenerateExceptionMethod.buildThrowExceptionBlock(element, delegator, context, mustPropagate));
            have2Trap.setElseBlock(elseBlock);
            return have2Trap;
        }
        return GenerateExceptionMethod.buildThrowExceptionBlock(element, delegator, context, mustPropagate);
    }

    private static boolean isCreateInstanceElement(FlowNode element) {
        return ModelVisitorUtil.isTopLevelStart(element, true);
    }

    private static MISequenceBlock buildThrowExceptionBlock(FlowNode element, AbstractCompiler.RegisterDelegator delegator, BPMNCubeMapBuilderContext context, boolean mustPropagateFault) {
        MISequenceBlock block = new MISequenceBlock();
        block.addMicroInstruction(new MIInsertInstance2Track("ERRORED"));
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createAndAddPostAuditMI(context, element, delegator, null, Tag.POST_AUDIT_EXCEPTION);
        block.addMicroInstruction(auditMI);
        block.addMicroInstruction(new MIThrowException(mustPropagateFault));
        return block;
    }

    static class MIMustCatchException
    extends MIBooleanBase {
        MIMustCatchException() {
        }

        @Override
        protected Boolean doExecute(MicroInstructionContext context) throws Throwable {
            Throwable lastEx = context.getLastException();
            return MIMustCatchException.isMustCatchException(lastEx);
        }

        private static boolean isMustCatchException(@NotNull Throwable lastEx) {
            return lastEx instanceof TrappableException;
        }
    }
}

