/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.logging.Level;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateExceptionMethod;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MIUpdateProcInstanceAttr;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsActivityCompleted;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;

public class ExecuteStatementGenerator {
    public static IMicroInstruction generate(FlowNode element) {
        boolean isUserTask;
        MISequenceBlock block = new MISequenceBlock();
        block.addMicroInstruction(new MILogIn());
        block.addMicroInstruction(new MICall("PRE_EXECUTION"));
        block.addMicroInstruction(new MIUpdateProcInstanceAttr(true));
        block.addMicroInstruction(new MICall("DO_EXECUTE_STATEMENT"));
        MIIfBlock miIfBlock = new MIIfBlock();
        miIfBlock.setExpression(new MIIsActivityCompleted());
        MISequenceBlock miIfBlockThen = new MISequenceBlock();
        miIfBlockThen.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
        miIfBlockThen.addMicroInstruction(new MICall("POST_EXECUTION"));
        miIfBlockThen.addMicroInstruction(new MIUpdateProcInstanceAttr(false));
        miIfBlock.setIfBlock(miIfBlockThen);
        block.addMicroInstruction(miIfBlock);
        boolean isEndEvent = ModelVisitorUtil.isThreadEndEvent(element);
        boolean isTerminateEndEvent = ModelVisitorUtil.isTerminateEndEvent(element);
        boolean bl = isUserTask = element.getBpmnType() == BpmnType.USER_TASK;
        if (isTerminateEndEvent) {
            block.addMicroInstruction(new MIInsertInstance2Track.MIInsertInstance2TrackProcess("ABORTED"));
        } else if (isEndEvent) {
            block.addMicroInstruction(new MIInsertInstance2Track(true));
        } else if (!isUserTask && ModelVisitorUtil.isNotEventHandlerOrComesFromEventBasedGateway(element) || element.asAnyNode(CatchEvent.class) != null && ((CatchEvent)element.asAnyNode(CatchEvent.class)).getEventTriggerType() == EventTriggerType.ERROR) {
            MIIfBlock miIfBlock2 = new MIIfBlock();
            miIfBlock2.setExpression(new MIIsActivityCompleted());
            miIfBlock2.setElseBlock(new MIInsertInstance2Track(false));
            block.addMicroInstruction(miIfBlock2);
        }
        return block;
    }

    public static IMicroInstruction generateExceptionMethod(FlowNode element, AbstractCompiler.RegisterDelegator delegator, BPMNCubeMapBuilderContext context) {
        return GenerateExceptionMethod.generateMethod(element, delegator, context, true);
    }

    public static class MILogIn
    extends MIBase<Object> {
        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            IWorkItem wi = context.getWorkItem();
            IScope sc = wi.getScope();
            BPMRuntimeLogger.log(Level.ALL, "oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExecuteStatementGenerator.MILogIn", "__executeStatements", "executed");
            return null;
        }
    }
}

