/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import oracle.bpel.services.notification.payload.BodyPartType;
import oracle.bpel.services.notification.payload.BodyPartTypeFactory;
import oracle.bpel.services.notification.payload.ContentType;
import oracle.bpel.services.notification.payload.ContentTypeFactory;
import oracle.bpel.services.notification.payload.EmailHeaderType;
import oracle.bpel.services.notification.payload.EmailHeaderTypeFactory;
import oracle.bpel.services.notification.payload.EmailHeaders;
import oracle.bpel.services.notification.payload.EmailHeadersFactory;
import oracle.bpel.services.notification.payload.EmailPayloadType;
import oracle.bpel.services.notification.payload.EmailPayloadTypeFactory;
import oracle.bpel.services.notification.payload.IBodyPartType;
import oracle.bpel.services.notification.payload.IContentType;
import oracle.bpel.services.notification.payload.IEmailHeaderType;
import oracle.bpel.services.notification.payload.IEmailHeaders;
import oracle.bpel.services.notification.payload.IEmailPayloadType;
import oracle.bpel.services.notification.payload.INotificationContextType;
import oracle.bpel.services.notification.payload.MultiPartType;
import oracle.bpel.services.notification.payload.MultiPartTypeFactory;
import oracle.bpel.services.notification.payload.NotificationContextType;
import oracle.bpel.services.notification.payload.NotificationContextTypeFactory;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractNotificationTypeProcessInputMI;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExpressionEvaluator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.NotificationPayloadTypeProxy;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDNotificationTask;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.catalog.type.utils.NotificationServiceHelper;
import oracle.bpm.project.model.processes.notification.MailNotificationAttachment;
import oracle.bpm.project.model.processes.notification.MailNotificationDefinition;
import oracle.bpm.project.model.processes.notification.MailNotificationHeader;
import org.collaxa.xml.IBaseFacade;
import org.w3c.dom.Element;

public class EmailNotificationTypeProcessInputMI
extends AbstractNotificationTypeProcessInputMI {
    EmailNotificationTypeProcessInputMI(MDNotificationTask mdNotificationTask) {
        super(mdNotificationTask);
    }

    @Override
    protected IBaseFacade createNotificationPayload(ICubeContext ctx, IWorkItem wi, IScope scope) throws Exception {
        MailNotificationDefinition definition = (MailNotificationDefinition)this.getMdNotificationTask().getNotificationDefinition().as(MailNotificationDefinition.class);
        EmailPayloadType delegate = EmailPayloadTypeFactory.createFacade();
        IEmailPayloadType payloadType = NotificationPayloadTypeProxy.create(this.getClass().getClassLoader(), IEmailPayloadType.class, delegate);
        AbstractNotificationTypeProcessInputMI.ExpressionEvaluatorImpl expressionEvaluator = new AbstractNotificationTypeProcessInputMI.ExpressionEvaluatorImpl(this, ctx, scope);
        for (MailField mailField : MailField.values()) {
            mailField.putValue(expressionEvaluator, definition, payloadType);
        }
        return delegate;
    }

    private static enum MailField {
        FROM{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws CubeException {
                String from = expressionEvaluator.evaluateStringExpression(definition.getFromAccount());
                payload.setFromAccountName(from);
            }
        }
        ,
        TO{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws CubeException {
                String to = expressionEvaluator.evaluateStringExpression(definition.getTo());
                payload.setTo(to);
            }
        }
        ,
        REPLY_TO{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws CubeException {
                String replyTo = expressionEvaluator.evaluateStringExpression(definition.getReplyTo());
                payload.setReplyToAddress(replyTo);
            }
        }
        ,
        SUBJECT{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws CubeException {
                String subject = expressionEvaluator.evaluateStringExpression(definition.getSubject());
                payload.setSubject(subject);
            }
        }
        ,
        BODY{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws Exception {
                Object body = expressionEvaluator.evaluateObjectExpression(definition.getBody());
                ContentType contentType = ContentTypeFactory.createFacade();
                if (definition.getAttachments().isEmpty()) {
                    contentType.setContentBody(body);
                    contentType.setMimeType(MailField.MIME_TYPE_HTML);
                    contentType.addChildElement(MailField.CONTENT_ENCODING_ELEM_NAME, NotificationServiceHelper.NOTIFICATION_SERVICE_NAMESPACE, null);
                    payload.setContent((IContentType)contentType);
                } else {
                    String bodyContent = expressionEvaluator.evaluateStringExpression(definition.getBody());
                    BodyPartType bodyPart = BodyPartTypeFactory.createFacade();
                    bodyPart.setMimeType(MailField.MIME_TYPE_HTML);
                    bodyPart.setContentBody((Object)bodyContent.replaceAll("\r?\n", "<br/>"));
                    MultiPartType multiPart = MultiPartTypeFactory.createFacade();
                    multiPart.addBodyPart((IBodyPartType)bodyPart);
                    ContentType multiPartContentType = ContentTypeFactory.createFacade();
                    multiPartContentType.setContentBody((Object)multiPart);
                    contentType.setMimeType(MailField.MULTIPART_MIXED);
                    contentType.setContentBody((Object)multiPartContentType);
                    payload.setContent((IContentType)contentType);
                }
            }
        }
        ,
        HEADERS{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws Exception {
                Sequence headers = definition.getHeaders();
                if (!headers.isEmpty()) {
                    EmailHeaders emailHeaders = EmailHeadersFactory.createFacade();
                    for (MailNotificationHeader header : headers) {
                        String name = expressionEvaluator.evaluateStringExpression(header.getName());
                        String value = expressionEvaluator.evaluateStringExpression(header.getValue());
                        EmailHeaderType emailHeader = EmailHeaderTypeFactory.createFacade();
                        emailHeader.setHeaderName(name);
                        emailHeader.setHeaderValue(value);
                        emailHeaders.addEmailHeader((IEmailHeaderType)emailHeader);
                    }
                    payload.setEmailHeaders((IEmailHeaders)emailHeaders);
                }
            }
        }
        ,
        CC{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws CubeException {
                String cc = expressionEvaluator.evaluateStringExpression(definition.getCc());
                payload.setCc(cc);
            }
        }
        ,
        BCC{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws CubeException {
                String bcc = expressionEvaluator.evaluateStringExpression(definition.getBcc());
                payload.setBcc(bcc);
            }
        }
        ,
        NOTIFICATION_CONTEXT{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws Exception {
                NotificationContextType notificationContext = NotificationContextTypeFactory.createFacade();
                payload.setNotificationContext((INotificationContextType)notificationContext);
            }
        }
        ,
        ATTACHMENTS{

            @Override
            public void putValue(ExpressionEvaluator expressionEvaluator, MailNotificationDefinition definition, IEmailPayloadType payload) throws Exception {
                if (!definition.getAttachments().isEmpty()) {
                    ContentType contentType = new ContentType((Element)payload.getContent().getContentBody());
                    MultiPartType multiPart = new MultiPartType(contentType.getChildElement(MailField.MULTI_PART_ELEM_NAME, NotificationServiceHelper.NOTIFICATION_SERVICE_NAMESPACE));
                    for (MailNotificationAttachment attachment : definition.getAttachments()) {
                        String name = expressionEvaluator.evaluateStringExpression(attachment.getName());
                        String mimeType = expressionEvaluator.evaluateStringExpression(attachment.getMimeType());
                        String contentEncoding = expressionEvaluator.evaluateStringExpression(attachment.getEncoding());
                        String contentBody = expressionEvaluator.evaluateStringExpression(attachment.getValue());
                        BodyPartType bodyPart = BodyPartTypeFactory.createFacade();
                        bodyPart.setBodyPartName(name);
                        bodyPart.setMimeType(mimeType);
                        bodyPart.setContentEncoding(contentEncoding);
                        bodyPart.setContentBody((Object)contentBody);
                        multiPart.addBodyPart((IBodyPartType)bodyPart);
                    }
                }
            }
        };

        private static final String CONTENT_ENCODING_ELEM_NAME = "ContentEncoding";
        private static final String MULTIPART_MIXED = "multipart/mixed";
        private static final String MULTI_PART_ELEM_NAME = "MultiPart";
        private static final String MIME_TYPE_HTML = "text/html; charset=UTF-8";

        public abstract void putValue(ExpressionEvaluator var1, MailNotificationDefinition var2, IEmailPayloadType var3) throws Exception;
    }
}

