/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.ICubeInstanceObserver;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.map.ICubeNode;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDIncomingMessage;
import oracle.bpm.bpmn.engine.microkernel.MDServiceActivity;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;

abstract class BaseActivityGenerator {
    protected static final String CLONE_VARIABLE = "CloneVariable";
    protected static final String SET_DATA_ASSOCIATION_INPUT_VARIABLE = "SetDataAssociationInputVariable";
    protected static final String SET_DATA_ASSOCIATION_OUTPUT_VARIABLE = "SetDataAssociationOutputVariable";
    protected static final String MARK_WORK_ITEM_AS_OPEN_PENDING_COMPLETE = "MarkWorkItemAsOpenPendingComplete";
    protected static final String MARK_WORK_ITEM_AS_PERFORMER_IDEMPOTENT = "MarkWorkItemAsPerformerIdempotent";
    protected static final String IS_IN_EVENT_HANDLER = "IsInEventHandler";
    protected static final String FINALIZE_NODE = "FinalizeNode";
    protected static final String MARK_WORK_ITEM_AS_COMPLETE = "MarkWorkItemAsComplete";
    protected static final String ON_VARIABLE_CHANGE = "OnVariableChange";
    protected static final String ON_ACTIVITY_COMPLETE = "OnActivityComplete";
    protected static final String MARK_AS_PERFORMER_IDEMPOTENT_AND_COMPLETE = "MarkAsPerformerIdempotentAndComplete";

    BaseActivityGenerator() {
    }

    public void addProcessOutputMI(MISequenceBlock sequenceBlock, MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, MDVariableDeclaration mdVariableDeclaration) {
        FlowNode element = mdServiceActivity.getFlowElement();
        CatchEvent event = (CatchEvent)element.asAnyNode(CatchEvent.class);
        if (this.isStartOfEventHandlerNotError(event)) {
            this.addProcessOutputMIPart1(sequenceBlock, mdServiceActivity, mdIncomingMessage, mdVariableDeclaration, false);
        } else {
            this.addProcessOutputMIPart1(sequenceBlock, mdServiceActivity, mdIncomingMessage, mdVariableDeclaration, true);
            this.addProcessOutputMIPart2(sequenceBlock, mdServiceActivity, mdIncomingMessage, true);
        }
    }

    public void addProcessOutputMIPart2(MISequenceBlock sequenceBlock, MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, boolean saveAsProperty) {
        sequenceBlock.addMicroInstruction(this.getProcessOutputPart2MI(mdServiceActivity, mdIncomingMessage, saveAsProperty));
    }

    protected abstract IMicroInstruction getProcessOutputPart1MI(MDServiceActivity var1, MDIncomingMessage var2, boolean var3);

    protected abstract IMicroInstruction getProcessOutputPart2MI(MDServiceActivity var1, MDIncomingMessage var2, boolean var3);

    protected abstract IMicroInstruction getInitializeVariableMI(MDVariableDeclaration var1);

    protected final boolean isStartOfEventHandlerNotError(CatchEvent event) {
        return event != null && ModelVisitorUtil.isStartOfInlineEventHandler(event) && event.getEventTriggerType() != EventTriggerType.ERROR;
    }

    protected MIBase<Object> createSetDataAssociationOutputVariable(final MDVariableDeclaration mdOutputVarDeclaration) {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.setProperty("DATA_ASSOCIATION_OUTPUT_VARIABLE", mdOutputVarDeclaration.getName());
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return BaseActivityGenerator.SET_DATA_ASSOCIATION_OUTPUT_VARIABLE;
            }
        };
    }

    protected IMicroInstruction<Object> createOnVariableChange(final MDReceive mdReceive) {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                ICubeContext ctx = context.getCubeContext();
                IScope scope = context.getWorkItem().getScope();
                ICubeNode node = context.getWmp().getCubeNode();
                Object variable = scope.getObject(mdReceive.getInputVariableName());
                ICubeInstanceObserver obs = scope.getCubeInstance().getObserver();
                obs.onVariableChange(variable, node.getName(), node.getType(), scope, ctx);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return BaseActivityGenerator.ON_VARIABLE_CHANGE;
            }
        };
    }

    protected MIBase<Object> createOnActivityComplete() {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                ICubeContext ctx = context.getCubeContext();
                IScope scope = context.getWorkItem().getScope();
                ICubeNode node = context.getWmp().getCubeNode();
                ICubeInstanceObserver obs = scope.getCubeInstance().getObserver();
                obs.onActivityComplete(node.getName(), node.getId(), node.getType(), Integer.toString(node.getLineNumber()), scope, ctx);
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return BaseActivityGenerator.ON_ACTIVITY_COMPLETE;
            }
        };
    }

    protected MIBase<Object> createSetDataAssociationInputVariable(final MDVariableDeclaration mdInputVarDeclaration) {
        return new MIBase<Object>(){

            @Override
            protected Object doExecute(MicroInstructionContext context) throws Throwable {
                context.setProperty("DATA_ASSOCIATION_INPUT_VARIABLE", mdInputVarDeclaration.getName());
                return null;
            }

            @Override
            public String getMicroInstructionDescription() {
                return BaseActivityGenerator.SET_DATA_ASSOCIATION_INPUT_VARIABLE;
            }
        };
    }

    protected IMicroInstruction createCloneVariableMI(MDVariableDeclaration mdVariableDeclaration, MDVariableDeclaration targetVariableDeclaration) {
        return new MINop();
    }

    private void addProcessOutputMIPart1(MISequenceBlock sequenceBlock, MDServiceActivity mdServiceActivity, MDIncomingMessage mdIncomingMessage, MDVariableDeclaration mdVariableDeclaration, boolean saveAsProperty) {
        MDVariableDeclaration targetVariableDeclaration = mdVariableDeclaration;
        if (!saveAsProperty) {
            targetVariableDeclaration = new MDVariableDeclaration(null, mdVariableDeclaration.getType());
            sequenceBlock.addMicroInstruction(this.createCloneVariableMI(mdVariableDeclaration, targetVariableDeclaration));
        } else {
            sequenceBlock.addMicroInstruction(this.createSetDataAssociationOutputVariable(targetVariableDeclaration));
        }
        sequenceBlock.addMicroInstruction(this.getProcessOutputPart1MI(mdServiceActivity, mdIncomingMessage, saveAsProperty));
    }
}

