/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExpressionEvaluator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.NotificationTypeProcessInputMI;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIProcessMessageInputDataAssociationsForService;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDNotificationTask;
import oracle.bpm.bpmn.engine.runtime.BPMNExpression;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionDataElementContextType;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionLanguage;
import oracle.bpm.bpmn.engine.runtime.BPMNExpressionMetadata;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.collaxa.xml.IBaseFacade;

public abstract class AbstractNotificationTypeProcessInputMI
implements NotificationTypeProcessInputMI {
    private MDNotificationTask mdNotificationTask;

    protected AbstractNotificationTypeProcessInputMI(MDNotificationTask mdNotificationTask) {
        this.mdNotificationTask = mdNotificationTask;
    }

    @Override
    public final IMicroInstruction<Map> getInputDataAssociationMI() {
        return new MIProcessMessageInputDataAssociationsForService(this.getMdNotificationTask(), this.getMdNotificationTask()){

            @Override
            protected Map<String, Object> doProcessInput(ICubeContext ctx, IWorkItem wi, IScope sc, DataAssociationSet inputDataAssociationSet) throws Exception {
                HashMap<String, Object> result = new HashMap<String, Object>();
                String partName = AbstractNotificationTypeProcessInputMI.this.getMdNotificationTask().getInputPartNamesMap().values().iterator().next();
                IBaseFacade payload = AbstractNotificationTypeProcessInputMI.this.createNotificationPayload(ctx, wi, sc);
                result.put(partName, payload.toDOM());
                return result;
            }

            @Override
            public String getMicroInstructionDescription() {
                return "DoProcessInput_" + AbstractNotificationTypeProcessInputMI.this.getClass().getSimpleName();
            }
        };
    }

    public String evaluateStringExpression(ICubeContext ctx, Expression expression, IScope scope) throws CubeException {
        return this.createBPMNExpression(expression, scope).evaluateString(scope, ctx);
    }

    public Object evaluateObjectExpression(ICubeContext ctx, Expression expression, IScope scope) throws CubeException {
        return this.createBPMNExpression(expression, scope).evaluateObject(scope, ctx);
    }

    public boolean evaluateBooleanExpression(ICubeContext ctx, Expression expression, IScope scope) throws CubeException {
        return this.createBPMNExpression(expression, scope).evaluateBoolean(scope, ctx);
    }

    public Number evaluateNumberExpression(ICubeContext ctx, Expression expression, IScope scope) throws CubeException {
        return this.createBPMNExpression(expression, scope).evaluateNumber(scope, ctx);
    }

    protected abstract IBaseFacade createNotificationPayload(ICubeContext var1, IWorkItem var2, IScope var3) throws Exception;

    protected MDNotificationTask getMdNotificationTask() {
        return this.mdNotificationTask;
    }

    private BPMNExpression createBPMNExpression(Expression expression, IScope scope) throws CubeException {
        NodeContainer container = this.mdNotificationTask.getFlowElement().getParentObject();
        Sequence refs = ExpressionHelper.getRefs((Expression)expression, (DataDeclarationContainer)container);
        Sequence dataElements = refs.map((Function)new Function<DataDeclaration, String>(){

            public String eval(DataDeclaration value) {
                return value.getName();
            }
        });
        BPMNExpressionMetadata bpmnExpressionMetadata = new BPMNExpressionMetadata(BPMNExpressionDataElementContextType.DATAOBJECTS_CONTEXT, (Sequence<String>)dataElements, expression.getExpressionValue(), BPMNExpressionLanguage.XPATH, expression.getNamespaces());
        return BPMNExpression.createBPMNExpression(this.mdNotificationTask.getFlowElement(), bpmnExpressionMetadata, scope);
    }

    protected class ExpressionEvaluatorImpl
    implements ExpressionEvaluator {
        private final ICubeContext ctx;
        private final AbstractNotificationTypeProcessInputMI delegate;
        private final IScope scope;

        protected ExpressionEvaluatorImpl(AbstractNotificationTypeProcessInputMI delegate, ICubeContext ctx, IScope scope) {
            this.delegate = delegate;
            this.ctx = ctx;
            this.scope = scope;
        }

        @Override
        public String evaluateStringExpression(Expression expression) throws CubeException {
            if (expression == null) {
                return null;
            }
            return this.delegate.evaluateStringExpression(this.ctx, expression, this.scope);
        }

        @Override
        public Object evaluateObjectExpression(Expression expression) throws CubeException {
            if (expression == null) {
                return null;
            }
            return this.delegate.evaluateObjectExpression(this.ctx, expression, this.scope);
        }

        @Override
        public Boolean evaluateBooleanExpression(Expression expression) throws CubeException {
            if (expression == null) {
                return null;
            }
            return this.delegate.evaluateBooleanExpression(this.ctx, expression, this.scope);
        }

        @Override
        public Number evaluateNumberExpression(Expression expression) throws CubeException {
            if (expression == null) {
                return null;
            }
            return this.delegate.evaluateNumberExpression(this.ctx, expression, this.scope);
        }
    }
}

