/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers;

import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.CancelPerformGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExecuteStatementGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ExpireMethodGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.HandleCallbackGenerator;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.project.model.processes.FlowNode;

public abstract class AbstractCompiler<T extends FlowNode> {
    private T element;
    private RegisterDelegator registerDelegator;
    public static final String EXECUTE_STATEMENT = "EXECUTE_STATEMENT";
    public static final String EXECUTE_STATEMENT_EXCEPTION = "EXECUTE_STATEMENT_EXCEPTION";
    public static final String HANDLE_CALLBACK = "HANDLE_CALLBACK";
    public static final String HANDLE_CALLBACK_EXCEPTION = "HANDLE_CALLBACK_EXCEPTION";
    public static final String EXPIRE = "EXPIRE";
    public static final String DEFINE_EXPIRATION_DATE = "DEFINE_EXPIRATION_DATE";
    public static final String CANCEL_PERFORM = "CANCEL_PERFORM";
    public static final String THROW_EXCEPTION = "THROW_EXCEPTION";
    public static final String GENERATE_NEXT_TOKENS = "GENERATE_NEXT_TOKENS";
    public static final String DO_EXECUTE_STATEMENT = "DO_EXECUTE_STATEMENT";
    public static final String DO_HANDLE_CALLBACK = "DO_HANDLE_CALLBACK";
    public static final String DO_EXPIRE = "DO_EXPIRE";
    public static final String PRE_EXECUTION = "PRE_EXECUTION";
    public static final String POST_EXECUTION = "POST_EXECUTION";

    public AbstractCompiler(T element, RegisterDelegator registerDelegator) {
        this.element = element;
        this.registerDelegator = registerDelegator;
    }

    public void compile(BPMNCubeMapBuilderContext context) {
        IMicroInstruction miExecuteStatement = this.generateExecuteStatementMethod();
        this.registerMethod(miExecuteStatement, EXECUTE_STATEMENT);
        IMicroInstruction miExecuteStatementException = this.generateExecuteStatementExceptionMethod(context);
        this.registerMethod(miExecuteStatementException, EXECUTE_STATEMENT_EXCEPTION);
        IMicroInstruction miHandleCallback = this.generateHandleCallbackMethod();
        this.registerMethod(miHandleCallback, HANDLE_CALLBACK);
        IMicroInstruction miHandleCallbackException = this.generateHandleCallbackExceptionMethod(context);
        this.registerMethod(miHandleCallbackException, HANDLE_CALLBACK_EXCEPTION);
        IMicroInstruction miExpire = this.generateExpireMethod();
        this.registerMethod(miExpire, EXPIRE);
        IMicroInstruction miDefineExpirationDate = this.generateDefineExpirationDateMethod();
        this.registerMethod(miDefineExpirationDate, DEFINE_EXPIRATION_DATE);
        IMicroInstruction miCancelPerform = this.generateCancelPerformMethod(context);
        this.registerMethod(miCancelPerform, CANCEL_PERFORM);
        IMicroInstruction miThrowException = this.generateThrowExceptionMethod();
        this.registerMethod(miThrowException, THROW_EXCEPTION);
        this.registerMethod(new MINop(), PRE_EXECUTION);
        this.registerMethod(new MINop(), POST_EXECUTION);
    }

    protected abstract IMicroInstruction<Object> getDoExecuteStatement();

    protected abstract IMicroInstruction<Object> getDoHandleCallback();

    protected T getElement() {
        return this.element;
    }

    protected IMicroInstruction generateExecuteStatementMethod() {
        IMicroInstruction result = ExecuteStatementGenerator.generate(this.getElement());
        IMicroInstruction<Object> doExecuteStatement = this.getDoExecuteStatement();
        this.registerMethod(doExecuteStatement, DO_EXECUTE_STATEMENT);
        return result;
    }

    protected IMicroInstruction generateExecuteStatementExceptionMethod(BPMNCubeMapBuilderContext context) {
        return ExecuteStatementGenerator.generateExceptionMethod(this.getElement(), this.registerDelegator, context);
    }

    protected IMicroInstruction generateHandleCallbackMethod() {
        IMicroInstruction result = HandleCallbackGenerator.generate(this.getElement());
        IMicroInstruction<Object> miDoHandleCallback = this.getDoHandleCallback();
        this.registerMethod(miDoHandleCallback, DO_HANDLE_CALLBACK);
        return result;
    }

    protected IMicroInstruction generateHandleCallbackExceptionMethod(BPMNCubeMapBuilderContext context) {
        return HandleCallbackGenerator.generateExceptionMethod(this.getElement(), this.registerDelegator, context);
    }

    protected IMicroInstruction generateExpireMethod() {
        IMicroInstruction<Object> miDoExpire = this.getDoExpire();
        if (miDoExpire instanceof MINop) {
            return miDoExpire;
        }
        IMicroInstruction result = ExpireMethodGenerator.generate();
        this.registerMethod(miDoExpire, DO_EXPIRE);
        return result;
    }

    protected IMicroInstruction<Object> getDoExpire() {
        return new MINop();
    }

    protected IMicroInstruction generateDefineExpirationDateMethod() {
        return new MINop();
    }

    protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
        return CancelPerformGenerator.generate(this.getElement(), this.registerDelegator, context);
    }

    protected IMicroInstruction generateThrowExceptionMethod() {
        return new MINop();
    }

    protected void registerMethod(IMicroInstruction mi, String symbol) {
        this.registerDelegator.register(mi, symbol);
    }

    public static interface RegisterDelegator {
        public void register(IMicroInstruction var1, String var2);

        public void tag(BPMNCubeMapBuilderContext var1, TagInfo var2);
    }
}

