/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentException;
import com.collaxa.cube.xml.dom.DOMUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractBPMNActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvoke;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeExpire;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsCallbackForRecovery;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsNotWorkItemFaulted;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsReInitializeVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceiveCancel;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskRequest;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskResponse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIUserTaskWithdraw;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.resolver.MDServiceTaskBuilder;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.SchemaUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.composite.model.ComponentModel;
import oracle.xml.parser.v2.XMLElement;

public class UserTaskVisitorImpl
extends MIAbstractBPMNActivityVisitor<UserTask> {
    @Override
    protected MIVisitor<CompilationResult> createMIVisitor(final UserTask userTask, BPMNCubeMapBuilderContext context) throws CubeException {
        String referenceName = userTask.getHumanTask().getText() + ".reference";
        if (userTask.isManualStart()) {
            context.setCreateInstanceEventInitiationInfo();
        }
        context.addExtraServiceLinkDeclaration(referenceName);
        DataHandlingUtils.handleIoSpecificationImports(userTask.getInputDataAssociationSet(), context);
        String inputVariable = userTask.getDefaultLabel() + "_" + userTask.getId() + "_in";
        final String outputVariable = userTask.getDefaultLabel() + "_" + userTask.getId() + "_out";
        ComponentModel model = context.getComponentModel();
        MDOperationRef mdOperationRef = this.getOperationReference(userTask, true);
        MDServiceTaskBuilder mDServiceTaskBuilder = new MDServiceTaskBuilder(inputVariable, outputVariable, userTask.getOutputDataAssociationSet(), userTask.getInputDataAssociationSet(), userTask.getOutputArgumentsContainer(), userTask.getInputArgumentsContainer(), mdOperationRef, referenceName, null, null, (FlowNode)userTask, null, null);
        mDServiceTaskBuilder.setMarkCompleteWhenDone(false);
        mDServiceTaskBuilder.setInitiateInCorrelationSets(userTask.getInputCorrelationsContainer());
        final MDServiceTask mdServiceTask = mDServiceTaskBuilder.build();
        final Map<String, Object> defaultValuesMap = this.getDefaultValues(userTask, model);
        return new SimpleVisitorImpl<UserTask, CompilationResult>(userTask, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<UserTask>(userTask, delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        boolean isReinitiateItself = userTask.isReinitiate() && userTask.getReinitiateSource() != null && userTask.getReinitiateSource().getId().equals(userTask.getId());
                        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MDVariableDeclaration mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MIIfBlock ifBlock = new MIIfBlock();
                        ifBlock.setExpression(new MIIsReInitializeVariable(mdServiceTask.getOutputVariableName(), !isReinitiateItself));
                        ifBlock.setIfBlock(new MIInitializeMessageVariable(mdOutputVarDeclaration));
                        MISequenceBlock result = new MISequenceBlock();
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
                        result.addMicroInstruction(ifBlock);
                        result.addMicroInstruction(new MIInsertInstance2Track(false, true));
                        result.addMicroInstruction(new MIUserTaskRequest(mdServiceTask, defaultValuesMap));
                        result.addMicroInstruction(new MIInvoke(mdServiceTask));
                        MIIfBlock ifInitiateFault = new MIIfBlock();
                        ifInitiateFault.setExpression(new MIIsNotWorkItemFaulted());
                        MIUserTaskResponse ifBlockInitiateFault = new MIUserTaskResponse(mdServiceTask);
                        ifInitiateFault.setIfBlock(ifBlockInitiateFault);
                        result.addMicroInstruction(ifInitiateFault);
                        return result;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        String[] initiateCorrelationSetNames;
                        MISequenceBlock callback = new MISequenceBlock();
                        MIIfBlock ifInitiateFault = new MIIfBlock();
                        ifInitiateFault.setExpression(new MIIsNotWorkItemFaulted(false));
                        ifInitiateFault.setIfBlock(new MIUserTaskResponse(mdServiceTask));
                        MISequenceBlock recovery = new MISequenceBlock();
                        recovery.addMicroInstruction(new MIInvokeCallback(mdServiceTask));
                        recovery.addMicroInstruction(ifInitiateFault);
                        MIIfBlock result = new MIIfBlock();
                        result.setExpression(new MIIsCallbackForRecovery());
                        result.setIfBlock(recovery);
                        result.setElseBlock(callback);
                        CorrelationItemsContainer correlationItemsContainer = userTask.getOutputCorrelationsContainer();
                        if (correlationItemsContainer != null) {
                            ArrayList<String> initiateList = new ArrayList<String>();
                            for (CorrelationItem item : correlationItemsContainer.getCorrelationItems()) {
                                String correlationName = item.getCorrelationKey().getName();
                                if (!item.initiates()) continue;
                                initiateList.add(correlationName);
                            }
                            initiateCorrelationSetNames = new String[initiateList.size()];
                            initiateList.toArray(initiateCorrelationSetNames);
                        } else {
                            initiateCorrelationSetNames = new String[]{};
                        }
                        callback.addMicroInstruction(new MIUserTaskCallback(userTask, UserTaskVisitorImpl.this.getOperationReference(userTask, false), outputVariable, initiateCorrelationSetNames));
                        callback.addMicroInstruction(new MIInsertInstance2Track(true));
                        return result;
                    }

                    @Override
                    protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
                        MISequenceBlock block = new MISequenceBlock();
                        block.addMicroInstruction(new MIReceiveCancel());
                        block.addMicroInstruction(new MIUserTaskWithdraw());
                        block.addMicroInstruction(super.generateCancelPerformMethod(context));
                        return block;
                    }

                    @Override
                    protected IMicroInstruction getDoExpire() {
                        return new MIInvokeExpire(mdServiceTask);
                    }
                };
            }
        };
    }

    private Map<String, Object> getDefaultValues(UserTask userTask, ComponentModel model) throws DeploymentException {
        HashMap<String, Object> elementMap = new HashMap<String, Object>();
        if (model != null) {
            try {
                DataAssociationSet inputAssociation = userTask.getInputDataAssociationSet();
                if (inputAssociation != null) {
                    Sequence dataDeclarationSequence = inputAssociation.getArgumentsContainer().getDeclarations();
                    Object[] dataDecls = dataDeclarationSequence.toArray();
                    int declSize = dataDecls.length - 1;
                    for (int i = 0; i < declSize; ++i) {
                        XMLElement childElement;
                        String argName;
                        DataDeclaration dataDeclaration = (DataDeclaration)dataDecls[i];
                        SchemaObject asSchemaObject = dataDeclaration.getType().getDelegate().asSchemaObject();
                        SchemaManager schemaManager = model.getComposite().getSchemaManager();
                        if (asSchemaObject.isType()) {
                            argName = dataDeclaration.getNativeName();
                            childElement = asSchemaObject.isBasicType() ? (XMLElement)DOMUtil.createRootElement((String)argName, (String)"http://xmlns.oracle.com/bpel/workflow/task") : SchemaUtils.generateXMLForXSDType(schemaManager, "http://xmlns.oracle.com/bpel/workflow/task", argName, asSchemaObject);
                        } else {
                            argName = asSchemaObject.getName();
                            childElement = SchemaUtils.generateXMLForXSDElement(schemaManager, asSchemaObject.getNamespace(), argName);
                        }
                        elementMap.put(argName, childElement);
                    }
                }
            }
            catch (Exception e) {
                throw new DeploymentException(78009, new Object[]{userTask.getId(), model.getName()}, (Throwable)e);
            }
        }
        return elementMap;
    }

    private MDOperationRef getOperationReference(UserTask userTask, boolean invoke) {
        String operationName = userTask.isReinitiate() ? "reinitiateTask" : "initiateTask";
        QName portType = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "TaskService");
        QName inputMessage = null;
        QName responseMessage = null;
        QName faultMessage = null;
        if (invoke) {
            inputMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "initiateTaskMessage");
            responseMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "initiateTaskResponseMessage");
            faultMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "workflowErrorMessage");
        } else {
            responseMessage = new QName("http://xmlns.oracle.com/bpel/workflow/taskService", "taskMessage");
        }
        return new MDOperationRef("payload", operationName, portType, true, inputMessage, responseMessage, null, faultMessage);
    }
}

