/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.ICubeInstance;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractEventTriggerTypeVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateNextTokensCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ThrowEvent;

public class TerminateEventVisitorImpl
extends MIAbstractEventTriggerTypeVisitor<ThrowEvent> {
    @Override
    protected MIVisitor<CompilationResult> doCompileThrow(BPMNCubeMapBuilderContext context, ThrowEvent event) throws CubeException {
        return new SimpleVisitorImpl<ThrowEvent, CompilationResult>(event, context){

            @Override
            protected GenerateNextTokensCompiler getGenerateNextTokenCompiler(MIBPMNActivityNode node) {
                return new GenerateNextTokensCompiler.GenerateNextTokensCompilerForTerminateEvent(this.getContext(), node, (ThrowEvent)this.getElement());
            }

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<ThrowEvent>((ThrowEvent)this.getElement(), delegator){

                    @Override
                    public void compile(BPMNCubeMapBuilderContext context) {
                        super.compile(context);
                        MISequenceBlock result = new MISequenceBlock();
                        result.addMicroInstruction(AuditTrailVisitorHelper.createPostAuditMI(context, this.getElement(), Tag.POST_AUDIT_NORMAL));
                        String id = context.getCubeMap().getProcessModel().getProcess().getId();
                        BPMNCubeElement e = context.getElementByTagOnTop(TagInfo.createTagInfo(id, Tag.POST_AUDIT_NORMAL));
                        result.addMicroInstruction(AuditTrailVisitorHelper.createPostAuditMI(context, e.getFlowElement(), Tag.POST_AUDIT_NORMAL));
                        this.registerMethod(result, "POST_EXECUTION");
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return new MITerminateEvent();
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MINop();
                    }
                };
            }
        };
    }

    @Override
    protected MIVisitor<CompilationResult> doCompileCatch(BPMNCubeMapBuilderContext context, CatchEvent event) throws CubeException {
        throw new UnsupportedOperationException("Terminate catch event does not exists");
    }

    private static class MITerminateEvent
    extends MIBase<Object> {
        private MITerminateEvent() {
        }

        @Override
        protected Object doExecute(MicroInstructionContext context) throws Throwable {
            context.getWorkItem().markAsComplete();
            ICubeInstance ci = context.getWorkItem().getCubeInstance();
            ci.scheduleAbort();
            return null;
        }
    }
}

