/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateNextTokensCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.StartEvent;

public abstract class SimpleVisitorImpl<T extends FlowNode, P extends CompilationResult>
implements MIVisitor<P> {
    private boolean addElementToCubeMap = true;
    private BPMNCubeMapBuilderContext context;
    private T element;

    protected SimpleVisitorImpl(T element, BPMNCubeMapBuilderContext context) {
        this.element = element;
        this.context = context;
    }

    public BPMNCubeMapBuilderContext getContext() {
        return this.context;
    }

    @Override
    public final P visit(ICubeBlock parentBlock) throws CubeException {
        String activityId = this.element.getId();
        String activityName = this.element.getDefaultLabel();
        MIBPMNActivityNode<T> node = this.createNode(this.context, activityName);
        AbstractCompiler compiler = this.getCompiler(new SimpleVisitorRegisterDelegator(node));
        compiler.compile(this.context);
        this.registerPostCompilers(this.context, node);
        parentBlock = this.context.getBlockForFlowElement(parentBlock, (FlowNode)this.element);
        if (this.addElementToCubeMap) {
            this.context.addElementToBlock(node, parentBlock);
        }
        return this.createCompilationResult(activityId, node);
    }

    public void setAddElementToCubeMap(boolean addElementToCubeMap) {
        this.addElementToCubeMap = addElementToCubeMap;
    }

    protected abstract AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator var1);

    protected T getElement() {
        return this.element;
    }

    protected MIBPMNActivityNode<T> createNode(BPMNCubeMapBuilderContext context, String activityName) {
        MIBPMNActivityNode<T> activityNode = new MIBPMNActivityNode<T>(context, activityName, this.element);
        activityNode.setCountActivityEvent();
        return activityNode;
    }

    protected void registerPostCompilers(BPMNCubeMapBuilderContext context, MIBPMNActivityNode node) {
        if (this.addElementToCubeMap) {
            context.registerPostCompiler(this.getGenerateNextTokenCompiler(node));
        }
    }

    protected GenerateNextTokensCompiler getGenerateNextTokenCompiler(MIBPMNActivityNode node) {
        Activity activity;
        GenerateNextTokensCompiler result = null;
        if (this.getElement().isEvent()) {
            Event event = (Event)this.getElement().asAnyNode(Event.class);
            if (event.isStart()) {
                if (event.getEventTriggerType() != EventTriggerType.ERROR) {
                    result = new GenerateNextTokensCompiler.GenerateNextTokensCompilerForStartEvents(this.context, node, (StartEvent)this.getElement().asAnyNode(StartEvent.class));
                }
            } else if (event.isCatchEvent()) {
                result = new GenerateNextTokensCompiler.GenerateNextTokensCompilerForCatchEvents<CatchEvent>(this.context, node, (CatchEvent)this.getElement().asAnyNode(CatchEvent.class));
            }
        } else if (this.getElement().isActivity() && (activity = (Activity)this.getElement().asAnyNode(Activity.class)).isReceiveTask()) {
            result = new GenerateNextTokensCompiler.GenerateNextTokensCompilerForReceiveTask(this.context, node, (ReceiveTask)activity.asAnyNode(ReceiveTask.class));
        }
        if (result == null) {
            result = new GenerateNextTokensCompiler(this.context, node, this.element);
        }
        return result;
    }

    protected P createCompilationResult(String activityId, MIBPMNActivityNode node) {
        return (P)new CompilationResult(activityId, node, node);
    }

    private boolean hasTo() {
        return false;
    }

    protected static class SimpleVisitorRegisterDelegator
    implements AbstractCompiler.RegisterDelegator {
        private MIBPMNActivityNode node;

        public SimpleVisitorRegisterDelegator(MIBPMNActivityNode node) {
            this.node = node;
        }

        @Override
        public void register(IMicroInstruction mi, String tag) {
            this.node.addMicroInstruction(tag, mi);
        }

        @Override
        public void tag(BPMNCubeMapBuilderContext context, TagInfo tagInfo) {
            context.tagElement(tagInfo, this.node);
        }
    }
}

