/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.InvokeMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorFactory;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.model.metadataextension.SendMessageElement;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeExpire;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReply;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.util.ConversationUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.interfaces.OperationReferenceImpl;
import oracle.bpm.project.model.processes.conversational.Conversational;
import oracle.bpm.project.model.processes.messageheaders.MessageHeader;

public class SendMessageElementVisitorHelper {
    public static MIVisitor<CompilationResult> createMIVisitor(SendMessageElement element, BPMNCubeMapBuilderContext context) throws CubeException {
        QName inputType;
        String operationName;
        String serviceName = ConversationUtils.getServiceName(element, context);
        final boolean isReply = SendMessageElementVisitorHelper.isReply(context, element);
        Object[] inputHeaderVariableNames = new String[]{};
        Sequence inputMessageHeaderSequence = element.getInputMessageHeaderSet().getMessageHeaders();
        if (!inputMessageHeaderSequence.isEmpty()) {
            inputHeaderVariableNames = new String[inputMessageHeaderSequence.toArray().length];
            inputMessageHeaderSequence.map((Function)new Function<MessageHeader, String>(){

                public String eval(MessageHeader value) {
                    return value.getName();
                }
            }).toArray(inputHeaderVariableNames);
        }
        MDReply mdReplyAux = null;
        MDServiceTask mdServiceAux = null;
        MDOperationRef mdOperationRef = ConversationUtils.createMDOperationRef(context, element, element.getInputDataAssociationSet(), null);
        if (isReply) {
            mdReplyAux = new MDReply(element.getDefaultLabel() + "_" + element.getId() + "_in", mdOperationRef, element.getInputDataAssociationSet(), element.getInputArgumentsContainer(), serviceName, element, element.getInputServiceProperties(), element.getInputCorrelationsContainer(), (String[])inputHeaderVariableNames);
            operationName = mdReplyAux.getOperationRefName();
            inputType = mdReplyAux.getInputType();
        } else {
            mdServiceAux = new MDServiceTask(element.getDefaultLabel() + "_" + element.getId() + "_in", null, null, element.getInputDataAssociationSet(), null, element.getInputArgumentsContainer(), mdOperationRef, serviceName, null, null, element, element.getInputServiceProperties(), null, element.getInputCorrelationsContainer(), null, (String[])inputHeaderVariableNames, null, true);
            operationName = mdServiceAux.getOperationRefName();
            inputType = mdServiceAux.getInputType();
        }
        DataHandlingUtils.handleIoSpecificationImports(element.getInputDataAssociationSet(), context);
        ModelVisitorUtil.addCorrelations(context, serviceName, operationName, inputType, element.getInputCorrelationsContainer());
        final MDReply mdReply = mdReplyAux;
        final MDServiceTask mdService = mdServiceAux;
        return new SimpleVisitorImpl<SendMessageElement, CompilationResult>(element, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<SendMessageElement>((SendMessageElement)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        if (isReply) {
                            return ServiceActivitiesGeneratorFactory.createReplyToGenerator(mdReply).createReplyMI();
                        }
                        return ServiceActivitiesGeneratorFactory.createServiceTaskGenerator(mdService).createInvokeMI();
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        if (isReply) {
                            return new MINop();
                        }
                        InvokeMessageActivityGenerator generator = ServiceActivitiesGeneratorFactory.createServiceTaskGenerator(mdService);
                        return generator.createInvokeMI(new MIInvokeCallback(mdService));
                    }

                    @Override
                    protected IMicroInstruction getDoExpire() {
                        if (isReply) {
                            return new MINop();
                        }
                        InvokeMessageActivityGenerator generator = ServiceActivitiesGeneratorFactory.createServiceTaskGenerator(mdService);
                        return generator.createInvokeMI(new MIInvokeExpire(mdService));
                    }
                };
            }
        };
    }

    private static boolean isReply(BPMNCubeMapBuilderContext context, SendMessageElement element) {
        boolean isReply;
        if (element.getConversation().getConversationType().isOutbound()) {
            isReply = false;
        } else {
            OperationReferenceImpl operationReference = new OperationReferenceImpl((Conversational)element, context.getCubeMap().getProcessModel());
            isReply = operationReference.hasReplyTo();
        }
        return isReply;
    }
}

