/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.engine.ICubeContext;
import com.collaxa.cube.engine.core.IScope;
import com.collaxa.cube.engine.core.IWorkItem;
import com.collaxa.cube.xml.xpath.XPathException;
import com.oracle.bpel.client.BPELFault;
import java.util.Collections;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MIBase;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.MicroInstructionContext;
import oracle.bpm.bpmn.engine.model.metadataextension.ScriptTaskElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIScriptTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDScriptTask;
import oracle.bpm.bpmn.engine.model.runtime.util.BPMRuntimeLogger;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;

public class ScriptTaskVisitorHelper {
    public static final CompilationResultFactory ACTIVITY_COMPILATION_RESULT_FACTORY = new AbstractCompilationResultFactory(){

        @Override
        public CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
            return new CompilationResult(activityId, node, node);
        }

        @Override
        public IMicroInstruction<Object> getDoExecuteStatement(ScriptTaskElement element, boolean compileScript) {
            return this.getExecutionMI(element, compileScript);
        }

        @Override
        public IMicroInstruction<Object> getDoHandleCallback(ScriptTaskElement element, boolean compileScript) {
            return new MINop();
        }
    };
    public static final CompilationResultFactory BOUNDARY_EVENT_COMPILATION_RESULT_FACTORY = new AbstractCompilationResultFactory(){

        @Override
        public CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
            return EventCompilationResult.create(activityId, node, node, false, null);
        }

        @Override
        public IMicroInstruction<Object> getDoExecuteStatement(ScriptTaskElement element, boolean compileScript) {
            return new MIMarkAsComplete();
        }

        @Override
        public IMicroInstruction<Object> getDoHandleCallback(ScriptTaskElement element, boolean compileScript) {
            return this.getExecutionMI(element, compileScript);
        }
    };

    public static MIVisitor<CompilationResult> createScriptTaskMIVisitor(ScriptTaskElement scriptTask, BPMNCubeMapBuilderContext context, final boolean compileScript, final CompilationResultFactory factory) {
        return new SimpleVisitorImpl<ScriptTaskElement, CompilationResult>(scriptTask, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<ScriptTaskElement>((ScriptTaskElement)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return factory.getDoExecuteStatement((ScriptTaskElement)this.getElement(), compileScript);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return factory.getDoHandleCallback((ScriptTaskElement)this.getElement(), compileScript);
                    }
                };
            }

            @Override
            protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                return factory.createCompilationResult(activityId, node);
            }
        };
    }

    private static class MIProcessOutputDataAssociation
    extends MIBase<Object> {
        protected DataAssociationSet dataAssociationSet;

        public MIProcessOutputDataAssociation(DataAssociationSet dataAssociationSet) {
            this.dataAssociationSet = dataAssociationSet;
        }

        @Override
        protected Object doExecute(MicroInstructionContext miContext) throws Throwable {
            IWorkItem wi = miContext.getWorkItem();
            ICubeContext ctx = miContext.getCubeContext();
            IScope sc = wi.getScope();
            try {
                DataHandlingUtils.processOutputData(miContext.getNode().getFlowElement(), this.dataAssociationSet, sc, ctx, Collections.<String, Object>emptyMap(), wi);
            }
            catch (BPELFault e) {
                DataHandlingUtils.trapBPELFaults(miContext, e);
            }
            catch (XPathException e) {
                DataHandlingUtils.trapXPathQueryFailed(miContext, e);
            }
            return null;
        }
    }

    private static abstract class AbstractCompilationResultFactory
    implements CompilationResultFactory {
        private AbstractCompilationResultFactory() {
        }

        protected final IMicroInstruction<Object> getExecutionMI(ScriptTaskElement element, boolean compileScript) {
            MDScriptTask mdScriptTask = new MDScriptTask(element.getScript(), element.getLanguage(), element.getProcess());
            MISequenceBlock block = new MISequenceBlock();
            DataAssociationSet outputDataAssociationSet = element.getOutputDataAssociationSet();
            if (outputDataAssociationSet != null && !outputDataAssociationSet.getDataAssociations().isEmpty()) {
                block.addMicroInstruction(new MIProcessOutputDataAssociation(outputDataAssociationSet));
            }
            if (BPMRuntimeLogger.isRuntimeTestEnabled() && compileScript) {
                block.addMicroInstruction(new MIScriptTask(mdScriptTask));
            } else {
                block.addMicroInstruction(new MIMarkAsComplete());
            }
            return block;
        }
    }

    public static interface CompilationResultFactory {
        public CompilationResult createCompilationResult(String var1, MIBPMNActivityNode var2);

        public IMicroInstruction<Object> getDoExecuteStatement(ScriptTaskElement var1, boolean var2);

        public IMicroInstruction<Object> getDoHandleCallback(ScriptTaskElement var1, boolean var2);
    }
}

