/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.InitiationInfo;
import com.collaxa.cube.engine.deployment.DeploymentException;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ReceiveMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorFactory;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.metadataextension.ReceiveMessageElement;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIReceiveCancel;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.bpmn.engine.model.runtime.util.ConversationUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.messageheaders.MessageHeader;

public class ReceiveMessageElementVisitorHelper {
    public static MIVisitor<CompilationResult> createMIVisitor(ReceiveMessageElement element, BPMNCubeMapBuilderContext context) throws CubeException {
        final boolean isCreateInstance = context.isCompilingInstantiateBlock() == null ? element.isInstantiate() : context.isCompilingInstantiateBlock().booleanValue();
        final MDReceive mdReceive = ReceiveMessageElementVisitorHelper.createMDReceive(element, context);
        String serviceName = mdReceive.getServiceName();
        DataHandlingUtils.handleIoSpecificationImports(element.getOutputDataAssociationSet(), context);
        if (isCreateInstance) {
            ReceiveMessageElementVisitorHelper.addActivityAsInitiationInfo(mdReceive.getOperationRefName(), context, serviceName);
        }
        ModelVisitorUtil.addCorrelations(context, serviceName, mdReceive.getOperationRefName(), mdReceive.getInputType(), element.getOutputCorrelationsContainer());
        return new SimpleVisitorImpl<ReceiveMessageElement, CompilationResult>(element, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<ReceiveMessageElement>((ReceiveMessageElement)this.getElement(), delegator){
                    final ReceiveMessageActivityGenerator generator;
                    {
                        this.generator = ServiceActivitiesGeneratorFactory.createReceiveTaskGenerator(mdReceive);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        if (isCreateInstance) {
                            return this.generator.createEntryReceiveMI();
                        }
                        return this.generator.createReceiveMI();
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        if (isCreateInstance) {
                            return new MIAssertFalse();
                        }
                        return this.generator.createReceiveTaskCallbackMI();
                    }

                    @Override
                    protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
                        MIReceiveCancel mi = new MIReceiveCancel();
                        mi.addMicroInstruction(super.generateCancelPerformMethod(context));
                        return mi;
                    }

                    @Override
                    protected IMicroInstruction generateThrowExceptionMethod() {
                        return new MIReceiveCancel();
                    }
                };
            }

            @Override
            protected CompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                if (((ReceiveMessageElement)this.getElement()).isEvent()) {
                    return EventCompilationResult.create(activityId, node, node, false, null);
                }
                return super.createCompilationResult(activityId, node);
            }
        };
    }

    public static MDReceive createMDReceive(ReceiveMessageElement element, BPMNCubeMapBuilderContext context) throws DeploymentException {
        String inputVariable = element.getDefaultLabel() + "_" + element.getId() + "_in";
        String serviceName = ConversationUtils.getServiceName(element, context);
        Sequence outputMessageHeaderSequence = element.getOutputMessageHeaderSet().getMessageHeaders();
        Object[] inputHeaderVariableNames = null;
        if (!outputMessageHeaderSequence.isEmpty()) {
            Object[] outputHeaderVariableNames = new String[outputMessageHeaderSequence.toArray().length];
            outputMessageHeaderSequence.map((Function)new Function<MessageHeader, String>(){

                public String eval(MessageHeader value) {
                    return value.getName();
                }
            }).toArray(outputHeaderVariableNames);
            inputHeaderVariableNames = outputHeaderVariableNames;
        }
        MDReceive mdReceive = new MDReceive(inputVariable, ConversationUtils.createMDOperationRef(context, element, null, element.getOutputDataAssociationSet()), element.getOutputDataAssociationSet(), element.getOutputArgumentsContainer(), serviceName, null, null, element, element.getOutputServicePropertySet(), element.getOutputCorrelationsContainer(), element.isEventHandler(), element.isEventInterrupting(), (String[])inputHeaderVariableNames);
        return mdReceive;
    }

    private static void addActivityAsInitiationInfo(String operationName, BPMNCubeMapBuilderContext context, String partnerLinkName) {
        System.out.println("Adding initiate info for " + operationName + " partnerLinkName " + partnerLinkName);
        InitiationInfo initiationInfo = new InitiationInfo(operationName, partnerLinkName, null, null);
        context.addInitiationInfo(initiationInfo);
    }
}

