/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractEventTriggerTypeVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ReceiveMessageElementVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SignalEventVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateNextTokensCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ReceiveMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ReceiveSignalActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorFactory;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.metadataextension.CatchEventAdapter;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInsertInstance2Track;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDReceive;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.ThrowEvent;

public abstract class MIAbstractEventTriggerTypeVisitor<T extends Event>
extends AbstractEventTriggerTypeVisitor<T> {
    protected abstract MIVisitor<CompilationResult> doCompileCatch(BPMNCubeMapBuilderContext var1, CatchEvent var2) throws CubeException;

    protected abstract MIVisitor<CompilationResult> doCompileThrow(BPMNCubeMapBuilderContext var1, ThrowEvent var2) throws CubeException;

    protected final MIVisitor<CompilationResult> createMIVisitor(T element, BPMNCubeMapBuilderContext context) throws CubeException {
        MIVisitor<CompilationResult> result;
        if (element.isCatchEvent()) {
            result = this.compileCatch(context, element.asCatchEvent());
        } else if (element.isThrowEvent()) {
            result = this.compileThrow(context, element.asThrowEvent());
        } else {
            throw new UnsupportedOperationException("MIAbstractEventTriggerTypeVisitor.visitEvent->" + element.getBpmnType());
        }
        return result;
    }

    protected final MIVisitor<CompilationResult> compileCatch(BPMNCubeMapBuilderContext context, CatchEvent event) throws CubeException {
        EventHandlerVisitorImpl visitor = null;
        if (ModelVisitorUtil.isStartOfInlineEventHandler(event) && event.getEventTriggerType() != EventTriggerType.ERROR) {
            MIVisitor<CompilationResult> visitor1 = this.doCompileCatch(context, event);
            visitor = new EventHandlerVisitorImpl(event, context, visitor1);
        } else {
            visitor = this.doCompileCatch(context, event);
        }
        return visitor;
    }

    protected final MIVisitor<CompilationResult> compileThrow(BPMNCubeMapBuilderContext context, ThrowEvent event) throws CubeException {
        return this.doCompileThrow(context, event);
    }

    @Override
    protected EventCompilationResult visitEventImpl(T event, BPMNCubeMapBuilderContext context, ICubeBlock parentBlock) throws CubeException {
        CompilationResult result = this.createMIVisitor(event, context).visit(parentBlock);
        if (!(result instanceof EventCompilationResult)) {
            result = EventCompilationResult.create(result);
        }
        return (EventCompilationResult)result;
    }

    private static class EventHandlerVisitorImpl
    implements MIVisitor<CompilationResult> {
        private BPMNCubeMapBuilderContext context;
        private CatchEvent element;
        private MIVisitor<CompilationResult> visitor1;
        private MIVisitor<CompilationResult> visitor2;

        public EventHandlerVisitorImpl(CatchEvent element, BPMNCubeMapBuilderContext context, MIVisitor<CompilationResult> visitor) throws CubeException {
            this.element = element;
            this.context = context;
            this.visitor1 = visitor;
            MDReceive mdReceiveAux = null;
            if (element.getEventTriggerType() == EventTriggerType.SIGNAL) {
                mdReceiveAux = SignalEventVisitorHelper.createMDReceive(element);
            } else if (element.getEventTriggerType() == EventTriggerType.MESSAGE) {
                mdReceiveAux = ReceiveMessageElementVisitorHelper.createMDReceive(new CatchEventAdapter(element), context);
            }
            final MDReceive mdReceive = mdReceiveAux;
            this.visitor2 = new SimpleVisitorImpl<CatchEvent, CompilationResult>(element, context){

                @Override
                protected MIBPMNActivityNode<CatchEvent> createNode(BPMNCubeMapBuilderContext context, String activityName) {
                    return new MIBPMNActivityNode<CatchEvent>(context, "postEvent", activityName, ((CatchEvent)this.getElement()).getBpmnType(), (CatchEvent)this.getElement());
                }

                @Override
                protected GenerateNextTokensCompiler getGenerateNextTokenCompiler(MIBPMNActivityNode node) {
                    return new GenerateNextTokensCompiler(this.getContext(), node, this.getElement());
                }

                @Override
                protected AbstractCompiler getCompiler(final AbstractCompiler.RegisterDelegator delegator) {
                    return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<CatchEvent>((CatchEvent)this.getElement(), delegator){

                        @Override
                        protected IMicroInstruction<Object> getDoExecuteStatement() {
                            MISequenceBlock block = new MISequenceBlock();
                            block.addMicroInstruction(new MIMarkAsComplete());
                            if (((CatchEvent)this.getElement()).getEventTriggerType() == EventTriggerType.SIGNAL) {
                                ReceiveSignalActivityGenerator generator = ServiceActivitiesGeneratorFactory.createReceiveSignalGenerator(mdReceive);
                                generator.addProcessOutputMIPart2(block, mdReceive, mdReceive, false);
                            } else if (((CatchEvent)this.getElement()).getEventTriggerType() == EventTriggerType.MESSAGE) {
                                ReceiveMessageActivityGenerator generator = ServiceActivitiesGeneratorFactory.createReceiveTaskGenerator(mdReceive);
                                generator.addProcessOutputMIPart2(block, mdReceive, mdReceive, false);
                            }
                            AuditTrailVisitorHelper.createAndAddPreAuditMI(this.getContext(), this.getElement(), delegator, block);
                            AuditTrailVisitorHelper.createAndAddPostAuditMI(this.getContext(), this.getElement(), delegator, block);
                            block.addMicroInstruction(new MIInsertInstance2Track(false));
                            return block;
                        }

                        @Override
                        protected IMicroInstruction<Object> getDoHandleCallback() {
                            return new MIAssertFalse();
                        }
                    };
                }

                @Override
                protected EventCompilationResult createCompilationResult(String activityId, MIBPMNActivityNode node) {
                    return EventCompilationResult.create(node);
                }
            };
        }

        @Override
        public EventCompilationResult visit(ICubeBlock parentBlock) throws CubeException {
            BPMNCubeElement tryBlock = this.context.getElementByTag(TagInfo.createTagInfo(this.element.getParentObject().getParentObject().getId(), Tag.TRY_BLOCK));
            ICubeBlock parentBlockForNode1 = tryBlock == null ? parentBlock.getParentBlock() : (ICubeBlock)tryBlock;
            CompilationResult result1 = this.visitor1.visit(parentBlockForNode1);
            CompilationResult result2 = this.visitor2.visit(parentBlock);
            result1.getEntryPoint().setStartOfMainFlow(false);
            this.context.link(result1.getExitPoint(), (BPMNCubeElement)parentBlock);
            return EventCompilationResult.create(result1.getActivityId(), result1.getEntryPoint(), result2.getExitPoint(), false, null);
        }
    }
}

