/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.DummyBlock;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.SequenceFlow;

public class EventsVisitorHelper {
    protected static <T extends Activity> CompilationResult visitElement(T element, BPMNCubeMapBuilderContext context, EventsDelegatedVisitor<T> eventsDelegatedVisitor, BPMNFlowElementVisitor<T> delegatedVisitor, boolean visitBoundaryEvents) throws CubeException {
        String activityId = element.getId();
        String activityName = element.getName();
        Sequence boundaryEvents = null;
        if (visitBoundaryEvents || element.getLoopCharacteristicsType() == LoopCharacteristicsType.NONE) {
            boundaryEvents = element.getActivityBoundaryEvents();
        }
        if (boundaryEvents == null) {
            boundaryEvents = CollectionUtils.emptySequence();
        }
        DummyBlock dummyBlock = null;
        TryBlock tryBlock = null;
        BaseBPMNActivityBlock previous = context.getCurrentBlock();
        if (!boundaryEvents.isEmpty()) {
            dummyBlock = BlockFactory.createDummyBlock(context, activityName, element);
            context.addElementToBlock(dummyBlock, (ICubeBlock)previous);
            context.setCurrentBlock(dummyBlock);
            if (EventsVisitorHelper.hasFaultHandler((Iterable<BoundaryEvent>)boundaryEvents)) {
                tryBlock = BlockFactory.createTryBlock(context, activityName, element);
                context.addElementToBlock(tryBlock, (ICubeBlock)dummyBlock);
                context.setCurrentBlock(tryBlock);
            }
        }
        CompilationResult activityCompilationResult = eventsDelegatedVisitor.doVisit(element, context, (ICubeBlock)context.getCurrentBlock(), delegatedVisitor);
        if (!boundaryEvents.isEmpty()) {
            context.setCurrentBlock(dummyBlock);
            List<EventCompilationResult> eventCompilationResult = EventsVisitorHelper.compileEvents((Iterable<BoundaryEvent>)boundaryEvents, context);
            EventsVisitorHelper.processEventCompilationResult(context, dummyBlock, tryBlock, eventCompilationResult, activityCompilationResult);
        }
        context.setCurrentBlock(previous);
        if (dummyBlock != null) {
            return new CompilationResult(activityId, dummyBlock, dummyBlock);
        }
        return activityCompilationResult;
    }

    private static void processEventCompilationResult(BPMNCubeMapBuilderContext context, BaseBPMNActivityBlock dummyBlock, TryBlock tryBlock, List<EventCompilationResult> eventCompilationResult, CompilationResult activityCompilationResult) {
        ArrayList<FaultHandler> faultHandlers = new ArrayList<FaultHandler>();
        FaultHandler defaultHandler = null;
        for (EventCompilationResult result : eventCompilationResult) {
            if (result.isErrorHandler()) {
                if (result.getErrorHandlingPolicy().isCatchAll()) {
                    defaultHandler = result.createFaultHandler();
                    continue;
                }
                faultHandlers.add(result.createFaultHandler());
                continue;
            }
            dummyBlock.getSequenceFlowMetadata().addEntryElement(result.getEntryPoint());
        }
        if (tryBlock != null) {
            tryBlock.getSequenceFlowMetadata().addEntryElement(activityCompilationResult.getEntryPoint());
            tryBlock.setFaultHandlers(new ModelVisitorUtil.FaultHandlersImpl(faultHandlers, defaultHandler));
            dummyBlock.getSequenceFlowMetadata().addEntryElement(tryBlock);
        } else {
            dummyBlock.getSequenceFlowMetadata().addEntryElement(activityCompilationResult.getEntryPoint());
        }
    }

    private static List<EventCompilationResult> compileEvents(Iterable<BoundaryEvent> boundaryEvents, BPMNCubeMapBuilderContext context) throws CubeException {
        ArrayList<EventCompilationResult> result = new ArrayList<EventCompilationResult>();
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            EventCompilationResult compilationResult = (EventCompilationResult)ModelVisitorUtil.visit(boundaryEvent, context);
            result.add(compilationResult);
            if (boundaryEvent.cancelActivity()) continue;
            EventsVisitorHelper.compileBoundaryFlow(context, (FlowNode)boundaryEvent, new HashSet<String>());
        }
        return result;
    }

    private static void compileBoundaryFlow(BPMNCubeMapBuilderContext context, FlowNode node, Set<String> visitedNodes) throws CubeException {
        for (SequenceFlow sequenceFlow : node.getOutgoingSequenceFlows()) {
            FlowNode target = sequenceFlow.getTarget();
            if (!visitedNodes.contains(target.getId())) {
                CompilationResult result = ModelVisitorUtil.visit(target, context);
                visitedNodes.add(target.getId());
                if (target.getOutgoingSequenceFlows().isEmpty()) {
                    BPMNCubeElement exitNode = result.getExitPoint();
                    exitNode.setNonMainFlowEndElement(true);
                }
                for (FlowNode f : ModelVisitorUtil.getNextTargets(target)) {
                    EventsVisitorHelper.compileBoundaryFlow(context, f, visitedNodes);
                }
            }
            ModelVisitorUtil.visit(sequenceFlow, context);
        }
    }

    private static boolean hasFaultHandler(Iterable<BoundaryEvent> boundaryEvents) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getEventTriggerType() != EventTriggerType.ERROR) continue;
            return true;
        }
        return false;
    }

    protected static interface EventsDelegatedVisitor<T extends Activity> {
        public CompilationResult doVisit(T var1, BPMNCubeMapBuilderContext var2, ICubeBlock var3, BPMNFlowElementVisitor<T> var4) throws CubeException;
    }
}

