/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CatchAllErrorHandlingPolicy;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.bpmn.engine.model.common.FaultHandlerImpl;
import oracle.bpm.project.interfaces.ProcessUtil;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.ErrorObject;
import oracle.bpm.project.model.processes.ErrorEventDefinition;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;

public class EventCompilationResult
extends CompilationResult {
    private CatchAllErrorHandlingPolicy catchAllErrorHandlingPolicy;
    private Set<QName> faultHandlerErrorCodes;
    private String faultHanlderId;
    private boolean isErrorHandler;

    private EventCompilationResult(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint) {
        super(activityId, entryPoint, exitPoint);
    }

    private EventCompilationResult(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, CatchAllErrorHandlingPolicy catchAllErrorHandlingPolicy, String faultHandlerId, Set<QName> faultHandlerErrorCodes) {
        super(activityId, entryPoint, exitPoint);
        this.setErrorHandler(isErrorHandler);
        this.setCatchAllErrorHandlingPolicy(catchAllErrorHandlingPolicy);
        this.faultHanlderId = faultHandlerId;
        this.faultHandlerErrorCodes = faultHandlerErrorCodes;
    }

    public static EventCompilationResult create(BPMNCubeElement node) {
        return EventCompilationResult.create(node, null);
    }

    public static EventCompilationResult create(BPMNCubeElement node, String handlerId) {
        Object element = node.getFlowElement();
        Event event = (Event)element.asAnyNode(Event.class);
        if (event != null) {
            if (event.getEventTriggerType() == EventTriggerType.ERROR) {
                CatchAllErrorHandlingPolicy handlingPolicyCatchAll;
                assert (event.getEventDefinition() != null);
                ErrorEventDefinition eventDefinition = (ErrorEventDefinition)event.getEventDefinition().as(ErrorEventDefinition.class);
                ErrorObject errorObject = eventDefinition.getError();
                Set<QName> errorCodes = null;
                if (errorObject != null) {
                    errorCodes = ProcessUtil.getProjectErrorQNames((Project)element.getProject()).getErrorQNames(errorObject);
                    handlingPolicyCatchAll = new CatchAllErrorHandlingPolicy(false, false);
                } else {
                    handlingPolicyCatchAll = new CatchAllErrorHandlingPolicy(eventDefinition.isCatchAll(), eventDefinition.isCatchAllSystemExceptions());
                }
                if (errorCodes == null) {
                    errorCodes = Collections.emptySet();
                }
                return EventCompilationResult.create(event.getId(), node, node, true, handlingPolicyCatchAll, handlerId, errorCodes);
            }
            return EventCompilationResult.create(event.getId(), node, node, false, null);
        }
        return null;
    }

    public static EventCompilationResult create(CompilationResult compilationResult, boolean isErrorHandler, CatchAllErrorHandlingPolicy catchAllErrorHandlingPolicy) {
        EventCompilationResult result = new EventCompilationResult(compilationResult.getActivityId(), compilationResult.getEntryPoint(), compilationResult.getExitPoint());
        result.setErrorHandler(isErrorHandler);
        result.setCatchAllErrorHandlingPolicy(catchAllErrorHandlingPolicy);
        return result;
    }

    public static EventCompilationResult create(CompilationResult compilationResult) {
        return EventCompilationResult.create(compilationResult, false, null);
    }

    public static EventCompilationResult create(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, CatchAllErrorHandlingPolicy catchAllErrorHandlingPolicy) {
        return EventCompilationResult.create(activityId, entryPoint, exitPoint, isErrorHandler, catchAllErrorHandlingPolicy, null, null);
    }

    public static EventCompilationResult create(String activityId, BPMNCubeElement entryPoint, BPMNCubeElement exitPoint, boolean isErrorHandler, CatchAllErrorHandlingPolicy catchAllErrorHandlingPolicy, String faultHandlerId, Set<QName> faultHandlerErrorCodes) {
        return new EventCompilationResult(activityId, entryPoint, exitPoint, isErrorHandler, catchAllErrorHandlingPolicy, faultHandlerId, faultHandlerErrorCodes);
    }

    public boolean isErrorHandler() {
        return this.isErrorHandler;
    }

    public void setErrorHandler(boolean errorHandler) {
        this.isErrorHandler = errorHandler;
    }

    public FaultHandler createFaultHandler() {
        String id = this.faultHanlderId;
        if (id == null) {
            id = this.getEntryPoint().getId();
        }
        return new FaultHandlerImpl(id, this.getErrorHandlingPolicy(), this.faultHandlerErrorCodes);
    }

    public CatchAllErrorHandlingPolicy getErrorHandlingPolicy() {
        return this.catchAllErrorHandlingPolicy;
    }

    public void setCatchAllErrorHandlingPolicy(CatchAllErrorHandlingPolicy catchAllErrorHandlingPolicy) {
        this.catchAllErrorHandlingPolicy = catchAllErrorHandlingPolicy;
    }
}

