/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNGatewayVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.EventBasedGatewayBlock;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;

public class EventBasedGatewayVisitorImpl
extends AbstractBPMNGatewayVisitor<EventBasedGateway> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationResult visitGateway(EventBasedGateway gateway, BPMNCubeMapBuilderContext context) throws CubeException {
        String activityId = gateway.getId();
        String activityName = gateway.getName();
        EventBasedGatewayBlock<EventBasedGateway> eventBasedGatewayBlock = BlockFactory.createEventBasedGatewayBlock(context, activityName, gateway);
        ICubeBlock blockToInsert = context.getBlockForFlowElement((ICubeBlock)context.getCurrentBlock(), (FlowNode)gateway);
        context.addElementToBlock(eventBasedGatewayBlock, blockToInsert);
        BaseBPMNActivityBlock oldCurrentBlock = context.getCurrentBlock();
        context.setCurrentBlock(eventBasedGatewayBlock);
        context.setCompilingInstantiateBlock(gateway.isInstantiate());
        try {
            for (SequenceFlow sequenceFlow : gateway.getOutgoingSequenceFlows()) {
                FlowNode target = sequenceFlow.getTarget();
                CompilationResult result = ModelVisitorUtil.visit(target, context);
                eventBasedGatewayBlock.getSequenceFlowMetadata().addEntryElement(result.getEntryPoint());
            }
        }
        finally {
            context.unsetCompilingInstantiateBlock();
            context.setCurrentBlock(oldCurrentBlock);
        }
        return new CompilationResult(activityId, eventBasedGatewayBlock, eventBasedGatewayBlock);
    }

    @Override
    protected boolean createAuditLogNodes(EventBasedGateway element) {
        return false;
    }
}

