/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentException;
import com.collaxa.cube.xml.xsd.SchemaToXML;
import com.collaxa.cube.xml.xsd.XPathQueryInfo;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ComponentPropertiesHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIAbstractBPMNActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MIVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.InvokeMessageActivityGenerator;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.ServiceActivitiesGeneratorFactory;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MDVariableDeclaration;
import oracle.bpm.bpmn.engine.microkernel.MIIfBlock;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.microkernel.ServiceActivitiesMIHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIBusinessRuleTaskRequest;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIBusinessRuleTaskResponse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInitializeMessageVariable;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvoke;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeCallback;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIInvokeExpire;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIIsNotWorkItemFaulted;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDOperationRef;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDServiceTask;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.resolver.MDServiceTaskBuilder;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.bpmn.engine.model.runtime.util.ServiceInteractionUtils;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.fabric.common.wsdl.SchemaManager;
import oracle.fabric.common.xml.xpath.SimpleNamespaceContext;
import oracle.fabric.composite.model.ComponentModel;
import oracle.fabric.composite.model.WireModel;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;

public class BusinessRuleTaskVisitorImpl
extends MIAbstractBPMNActivityVisitor<BusinessRuleTask> {
    private static final String INPUT_STATELESS_ELEMENT_NAME = "callFunctionStateless";
    private static final String NAME_ATTRIBUTE = "name";

    @Override
    protected MIVisitor<CompilationResult> createMIVisitor(BusinessRuleTask businessRuleTask, BPMNCubeMapBuilderContext context) throws CubeException {
        String referenceName = ServiceInteractionUtils.obtainReferenceName(businessRuleTask);
        final ComponentModel model = context.getComponentModel();
        String targetNameSpaceAux = null;
        String serviceNameAux = null;
        if (model != null) {
            String sourceWire = model.getName() + "/" + referenceName;
            WireModel wireModel = model.getComposite().getWire(sourceWire);
            if (wireModel == null) {
                Object[] obj = new Object[]{businessRuleTask.getLabel(Locale.getDefault()) + "[" + businessRuleTask.getId() + "]", sourceWire};
                throw new DeploymentException(78000, obj);
            }
            serviceNameAux = wireModel.getTargetService();
            targetNameSpaceAux = "http://xmlns.oracle.com/" + wireModel.getTarget() + "/" + serviceNameAux;
        }
        final String targetNameSpace = targetNameSpaceAux;
        final String serviceName = serviceNameAux;
        context.addExtraServiceLinkDeclaration(referenceName);
        DataHandlingUtils.handleIoSpecificationImports(businessRuleTask.getInputDataAssociationSet(), context);
        ComponentPropertiesHelper.nonBlockingInvoke((Activity)businessRuleTask, referenceName, context);
        String inputVariable = businessRuleTask.getDefaultLabel() + "_" + businessRuleTask.getId() + "_in";
        String outputVariable = businessRuleTask.getDefaultLabel() + "_" + businessRuleTask.getId() + "_out";
        MDOperationRef mdOperationRef = this.getOperationReference(targetNameSpace);
        MDServiceTaskBuilder mDServiceTaskBuilder = new MDServiceTaskBuilder(inputVariable, outputVariable, businessRuleTask.getOutputDataAssociationSet(), businessRuleTask.getInputDataAssociationSet(), businessRuleTask.getOutputArgumentsContainer(), businessRuleTask.getInputArgumentsContainer(), mdOperationRef, referenceName, null, null, (FlowNode)businessRuleTask, null, null);
        final MDServiceTask mdServiceTask = mDServiceTaskBuilder.build();
        return new SimpleVisitorImpl<BusinessRuleTask, CompilationResult>(businessRuleTask, context){

            @Override
            public AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractBPMNElementVisitor.FlowNodeAbstractCompiler<BusinessRuleTask>((BusinessRuleTask)this.getElement(), delegator){
                    final InvokeMessageActivityGenerator generator;
                    {
                        this.generator = ServiceActivitiesGeneratorFactory.createServiceTaskGenerator(mdServiceTask);
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        MDVariableDeclaration mdInputVarDeclaration = ServiceActivitiesMIHelper.createMDInputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MDVariableDeclaration mdOutputVarDeclaration = ServiceActivitiesMIHelper.createMDOutputVariableDeclaration(mdServiceTask, mdServiceTask);
                        MISequenceBlock result = new MISequenceBlock();
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdInputVarDeclaration));
                        result.addMicroInstruction(new MIInitializeMessageVariable(mdOutputVarDeclaration));
                        result.addMicroInstruction(new MIBusinessRuleTaskRequest(mdServiceTask, targetNameSpace, serviceName, BusinessRuleTaskVisitorImpl.this.getInputElement(model, targetNameSpace)));
                        result.addMicroInstruction(new MIInvoke(mdServiceTask));
                        MIIfBlock processTaskResponse = new MIIfBlock(new MIIsNotWorkItemFaulted(), new MIBusinessRuleTaskResponse(mdServiceTask, targetNameSpace));
                        result.addMicroInstruction(processTaskResponse);
                        return result;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return this.generator.createInvokeMI(new MIInvokeCallback(mdServiceTask));
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoExpire() {
                        return this.generator.createInvokeMI(new MIInvokeExpire(mdServiceTask));
                    }
                };
            }
        };
    }

    private Element getInputElement(ComponentModel model, String targetNameSpace) {
        XMLElement inputElement = null;
        if (model != null) {
            try {
                SchemaManager manager = model.getComposite().getWSDLManager().getSchemaManager();
                String operationName = INPUT_STATELESS_ELEMENT_NAME;
                XMLSchema schema = manager.lookupSchema(targetNameSpace);
                XSDElement xsdElement = schema.getElement(targetNameSpace, operationName);
                SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
                namespaceContext.addNamespace("rl", targetNameSpace);
                ArrayList<XPathQueryInfo> xInfos = new ArrayList<XPathQueryInfo>();
                XPathQueryInfo info = new XPathQueryInfo("/rl:" + operationName + "/@" + NAME_ATTRIBUTE, 1);
                xInfos.add(info);
                inputElement = SchemaToXML.generateXMLElement(null, (QName)xsdElement.getQName(), xInfos, (boolean)true, (boolean)false, (NamespaceContext)namespaceContext, (SchemaManager)manager);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return inputElement;
    }

    private MDOperationRef getOperationReference(String namespace) {
        QName portType = new QName(namespace, "IDecisionService");
        QName inputMessage = new QName(namespace, "callFunctionStatelessMessage");
        QName responseMessage = new QName(namespace, "callFunctionStatelessDecisionMessage");
        QName faultMessage = new QName(namespace, "decisionServiceError");
        MDOperationRef operationRef = new MDOperationRef("payload", INPUT_STATELESS_ELEMENT_NAME, portType, true, inputMessage, responseMessage, null, faultMessage);
        return operationRef;
    }
}

