/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.EventTriggerTypeVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ActivityCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BPMNDraftActivityVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BPMNDraftEventTriggerTypeVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BoundaryEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BusinessRuleTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CallActivityVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CatchIntermediateEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ComplexGatewayVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CounterVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EndEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ErrorEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventBasedGatewayVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ExclusiveGatewayVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.InclusiveGatewayVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.LoopCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ManualTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MeasurementVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MessageEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.MultiInstanceCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.NoneEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.NotificationTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ParallelGatewayVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ReceiveTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ScriptTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SendTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SequenceFlowVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ServiceTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SignalEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.StartEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SubProcessVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.TerminateEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ThrowIntermediateEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.TimerEventVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.UpdateTaskVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.UserTaskVisitorImpl;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Draftable;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.SequenceFlow;

public class BPMNFlowElementRegistry {
    private static final String SEQUENCE_FLOW = "SEQUENCE_FLOW";
    private static final String MEASUREMENT = "MEASUREMENT";
    private static final Map<Object, BPMNFlowElementVisitor> visitors = new HashMap<Object, BPMNFlowElementVisitor>();
    private static final Map<LoopCharacteristicsType, ActivityCharacteristicsVisitor<Activity, LoopCharacteristics>> characteristicsVisitors = new HashMap<LoopCharacteristicsType, ActivityCharacteristicsVisitor<Activity, LoopCharacteristics>>();
    private static final Map<Object, EventTriggerTypeVisitor> eventTriggerTypeVisitor = new HashMap<Object, EventTriggerTypeVisitor>();
    private static final EventTriggerTypeVisitor draftEventTriggerTypeVisitor = new BPMNDraftEventTriggerTypeVisitor();
    private static final BPMNFlowElementVisitor draftActivityVisitor = new BPMNDraftActivityVisitor();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends FlowElement> BPMNFlowElementVisitor<T> getVisitor(FlowNode node) {
        if (!node.isDraftable()) return visitors.get(node.getBpmnType());
        if (!((Draftable)node.asAnyNode(Draftable.class)).isDraft()) return visitors.get(node.getBpmnType());
        if (node.isActivity()) {
            return BPMNFlowElementRegistry.getDraftActivityVisitor();
        }
        if (!node.isEvent()) throw new IllegalArgumentException("BPMN process element '" + node.getName() + "' with id '" + node.getId() + "' and type '" + node.getBpmnType() + "' can not be a draft");
        return visitors.get(node.getBpmnType());
    }

    public static <T extends FlowElement> void registerVisitor(BpmnType type, BPMNFlowElementVisitor<T> visitor) {
        System.out.println("BPMNFlowElementRegistry.registerVisitor:" + type);
        visitors.put(type, visitor);
    }

    public static <T extends Event> void registerEventVisitor(EventTriggerType type, EventTriggerTypeVisitor<T> visitor) {
        System.out.println("BPMNFlowElementRegistry.registerVisitor:" + type);
        eventTriggerTypeVisitor.put(type, visitor);
    }

    public static <T extends SequenceFlow> BPMNFlowElementVisitor<T> getSequenceFlowVisitor() {
        return visitors.get(SEQUENCE_FLOW);
    }

    public static <T extends SequenceFlow> void registerVisitor(BPMNFlowElementVisitor<T> visitor) {
        System.out.println("BPMNFlowElementRegistry.registerVisitor:SEQUENCE_FLOW");
        visitors.put(SEQUENCE_FLOW, visitor);
    }

    public static <T extends SequenceFlow> void registerCharacteristicsVisitor(ActivityCharacteristicsVisitor visitor) {
        characteristicsVisitors.put(visitor.getLoopCharacteristicsType(), visitor);
    }

    public static ActivityCharacteristicsVisitor<Activity, LoopCharacteristics> getCharacteristicsVisitor(LoopCharacteristicsType loopCharacteristicsType) {
        return characteristicsVisitors.get(loopCharacteristicsType);
    }

    public static <T extends Event> EventTriggerTypeVisitor<T> getEventVisitor(T event) {
        EventTriggerTypeVisitor<T> result = event.isDraftable() && ((Draftable)event.asAnyNode(Draftable.class)).isDraft() ? BPMNFlowElementRegistry.getDraftEventTriggerTypeVisitor() : eventTriggerTypeVisitor.get(event.getEventTriggerType());
        return result;
    }

    private static <T extends Event> EventTriggerTypeVisitor<T> getDraftEventTriggerTypeVisitor() {
        return draftEventTriggerTypeVisitor;
    }

    private static <T extends FlowElement> BPMNFlowElementVisitor<T> getDraftActivityVisitor() {
        return draftActivityVisitor;
    }

    static {
        BPMNFlowElementRegistry.registerVisitor(new SequenceFlowVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.MEASUREMENT, new MeasurementVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.COUNTER, new CounterVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.EXCLUSIVE_GATEWAY, new ExclusiveGatewayVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.PARALLEL_GATEWAY, new ParallelGatewayVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.INCLUSIVE_GATEWAY, new InclusiveGatewayVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.EVENT_BASED_GATEWAY, new EventBasedGatewayVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.SCRIPT_TASK, new ScriptTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.SERVICE_TASK, new ServiceTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.RECEIVE_TASK, new ReceiveTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.SEND_TASK, new SendTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.BUSINESS_RULE_TASK, new BusinessRuleTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.USER_TASK, new UserTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.MANUAL_TASK, new ManualTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.START_EVENT, new StartEventVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.END_EVENT, new EndEventVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.CATCH_INTERMEDIATE_EVENT, new CatchIntermediateEventVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.THROW_INTERMEDIATE_EVENT, new ThrowIntermediateEventVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.BOUNDARY_EVENT, new BoundaryEventVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.SUBPROCESS, new SubProcessVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.CALL_ACTIVITY, new CallActivityVisitorImpl());
        BPMNFlowElementRegistry.registerEventVisitor(EventTriggerType.MESSAGE, new MessageEventVisitorImpl());
        BPMNFlowElementRegistry.registerEventVisitor(EventTriggerType.NONE, new NoneEventVisitorImpl());
        BPMNFlowElementRegistry.registerEventVisitor(EventTriggerType.ERROR, new ErrorEventVisitorImpl());
        BPMNFlowElementRegistry.registerEventVisitor(EventTriggerType.TIMER, new TimerEventVisitorImpl());
        BPMNFlowElementRegistry.registerEventVisitor(EventTriggerType.TERMINATE, new TerminateEventVisitorImpl());
        BPMNFlowElementRegistry.registerEventVisitor(EventTriggerType.SIGNAL, new SignalEventVisitorImpl());
        BPMNFlowElementRegistry.registerCharacteristicsVisitor(new MultiInstanceCharacteristicsVisitor());
        BPMNFlowElementRegistry.registerCharacteristicsVisitor(new LoopCharacteristicsVisitor());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.COMPLEX_GATEWAY, new ComplexGatewayVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.NOTIFICATION_TASK, new NotificationTaskVisitorImpl());
        BPMNFlowElementRegistry.registerVisitor(BpmnType.UPDATE_TASK, new UpdateTaskVisitorImpl());
    }
}

