/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.GenerateNextTokensCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.microkernel.MICall;
import oracle.bpm.bpmn.engine.microkernel.MINop;
import oracle.bpm.bpmn.engine.microkernel.MISequenceBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.InstanceAttributeSupport;
import oracle.bpm.bpmn.engine.model.runtime.LoopRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.MultiInstanceRuntimeHelper;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.md.MDAuditLog;
import oracle.bpm.bpmn.engine.service.audit.AuditServiceFactory;
import oracle.bpm.bpmn.engine.service.audit.AuditUtil;
import oracle.bpm.bpmn.engine.service.audit.persistence.model.AuditQueryMetadata;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Loop;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.services.instancequery.AuditInstanceOperation;
import org.jetbrains.annotations.Nullable;

public class AuditTrailVisitorHelper {
    private static final String logClassName = AbstractBPMNElementVisitor.class.getName();

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPreAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block) {
        return AuditTrailVisitorHelper.createAndAddPreAuditMI(context, element, node, block, Tag.PRE_AUDIT);
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPreAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block, Tag tag) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPreAuditMI(context, element);
        AuditTrailVisitorHelper.addAuditMicroInstruction(context, auditMI, block, element, tag, node);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block) {
        return AuditTrailVisitorHelper.createAndAddPostAuditMI(context, element, node, block, Tag.POST_AUDIT_NORMAL);
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, BPMNCubeElement<T> node, @Nullable MISequenceBlock block, Tag tag) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, tag);
        AuditTrailVisitorHelper.addAuditMicroInstruction(context, auditMI, block, element, tag, node);
        return auditMI;
    }

    public static <T extends FlowNode> BPMNCubeElement<T> createPreAuditLogNode(BPMNCubeMapBuilderContext context, T element, boolean addNode) throws CubeException {
        MDAuditLog mdAuditLog = AuditTrailVisitorHelper.getPreAuditMD(context, element);
        IMicroInstruction<Object> microinstruction = AuditTrailVisitorHelper.createPreAuditMI(mdAuditLog);
        return AuditTrailVisitorHelper.createAuditLogNode(context, "preAuditLog", element, microinstruction, Tag.PRE_AUDIT, addNode);
    }

    public static <T extends FlowNode> BPMNCubeElement<T> createPostAuditLogNode(BPMNCubeMapBuilderContext context, T element, boolean addNode) throws CubeException {
        MDAuditLog mdAuditLog = AuditTrailVisitorHelper.getPostAuditMD(context, element, Tag.POST_AUDIT_NORMAL);
        IMicroInstruction<Object> microinstruction = AuditTrailVisitorHelper.createPostAuditMI(mdAuditLog);
        return AuditTrailVisitorHelper.createAuditLogNode(context, "postAuditLog", element, microinstruction, Tag.POST_AUDIT_NORMAL, addNode);
    }

    @Nullable
    public static <T extends FlowNode> MIAuditLog getAuditlogMicroInstruction(BPMNCubeMapBuilderContext context, T flowNode, Tag tag) {
        BPMNCubeElement node;
        MIAuditLog miAuditLog = null;
        if (tag == Tag.PRE_AUDIT) {
            miAuditLog = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, Tag.PRE_AUDIT_CHARACTERIC);
        } else if (tag == Tag.POST_AUDIT_NORMAL) {
            miAuditLog = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, Tag.POST_NORMAL_AUDIT_CHARACTERIC);
        } else if (tag == Tag.POST_AUDIT_CANCEL) {
            miAuditLog = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, Tag.POST_CANCEL_AUDIT_CHARACTERIC);
        } else if (tag == Tag.POST_AUDIT_EVENT) {
            miAuditLog = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, Tag.POST_EVENT_AUDIT_CHARACTERIC);
        } else if (tag == Tag.POST_AUDIT_EXCEPTION) {
            miAuditLog = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, flowNode, Tag.POST_EXCEPTION_AUDIT_CHARACTERIC);
        }
        if (miAuditLog == null && (node = context.getElementByTag(TagInfo.createTagInfo(flowNode.getId(), tag))) != null) {
            miAuditLog = (MIAuditLog)node.getMicroInstruction(flowNode.getId() + tag.toString());
        }
        return miAuditLog;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPreAuditMI(BPMNCubeMapBuilderContext context, T element, AbstractCompiler.RegisterDelegator delegator, @Nullable MISequenceBlock block) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPreAuditMI(context, element);
        AuditTrailVisitorHelper.addAuditMicroInstruction(context, auditMI, block, element, Tag.PRE_AUDIT, delegator);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, AbstractCompiler.RegisterDelegator delegator, @Nullable MISequenceBlock block) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, Tag.POST_AUDIT_NORMAL);
        AuditTrailVisitorHelper.addAuditMicroInstruction(context, auditMI, block, element, Tag.POST_AUDIT_NORMAL, delegator);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createAndAddPostAuditMI(BPMNCubeMapBuilderContext context, T element, AbstractCompiler.RegisterDelegator delegator, @Nullable MISequenceBlock block, Tag tag) {
        IMicroInstruction<Object> auditMI = AuditTrailVisitorHelper.createPostAuditMI(context, element, tag);
        AuditTrailVisitorHelper.addAuditMicroInstruction(context, auditMI, block, element, tag, delegator);
        return auditMI;
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createPreAuditMI(BPMNCubeMapBuilderContext context, T element) {
        return AuditTrailVisitorHelper.createPreAuditMI(AuditTrailVisitorHelper.getPreAuditMD(context, element));
    }

    public static <T extends FlowNode> IMicroInstruction<Object> createPostAuditMI(BPMNCubeMapBuilderContext context, T element, Tag tag) {
        return AuditTrailVisitorHelper.createPostAuditMI(AuditTrailVisitorHelper.getPostAuditMD(context, element, tag));
    }

    public static IMicroInstruction<Object> createPreAuditMI(MDAuditLog metadata) {
        return new MIAuditLog(metadata);
    }

    public static IMicroInstruction<Object> createPostAuditMI(MDAuditLog metadata) {
        return new MIAuditLog(metadata);
    }

    public static <T extends FlowNode> MDAuditLog getPreAuditMD(BPMNCubeMapBuilderContext context, T element) {
        MIAuditLog lg;
        String pid;
        BPMNCubeElement ce;
        AuditInstanceOperation operation;
        boolean isInstanceCreated = AuditTrailVisitorHelper.isCreateInstance(element);
        AuditInstanceOperation auditInstanceOperation = operation = isInstanceCreated ? AuditInstanceOperation.INSTANCE_CREATED : AuditInstanceOperation.FLOW_NODE_IN;
        if (element.getBpmnType() == BpmnType.END_EVENT) {
            String activityType = AuditUtil.getActivityType(element, element.getBpmnType());
        }
        String compositeDN = null;
        if (context.getComponentModel() != null && context.getComponentModel().getComposite() != null) {
            compositeDN = context.getComponentModel().getComposite().getDN();
        }
        boolean isInSubprocess = AuditTrailVisitorHelper.isInSubprocess(element);
        InstanceAttributeSupport loopCountAttr = AuditTrailVisitorHelper.getLoopAttr(element, isInSubprocess);
        InstanceAttributeSupport instanceCountAttr = AuditTrailVisitorHelper.getInstanceAttr(element, isInSubprocess);
        MDAuditLog mdAuditLog = new MDAuditLog("BPMN", operation, true, isInstanceCreated, false, loopCountAttr, instanceCountAttr, isInSubprocess, element, compositeDN);
        mdAuditLog.setAuditQueryMetadata(AuditTrailVisitorHelper.getAuditVariableMetadata(context));
        mdAuditLog.setScopeId(context.getCubeElementId((ProjectObject)(element.getParentObject() != null ? element.getParentObject() : element), ""));
        if (!isInSubprocess && element.getBpmnType() == BpmnType.START_EVENT && (ce = context.getElementByTag(TagInfo.createTagInfo(pid = element.getParentObject().getId(), Tag.PRE_AUDIT))) != null && (lg = (MIAuditLog)ce.getMicroInstruction(pid + (Object)((Object)Tag.PRE_AUDIT))) != null) {
            lg.getMetadata().addProcessTargetActivityId(element);
        }
        return mdAuditLog;
    }

    public static <T extends FlowNode> MDAuditLog getPostAuditMD(BPMNCubeMapBuilderContext context, T element, Tag tag) {
        Counter cn;
        String logMethodName = "getPostAuditMD";
        AuditInstanceOperation operation = null;
        boolean isInstanceTerminated = AuditTrailVisitorHelper.isInstanceTerminated(element);
        operation = isInstanceTerminated ? AuditInstanceOperation.INSTANCE_TERMINATED : (tag.equals((Object)Tag.POST_AUDIT_EXCEPTION) || tag.equals((Object)Tag.POST_EXCEPTION_AUDIT_CHARACTERIC) ? AuditInstanceOperation.INSTANCE_FAULT : (tag.equals((Object)Tag.POST_AUDIT_CANCEL) || tag.equals((Object)Tag.POST_CANCEL_AUDIT_CHARACTERIC) ? AuditInstanceOperation.FLOW_NODE_CANCELLED : AuditInstanceOperation.FLOW_NODE_OUT));
        String compositeDN = null;
        if (context.getComponentModel() != null && context.getComponentModel().getComposite() != null) {
            compositeDN = context.getComponentModel().getComposite().getDN();
        }
        boolean isInSubprocess = AuditTrailVisitorHelper.isInSubprocess(element);
        InstanceAttributeSupport loopCountAttr = AuditTrailVisitorHelper.getLoopAttr(element, isInSubprocess);
        InstanceAttributeSupport instanceCountAttr = AuditTrailVisitorHelper.getInstanceAttr(element, isInSubprocess);
        MDAuditLog mdAuditLog = new MDAuditLog("BPMN", operation, false, false, isInstanceTerminated, loopCountAttr, instanceCountAttr, isInSubprocess, element, compositeDN);
        mdAuditLog.setAuditQueryMetadata(AuditTrailVisitorHelper.getAuditVariableMetadata(context));
        mdAuditLog.setScopeId(context.getCubeElementId((ProjectObject)(element.getParentObject() != null ? element.getParentObject() : element), ""));
        AuditTrailVisitorHelper.addMeasurementMarks(element.getOutgoingSequenceFlows(), mdAuditLog);
        if (element.isActivity() && !tag.equals((Object)Tag.POST_NORMAL_AUDIT_CHARACTERIC) && (cn = ModelUtils.findCounterByActivity((Process)element.getProcess(), (Activity)((Activity)element.asAnyNode(Activity.class)))) != null) {
            DeploymentLogger.LOG.debug(logClassName, "getPostAuditMD", new Object[]{"Adding counter {" + cn.getId() + "} to {" + cn.getActivityId() + "}"});
            mdAuditLog.addCounter(cn);
        }
        return mdAuditLog;
    }

    private static <T extends FlowNode> void addAuditMicroInstruction(BPMNCubeMapBuilderContext context, IMicroInstruction<Object> microInstruction, @Nullable MISequenceBlock block, T flowNode, Tag tag, BPMNCubeElement<T> node) {
        if (block != null) {
            block.addMicroInstruction(microInstruction);
        }
        node.addMicroInstruction(flowNode.getId() + tag.toString(), microInstruction);
        context.tagElement(TagInfo.createTagInfo(flowNode.getId(), tag), node);
    }

    private static <T extends FlowNode> void addAuditMicroInstruction(BPMNCubeMapBuilderContext context, IMicroInstruction<Object> microInstruction, @Nullable MISequenceBlock block, T flowNode, Tag tag, AbstractCompiler.RegisterDelegator delegator) {
        if (block != null) {
            block.addMicroInstruction(microInstruction);
        }
        delegator.register(microInstruction, flowNode.getId() + tag.toString());
        delegator.tag(context, TagInfo.createTagInfo(flowNode.getId(), tag));
    }

    private static <T extends FlowNode> InstanceAttributeSupport getLoopAttr(T element, boolean isInSubprocess) {
        InstanceAttributeSupport<Integer> loopCountAttr = null;
        LoopCharacteristics loopCharacteristics = null;
        FlowNode fn = null;
        Activity activity = null;
        fn = isInSubprocess ? (FlowNode)element.getParentObject() : (FlowNode)element;
        if (fn != null && fn.is(Activity.class)) {
            activity = (Activity)fn.asAnyNode(Activity.class);
            loopCharacteristics = activity.getLoopCharacteristics();
            if (loopCharacteristics != null && loopCharacteristics instanceof Loop) {
                Loop loop = null;
                loop = (Loop)loopCharacteristics.as(Loop.class);
                LoopRuntimeHelper h = new LoopRuntimeHelper((FlowNode)activity, loop);
                loopCountAttr = h.getLoopCounterInstanceAttribute();
            } else if (loopCharacteristics != null && loopCharacteristics instanceof MultiInstance) {
                MultiInstance multiInstance = null;
                multiInstance = (MultiInstance)loopCharacteristics.as(MultiInstance.class);
                MultiInstanceRuntimeHelper h = new MultiInstanceRuntimeHelper((FlowNode)activity, multiInstance);
                loopCountAttr = h.getLoopCounterInstanceAttribute();
            }
        }
        return loopCountAttr;
    }

    private static <T extends FlowNode> InstanceAttributeSupport getInstanceAttr(T element, boolean isInSubprocess) {
        InstanceAttributeSupport<Integer> loopCountAttr = null;
        LoopCharacteristics loopCharacteristics = null;
        FlowNode fn = null;
        Activity activity = null;
        fn = isInSubprocess ? (FlowNode)element.getParentObject() : (FlowNode)element;
        if (fn instanceof Activity && (loopCharacteristics = (activity = (Activity)fn).getLoopCharacteristics()) != null && loopCharacteristics instanceof MultiInstance) {
            MultiInstance multiInstance = null;
            multiInstance = (MultiInstance)loopCharacteristics.as(MultiInstance.class);
            MultiInstanceRuntimeHelper h = new MultiInstanceRuntimeHelper((FlowNode)activity, multiInstance);
            loopCountAttr = h.getLoopCounterInstanceAttribute();
        }
        return loopCountAttr;
    }

    private static <T extends FlowNode> BPMNCubeElement<T> createAuditLogNode(final BPMNCubeMapBuilderContext context, final String suffix, final T element, final IMicroInstruction<Object> microinstruction, final Tag tag, boolean addNode) throws CubeException {
        SimpleVisitorImpl visitor = new SimpleVisitorImpl<T, CompilationResult>(element, context){

            @Override
            protected MIBPMNActivityNode<T> createNode(BPMNCubeMapBuilderContext context2, String activityName) {
                return new MIBPMNActivityNode(context2, suffix, activityName, this.getElement().getBpmnType(), this.getElement());
            }

            @Override
            protected GenerateNextTokensCompiler<T> getGenerateNextTokenCompiler(MIBPMNActivityNode node) {
                return new GenerateNextTokensCompiler<FlowNode>(this.getContext(), node, element);
            }

            @Override
            protected AbstractCompiler getCompiler(final AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler<T>((FlowNode)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction generateExecuteStatementMethod() {
                        MISequenceBlock block = new MISequenceBlock();
                        AuditTrailVisitorHelper.addAuditMicroInstruction(context, (IMicroInstruction<Object>)microinstruction, block, this.getElement(), tag, delegator);
                        block.addMicroInstruction(new MIMarkAsComplete());
                        block.addMicroInstruction(new MICall("GENERATE_NEXT_TOKENS"));
                        return block;
                    }

                    @Override
                    protected IMicroInstruction generateHandleCallbackMethod() {
                        return new MINop();
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return null;
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return null;
                    }

                    @Override
                    protected IMicroInstruction generateExecuteStatementExceptionMethod(BPMNCubeMapBuilderContext context) {
                        return new MINop();
                    }

                    @Override
                    protected IMicroInstruction generateHandleCallbackExceptionMethod(BPMNCubeMapBuilderContext context) {
                        return new MINop();
                    }

                    @Override
                    protected IMicroInstruction generateCancelPerformMethod(BPMNCubeMapBuilderContext context) {
                        return new MINop();
                    }
                };
            }
        };
        visitor.setAddElementToCubeMap(addNode);
        Object result = visitor.visit((ICubeBlock)context.getCurrentBlock());
        return ((CompilationResult)result).getEntryPoint();
    }

    private static <T extends FlowNode> boolean isCreateInstance(T node) {
        return node.getParentObject() == null;
    }

    private static <T extends FlowNode> boolean isInstanceTerminated(T node) {
        return node.getParentObject() == null;
    }

    private static <T extends FlowNode> boolean isInSubprocess(T element) {
        return element.getParentObject() != element.getProcess();
    }

    private static AuditQueryMetadata getAuditVariableMetadata(BPMNCubeMapBuilderContext context) {
        AuditQueryMetadata auditMetadata = null;
        String logMethodName = "insertAuditLogNodes";
        if (context.getComponentModel() != null && context.getComponentModel().getComposite() != null) {
            String compositeDN = context.getComponentModel().getComposite().getDN();
            if (compositeDN != null) {
                try {
                    auditMetadata = AuditServiceFactory.getInstance().getAuditService().getAuditQueryMetadata(compositeDN);
                }
                catch (Exception e) {
                    DeploymentLogger.LOG.warn(logClassName, "insertAuditLogNodes", new Object[]{"Unable to obtain the audit metadta " + e});
                }
            } else {
                DeploymentLogger.LOG.warn(logClassName, "insertAuditLogNodes", new Object[]{"The compositeDN is null. No variable information can be set."});
            }
        }
        return auditMetadata;
    }

    private static <T extends SequenceFlow> void addMeasurementMarks(Sequence<T> flows, MDAuditLog mdAuditLog) {
        String logMethodName = "addMeasurementMarks";
        if (flows == null) {
            return;
        }
        for (SequenceFlow sf : flows) {
            if (sf.getMeasurements() == null) continue;
            for (Measurement m : sf.getMeasurements()) {
                DeploymentLogger.LOG.debug(logClassName, "addMeasurementMarks", new Object[]{"Adding measurement {" + m.getId() + "} to {" + mdAuditLog.getFlowElement().getId() + "}"});
                mdAuditLog.addMeasurementMark(m);
            }
        }
    }
}

