/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors.impl;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.core.map.ICubeBlock;
import java.util.HashSet;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.Tag;
import oracle.bpm.bpmn.engine.map.builder.TagInfo;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AbstractBPMNElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.AuditTrailVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilerHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SimpleVisitorImpl;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.compilers.AbstractCompiler;
import oracle.bpm.bpmn.engine.microkernel.IMicroInstruction;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.BlockFactory;
import oracle.bpm.bpmn.engine.model.blocks.DummyBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.nodes.AbstractGatewayNode;
import oracle.bpm.bpmn.engine.model.runtime.MIBPMNActivityNode;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.AuditLogMicroInstruction;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAssertFalse;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIAuditLog;
import oracle.bpm.bpmn.engine.model.runtime.microinstructions.MIMarkAsComplete;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.SequenceFlow;

public abstract class AbstractBPMNGatewayVisitor<T extends Gateway>
extends AbstractBPMNElementVisitor<T> {
    static final String logClassName = AbstractBPMNGatewayVisitor.class.getName();

    @Override
    public final CompilationResult visitElement(T gateway, BPMNCubeMapBuilderContext context) throws CubeException {
        CompilationResult result;
        if (ModelVisitorUtil.isMergingGatewayCancelPendingFlows(gateway)) {
            String activityId = gateway.getId();
            String activityName = gateway.getName();
            Gateway mergingGateway = gateway.getMergingGateway();
            DummyBlock gatewayBlock = BlockFactory.createDummyBlock(context, activityName, mergingGateway);
            context.addElementToCurrentBlock(gatewayBlock);
            BaseBPMNActivityBlock previousBlock = context.getCurrentBlock();
            context.setCurrentBlock(gatewayBlock);
            CompilationResult forkingGatewayResult = this.visitGateway(gateway, context);
            CompilerHelper.tagEntryExitPoints(context, forkingGatewayResult);
            gatewayBlock.getSequenceFlowMetadata().addEntryElement(forkingGatewayResult.getEntryPoint());
            CompilationResult mergingGatewayResult = ModelVisitorUtil.visit(mergingGateway, context);
            this.visitGatewayFlows((FlowNode)gateway, context, mergingGateway, (Set<String>)new HashSet<String>());
            CompilationResult endGateway = this.addNoneEndEnode(mergingGateway, context);
            context.link(mergingGatewayResult.getExitPoint(), endGateway.getEntryPoint());
            context.tagElement(TagInfo.createTagInfo(mergingGateway.getId(), Tag.EXIT_POINT), gatewayBlock);
            gatewayBlock.addMicroInstruction("BLOCK_COMPLETE", AuditTrailVisitorHelper.createPostAuditMI(context, mergingGateway, Tag.POST_AUDIT_NORMAL));
            context.setCurrentBlock(previousBlock);
            result = new CompilationResult(activityId, gatewayBlock, gatewayBlock);
        } else {
            result = this.visitGateway(gateway, context);
        }
        return result;
    }

    protected abstract CompilationResult visitGateway(T var1, BPMNCubeMapBuilderContext var2) throws CubeException;

    @Override
    protected CompilationResult insertAuditLogNodes(T element, BPMNCubeMapBuilderContext context, CompilationResult result) throws CubeException {
        BPMNCubeElement cubeElement = context.getElementByTag(TagInfo.createTagInfo(result.getActivityId(), Tag.GATEWAY_NODE));
        if (cubeElement instanceof AbstractGatewayNode) {
            AbstractGatewayNode gatewayNode = (AbstractGatewayNode)cubeElement;
            AuditLogMicroInstruction preAuditMI = this.createAuditLog(element, context, true);
            gatewayNode.addMicroInstruction(preAuditMI, 0);
            if (element.getDirection() != GatewayDirection.CONVERGING || !ModelVisitorUtil.isCancelPendingFlows(element)) {
                AuditLogMicroInstruction postAuditMI = this.createAuditLog(element, context, false);
                gatewayNode.addMicroInstruction(postAuditMI, gatewayNode.getMicroInstructions().size());
            }
        } else {
            super.insertAuditLogNodes(element, context, result);
        }
        return result;
    }

    private CompilationResult addNoneEndEnode(Gateway gateway, BPMNCubeMapBuilderContext context) throws CubeException {
        return new SimpleVisitorImpl<Gateway, CompilationResult>(gateway, context){

            @Override
            protected MIBPMNActivityNode createNode(BPMNCubeMapBuilderContext context, String activityName) {
                return new MIBPMNActivityNode(context, "_end", activityName, ((Gateway)this.getElement()).getBpmnType(), this.getElement());
            }

            @Override
            protected AbstractCompiler getCompiler(AbstractCompiler.RegisterDelegator delegator) {
                return new AbstractCompiler((FlowNode)this.getElement(), delegator){

                    @Override
                    protected IMicroInstruction<Object> getDoExecuteStatement() {
                        return new MIMarkAsComplete();
                    }

                    @Override
                    protected IMicroInstruction<Object> getDoHandleCallback() {
                        return new MIAssertFalse();
                    }
                };
            }
        }.visit((ICubeBlock)context.getCurrentBlock());
    }

    private void visitGatewayFlows(FlowNode flowNode, BPMNCubeMapBuilderContext context, Gateway mergingGateway, Set<String> visitedNodes) throws CubeException {
        if (!visitedNodes.contains(flowNode.getId())) {
            visitedNodes.add(flowNode.getId());
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingSequenceFlows()) {
                FlowNode target = sequenceFlow.getTarget();
                if (target != mergingGateway) {
                    if (!visitedNodes.contains(target.getId())) {
                        ModelVisitorUtil.visit(target, context);
                    }
                    for (FlowNode f : ModelVisitorUtil.getNextTargets(target)) {
                        this.visitGatewayFlows(f, context, mergingGateway, visitedNodes);
                    }
                }
                ModelVisitorUtil.visit(sequenceFlow, context);
            }
        }
    }

    private AuditLogMicroInstruction createAuditLog(T element, BPMNCubeMapBuilderContext context, boolean entryPoint) throws CubeException {
        MIBPMNActivityNode aln = entryPoint ? (MIBPMNActivityNode)AuditTrailVisitorHelper.createPreAuditLogNode(context, element, false) : (MIBPMNActivityNode)AuditTrailVisitorHelper.createPostAuditLogNode(context, element, false);
        context.tagElement(TagInfo.createTagInfo(element.getId(), entryPoint ? Tag.PRE_AUDIT : Tag.POST_AUDIT_NORMAL), aln);
        MIAuditLog auditMI = AuditTrailVisitorHelper.getAuditlogMicroInstruction(context, element, entryPoint ? Tag.PRE_AUDIT : Tag.POST_AUDIT_NORMAL);
        return new AuditLogMicroInstruction(auditMI);
    }
}

