/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.delivery.CorrelationPropertyDef;
import com.collaxa.cube.engine.delivery.CorrelationSetDef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.BPMNFlowElementVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.ActivityCharacteristicsVisitor;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.BPMNFlowElementRegistry;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.EventCompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SubProcessCompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNActivityBlock;
import oracle.bpm.bpmn.engine.model.blocks.TryBlock;
import oracle.bpm.bpmn.engine.model.common.FaultHandler;
import oracle.bpm.bpmn.engine.model.common.FaultHandlers;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.CorrelationProperty;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.ComplexGateway;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventBasedGateway;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.LoopCharacteristics;
import oracle.bpm.project.model.processes.LoopCharacteristicsType;
import oracle.bpm.project.model.processes.MultiInstance;
import oracle.bpm.project.model.processes.ReceiveTask;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.correlations.CorrelationItem;
import oracle.bpm.project.model.processes.correlations.CorrelationItemsContainer;
import org.jetbrains.annotations.NotNull;

public class ModelVisitorUtil {
    public static CompilationResult visit(SequenceFlow sequenceFlow, BPMNCubeMapBuilderContext context) throws CubeException {
        return BPMNFlowElementRegistry.getSequenceFlowVisitor().visit(sequenceFlow, context);
    }

    public static <T extends FlowNode> CompilationResult visit(T node, BPMNCubeMapBuilderContext context) throws CubeException {
        CompilationResult result = null;
        BPMNFlowElementVisitor<T> elementVisitor = BPMNFlowElementRegistry.getVisitor(node);
        if (elementVisitor != null) {
            LoopCharacteristicsType loopCharacteristicsType;
            ActivityCharacteristicsVisitor<Activity, LoopCharacteristics> characteristicsVisitor = null;
            Activity activity = null;
            if (node.isActivity() && (loopCharacteristicsType = (activity = (Activity)node.asAnyNode(Activity.class)).getLoopCharacteristicsType()) != null && (characteristicsVisitor = BPMNFlowElementRegistry.getCharacteristicsVisitor(loopCharacteristicsType)) == null) {
                System.out.println("Skipping characteristics visitor for -> " + loopCharacteristicsType + " activity " + activity);
            }
            result = characteristicsVisitor != null ? characteristicsVisitor.visit(activity, context, elementVisitor) : elementVisitor.visit(node, context);
        } else {
            System.out.println("Skipping visitor for -> " + node);
        }
        return result;
    }

    public static boolean isInitiateNode(FlowNode node) {
        return node.getBpmnType() == BpmnType.START_EVENT || node.getBpmnType() == BpmnType.RECEIVE_TASK && ((ReceiveTask)node.asAnyNode(ReceiveTask.class)).isInstantiate() && node.getIncomingSequenceFlows().isEmpty() || node.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY && ((EventBasedGateway)node).isInstantiate() && node.getIncomingSequenceFlows().isEmpty();
    }

    public static boolean isTerminateNode(FlowNode node) {
        return node.getBpmnType() == BpmnType.END_EVENT;
    }

    public static boolean isInlineEventHandler(FlowNode node) {
        return node.getParentObject() instanceof Subprocess && ((Subprocess)node.getParentObject()).isTriggeredByEvent();
    }

    public static boolean isStartOfInlineEventHandler(CatchEvent node) {
        return node.isStart() && ModelVisitorUtil.isInlineEventHandler((FlowNode)node);
    }

    public static boolean isEventHandler(FlowNode node) {
        CatchEvent catchEvent = (CatchEvent)node.asAnyNode(CatchEvent.class);
        return catchEvent != null && ModelVisitorUtil.isEventHandler(catchEvent);
    }

    public static boolean isEventHandler(CatchEvent node) {
        return node.isBoundaryEvent() || ModelVisitorUtil.isStartOfInlineEventHandler(node);
    }

    public static boolean isInterrupting(CatchEvent node) {
        return node.isStart() && (((StartEvent)node.asAnyNode(StartEvent.class)).isInterrupting() || node.getEventTriggerType() == EventTriggerType.ERROR) || node.isBoundaryEvent() && ((BoundaryEvent)node.asAnyNode(BoundaryEvent.class)).cancelActivity();
    }

    public static boolean isInterrupting(Subprocess subprocess) {
        for (StartEvent startEvent : subprocess.getEvents(StartEvent.class)) {
            if (!ModelVisitorUtil.isInterrupting((CatchEvent)startEvent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTopLevelStart(FlowNode node) {
        return ModelVisitorUtil.isTopLevelStart(node, false);
    }

    public static boolean isTopLevelStart(FlowNode node, boolean includesComingFromInitiatorEBG) {
        EventBasedGateway gateway = (EventBasedGateway)node.asAnyNode(EventBasedGateway.class);
        boolean isStartEvent = node.asAnyNode(StartEvent.class) != null;
        boolean isInstanceEBG = gateway != null && gateway.isInstantiate();
        return node.getParentObject() == node.getProcess() && !node.getProcess().isCallableSubprocess() && (isStartEvent || isInstanceEBG || includesComingFromInitiatorEBG && ModelVisitorUtil.comesFromEventBasedGateway(node, true));
    }

    public static boolean isThreadEndEvent(FlowNode node) {
        return node.getBpmnType() == BpmnType.END_EVENT && (node.getParentObject() == node.getProcess() && !node.getProcess().isCallableSubprocess() || ModelVisitorUtil.isInlineEventHandler(node) || ModelVisitorUtil.isEndOfParallelMultiInstance(node));
    }

    public static boolean isTerminateEndEvent(FlowNode node) {
        return node.getBpmnType() == BpmnType.END_EVENT && ((Event)node.asAnyNode(Event.class)).getEventTriggerType() == EventTriggerType.TERMINATE;
    }

    public static boolean isEndOfParallelMultiInstance(FlowNode node) {
        MultiInstance multiInstance;
        LoopCharacteristics loopCharacteristics;
        if (node.getBpmnType() == BpmnType.END_EVENT && node.getParentObject() instanceof Subprocess && (loopCharacteristics = ((Subprocess)node.getParentObject()).getLoopCharacteristics()) != null && (multiInstance = (MultiInstance)loopCharacteristics.as(MultiInstance.class)) != null) {
            return !multiInstance.isSequential();
        }
        return false;
    }

    public static boolean comesFromEventBasedGateway(FlowNode node, boolean forceOnlyInitiator) {
        SequenceFlow sequenceFlow;
        Sequence incomingFlowsSequence = node.getIncomingSequenceFlows();
        return !incomingFlowsSequence.isEmpty() && (sequenceFlow = (SequenceFlow)incomingFlowsSequence.iterator().next()).getSource().getBpmnType() == BpmnType.EVENT_BASED_GATEWAY && (!forceOnlyInitiator || ((EventBasedGateway)sequenceFlow.getSource().asAnyNode(EventBasedGateway.class)).isInstantiate());
    }

    public static boolean comesFromEventBasedGateway(FlowNode node) {
        return ModelVisitorUtil.comesFromEventBasedGateway(node, false);
    }

    public static boolean isNotEventHandlerOrComesFromEventBasedGateway(FlowNode element) {
        CatchEvent catchEvent = (CatchEvent)element.asAnyNode(CatchEvent.class);
        ReceiveTask receiveTask = (ReceiveTask)element.asAnyNode(ReceiveTask.class);
        return (catchEvent == null || !ModelVisitorUtil.isEventHandler(catchEvent) && !ModelVisitorUtil.comesFromEventBasedGateway((FlowNode)catchEvent)) && (receiveTask == null || !ModelVisitorUtil.comesFromEventBasedGateway((FlowNode)receiveTask));
    }

    public static void processInlineCompilationResult(BaseBPMNActivityBlock subProcessBlock, TryBlock tryBlock, List<SubProcessCompilationResult> eventCompilationResult) {
        for (SubProcessCompilationResult result : eventCompilationResult) {
            ModelVisitorUtil.processInlineCompilationResult(subProcessBlock, tryBlock, result);
        }
    }

    public static boolean isCancelPendingFlows(@NotNull Gateway gateway) {
        if (gateway.getBpmnType() == BpmnType.COMPLEX_GATEWAY) {
            return ((ComplexGateway)gateway.asGateway(ComplexGateway.class)).isAbortPendingFlows();
        }
        return false;
    }

    public static boolean isMergingGatewayCancelPendingFlows(@NotNull Gateway gateway) {
        return gateway.getDirection() == GatewayDirection.DIVERGING && ModelVisitorUtil.isCancelPendingFlows(gateway.getMergingGateway());
    }

    public static void addCorrelations(BPMNCubeMapBuilderContext context, QName eventName, CorrelationItemsContainer correlationItemsContainer) {
        String key = eventName.toString();
        ModelVisitorUtil.addCorrelations(context, key, null, correlationItemsContainer);
    }

    public static void addCorrelations(BPMNCubeMapBuilderContext context, String serviceName, String operationName, QName messageType, CorrelationItemsContainer correlationItemsContainer) {
        String key = serviceName + "/" + operationName;
        ModelVisitorUtil.addCorrelations(context, key, messageType, correlationItemsContainer);
    }

    public static void addCorrelations(BPMNCubeMapBuilderContext context, String key, QName messageType, CorrelationItemsContainer correlationItemsContainer) {
        Sequence items = correlationItemsContainer.getCorrelationItems();
        if (!items.isEmpty()) {
            CorrelationSetDef def = context.getCorrelationSetDef(key);
            if (def == null) {
                def = new CorrelationSetDef(key);
            }
            for (CorrelationItem item : items) {
                if (item.initiates()) continue;
                int ord = 1;
                for (CorrelationProperty prop : item.getCorrelationKey().getProperties()) {
                    QName type = null;
                    if (!prop.getType().equals(CatalogType.Default.getNone())) {
                        type = prop.getType().getDelegate().asSchemaObject().getQName();
                    }
                    CorrelationPropertyDef corrPropDef = new CorrelationPropertyDef(prop.getFullName(), messageType, type, ord++);
                    def.addCorrelationPropertyDef(corrPropDef);
                }
            }
            context.addCorrelationSubscription(key, def);
        }
    }

    public static Collection<FlowNode> getNextTargets(FlowNode target) throws CubeException {
        ArrayList<FlowNode> result = new ArrayList<FlowNode>();
        if (target.getBpmnType() == BpmnType.EVENT_BASED_GATEWAY) {
            for (SequenceFlow flow : target.getOutgoingSequenceFlows()) {
                result.add(flow.getTarget());
            }
        } else if (target.isGateway() && ModelVisitorUtil.isMergingGatewayCancelPendingFlows((Gateway)target.asAnyNode(Gateway.class))) {
            result.add((FlowNode)((Gateway)target.asAnyNode(Gateway.class)).getMergingGateway());
        } else {
            result.add(target);
        }
        return result;
    }

    private static void processInlineCompilationResult(BaseBPMNActivityBlock subProcessBlock, TryBlock tryBlock, SubProcessCompilationResult eventCompilationResult) {
        ArrayList<FaultHandler> faultHandlers = new ArrayList<FaultHandler>();
        FaultHandler defaultHandler = null;
        for (EventCompilationResult eventResult : eventCompilationResult.getStartEventCompilationResult()) {
            if (eventResult.isErrorHandler()) {
                if (eventResult.getErrorHandlingPolicy().isCatchAll()) {
                    faultHandlers.add(eventResult.createFaultHandler());
                    continue;
                }
                faultHandlers.add(0, eventResult.createFaultHandler());
                continue;
            }
            subProcessBlock.getSequenceFlowMetadata().addEntryElement(eventCompilationResult.getEntryPoint());
        }
        if (tryBlock != null) {
            FaultHandlers faultHanldersImpl = tryBlock.getFaultHandlers();
            if (faultHanldersImpl == null) {
                faultHanldersImpl = new FaultHandlersImpl(faultHandlers, defaultHandler);
            } else {
                ((FaultHandlersImpl)faultHanldersImpl).addFaultHandlers(faultHandlers);
                ((FaultHandlersImpl)faultHanldersImpl).setDefaultHandler(defaultHandler);
            }
            tryBlock.setFaultHandlers(faultHanldersImpl);
        }
    }

    public static class FaultHandlersImpl
    implements FaultHandlers {
        private FaultHandler defaultHandler;
        private List<FaultHandler> faultHandlers;

        public FaultHandlersImpl(List<FaultHandler> faultHandlers, FaultHandler defaultHandler) {
            this.faultHandlers = faultHandlers;
            this.defaultHandler = defaultHandler;
        }

        @Override
        public List<FaultHandler> getFaultHandlers() {
            return this.faultHandlers;
        }

        @Override
        public FaultHandler getDefaultHandler() {
            return this.defaultHandler;
        }

        public void addFaultHandlers(List<FaultHandler> handlers) {
            if (this.faultHandlers == null) {
                this.faultHandlers = new ArrayList<FaultHandler>();
            }
            this.faultHandlers.addAll(handlers);
        }

        public void setDefaultHandler(FaultHandler handler) {
            this.defaultHandler = handler;
        }
    }
}

