/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;

public class ModelVisitorHelper {
    private Set<Activity> activities;
    private Set<Event> events;
    private Set<Gateway> gateways;
    private Set<Subprocess> inlineSubprocesses;
    private Sequence<Measurement> measurements;
    private NodeContainer nodeContainer;
    private Set<FlowNode> nodesInBoundaryFlow;
    private Set<FlowNode> nodesInEventBasedGateway;
    private Set<FlowNode> nodesInStructuredGateway;
    private Set<SequenceFlow> sequenceFlows;

    public ModelVisitorHelper(NodeContainer nodeContainer) {
        this.nodeContainer = nodeContainer;
        this.calculateActivities(nodeContainer);
        this.calculateEvents(nodeContainer);
        this.calculateSequenceFlows(nodeContainer);
        this.calculateGateways(nodeContainer);
        this.calculateMeasurements(nodeContainer);
    }

    public Iterable<Activity> getActivities() {
        return this.activities;
    }

    public Iterable<Subprocess> getInlineSubprocesses() {
        return this.inlineSubprocesses;
    }

    public Iterable<Event> getEvents() {
        return this.events;
    }

    public Iterable<SequenceFlow> getSequenceFlows() {
        return this.sequenceFlows;
    }

    public Iterable<Gateway> getGateways() {
        return this.gateways;
    }

    public Sequence<Measurement> getMeasurements() {
        return this.measurements;
    }

    private static void addNodes(FlowNode node, Set<FlowNode> nodes, boolean recursive, FlowNode lastNode, Set<String> visitedNodes) {
        if (!visitedNodes.contains(node.getId())) {
            visitedNodes.add(node.getId());
            Sequence flowSequence = node.getOutgoingSequenceFlows();
            for (SequenceFlow sequenceFlow : flowSequence) {
                FlowNode target = sequenceFlow.getTarget();
                nodes.add(target);
                if (!recursive || target == lastNode) continue;
                ModelVisitorHelper.addNodes(target, nodes, recursive, lastNode, visitedNodes);
            }
        }
    }

    private void calculateActivities(NodeContainer nodeContainer) {
        Set activitiesAux = this.filterNodes(nodeContainer.getActivities());
        this.activities = new HashSet<Activity>();
        this.inlineSubprocesses = new HashSet<Subprocess>();
        for (Activity act : activitiesAux) {
            if (act.isSubprocess() && ((Subprocess)act.asAnyNode(Subprocess.class)).isTriggeredByEvent()) {
                this.inlineSubprocesses.add((Subprocess)act.asAnyNode(Subprocess.class));
                continue;
            }
            this.activities.add(act);
        }
    }

    private void calculateEvents(NodeContainer nodeContainer) {
        this.events = this.filterNodes(nodeContainer.getEvents());
    }

    private void calculateSequenceFlows(NodeContainer nodeContainer) {
        Sequence flowSequence = nodeContainer.getSequenceFlows();
        this.sequenceFlows = new HashSet<SequenceFlow>();
        for (SequenceFlow flow : flowSequence) {
            if (!this.hasToAddNode(flow.getTarget())) continue;
            this.sequenceFlows.add(flow);
        }
    }

    private void calculateGateways(NodeContainer nodeContainer) {
        this.gateways = this.filterNodes(nodeContainer.getGateways());
    }

    private void calculateMeasurements(NodeContainer nodeContainer) {
        this.measurements = nodeContainer.getMeasurements();
    }

    private <T extends FlowNode> Set<T> filterNodes(Sequence<T> sequence) {
        HashSet<FlowNode> result = new HashSet<FlowNode>();
        for (FlowNode node : sequence) {
            if (!this.hasToAddNode(node)) continue;
            result.add(node);
        }
        return result;
    }

    private boolean hasToAddNodeSimple(FlowNode node) {
        return !this.getNodesInBoundaryFlow().contains(node) && !this.getNodesInStructuredGateway().contains(node);
    }

    private boolean hasToAddNode(FlowNode node) {
        return this.hasToAddNodeSimple(node) && !this.getEventsInEventBasedGateway().contains(node);
    }

    private Set<FlowNode> getNodesInBoundaryFlow() {
        if (this.nodesInBoundaryFlow == null) {
            Sequence boundaryEventSequence = this.nodeContainer.getBoundaryEvents();
            this.nodesInBoundaryFlow = new HashSet<FlowNode>();
            for (BoundaryEvent boundaryEvent : boundaryEventSequence) {
                if (boundaryEvent.cancelActivity()) continue;
                ModelVisitorHelper.addNodes((FlowNode)boundaryEvent, this.nodesInBoundaryFlow, true, null, new HashSet<String>());
            }
        }
        return this.nodesInBoundaryFlow;
    }

    private Set<FlowNode> getEventsInEventBasedGateway() {
        if (this.nodesInEventBasedGateway == null) {
            this.nodesInEventBasedGateway = new HashSet<FlowNode>();
            for (Gateway gateway : this.nodeContainer.getGateways()) {
                if (gateway.getBpmnType() != BpmnType.EVENT_BASED_GATEWAY) continue;
                ModelVisitorHelper.addNodes((FlowNode)gateway, this.nodesInEventBasedGateway, false, null, new HashSet<String>());
            }
        }
        return this.nodesInEventBasedGateway;
    }

    private Set<FlowNode> getNodesInStructuredGateway() {
        if (this.nodesInStructuredGateway == null) {
            this.nodesInStructuredGateway = new HashSet<FlowNode>();
            for (Gateway gateway : this.nodeContainer.getGateways()) {
                if (!ModelVisitorUtil.isMergingGatewayCancelPendingFlows(gateway)) continue;
                ModelVisitorHelper.addNodes((FlowNode)gateway, this.nodesInStructuredGateway, true, (FlowNode)gateway.getMergingGateway(), new HashSet<String>());
            }
        }
        return this.nodesInStructuredGateway;
    }
}

