/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmn.engine.map.builder.visitors;

import com.collaxa.cube.CubeException;
import com.collaxa.cube.engine.deployment.DeploymentLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.bpmn.engine.map.builder.BPMNCubeMapBuilderContext;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorHelper;
import oracle.bpm.bpmn.engine.map.builder.visitors.ModelVisitorUtil;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.CompilationResult;
import oracle.bpm.bpmn.engine.map.builder.visitors.impl.SubProcessCompilationResult;
import oracle.bpm.bpmn.engine.model.blocks.BaseBPMNBlock;
import oracle.bpm.bpmn.engine.model.common.BPMNCubeElement;
import oracle.bpm.bpmn.engine.model.runtime.util.DataHandlingUtils;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.CatchEvent;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;

public class ModelVisitor {
    private Map<BPMNCubeElement, Set<FlowNode>> conditionalInitiateElementMap;
    private BPMNCubeMapBuilderContext context;
    private Set<BPMNCubeElement> initiateElement;
    private Set<BPMNCubeElement> terminateElement;
    private List<SubProcessCompilationResult> inlineErrorSubProcesses;
    private ModelVisitorHelper modelVisitoryHelper;
    private NodeContainer nodeContainer;
    private static final String logClassName = ModelVisitor.class.getName();

    public ModelVisitor(BPMNCubeMapBuilderContext context, NodeContainer nodeContainer) {
        this.context = context;
        this.nodeContainer = nodeContainer;
        this.initiateElement = new HashSet<BPMNCubeElement>();
        this.terminateElement = new HashSet<BPMNCubeElement>();
        this.conditionalInitiateElementMap = new HashMap<BPMNCubeElement, Set<FlowNode>>();
        this.inlineErrorSubProcesses = new ArrayList<SubProcessCompilationResult>();
    }

    public Iterable<BPMNCubeElement> getInitiateElement() {
        return this.initiateElement;
    }

    public Iterable<BPMNCubeElement> getTerminateElement() {
        return this.terminateElement;
    }

    public Map<BPMNCubeElement, Set<FlowNode>> getConditionalInitiateElement() {
        return this.conditionalInitiateElementMap;
    }

    public List<SubProcessCompilationResult> getInlineErrorSubProcesses() {
        return this.inlineErrorSubProcesses;
    }

    public void visit() throws CubeException {
        this.modelVisitoryHelper = new ModelVisitorHelper(this.nodeContainer);
        for (DataObject dataObject : this.nodeContainer.getLocalDeclarations(DataObject.class)) {
            try {
                DataHandlingUtils.handleImport((DataDeclaration)dataObject, this.context);
            }
            catch (Exception e) {
                throw new CubeException((Throwable)e);
            }
        }
        this.compileActivities();
        this.compileInlineSubprocesses();
        this.compileEvents();
        this.compileGateways();
        this.compileSequenceFlows();
        for (BPMNCubeElement initiateElement : this.getInitiateElement()) {
            BaseBPMNBlock initiateElementParentBlock = (BaseBPMNBlock)initiateElement.getParentBlock();
            initiateElementParentBlock.getSequenceFlowMetadata().addEntryElement(initiateElement);
        }
    }

    private void compileSequenceFlows() throws CubeException {
        String logMethodName = "compileSequenceFlows";
        DeploymentLogger.LOG.debug(logClassName, "compileSequenceFlows", new Object[]{"BEGIN"});
        for (SequenceFlow sequenceFlow : this.modelVisitoryHelper.getSequenceFlows()) {
            ModelVisitorUtil.visit(sequenceFlow, this.context);
            System.out.println("elementVisitor for activity[" + sequenceFlow.getClass() + "]= " + sequenceFlow);
        }
        DeploymentLogger.LOG.debug(logClassName, "compileSequenceFlows", new Object[]{"END"});
    }

    private void compileEvents() throws CubeException {
        for (Event event : this.modelVisitoryHelper.getEvents()) {
            CompilationResult result = ModelVisitorUtil.visit(event, this.context);
            this.addToInitiateElements((FlowNode)event, result);
            this.addToTerminateElements((FlowNode)event, result);
        }
    }

    private void compileGateways() throws CubeException {
        for (Gateway gateway : this.modelVisitoryHelper.getGateways()) {
            CompilationResult result = ModelVisitorUtil.visit(gateway, this.context);
            this.addToInitiateElements((FlowNode)gateway, result);
        }
    }

    private void compileActivities() throws CubeException {
        this.compileActivitiesAux(this.modelVisitoryHelper.getActivities());
    }

    private void compileInlineSubprocesses() throws CubeException {
        this.compileActivitiesAux(this.modelVisitoryHelper.getInlineSubprocesses());
    }

    private void compileActivitiesAux(Iterable<? extends Activity> activities) throws CubeException {
        for (Activity activity : activities) {
            CompilationResult result = ModelVisitorUtil.visit(activity, this.context);
            this.addToInitiateElements((FlowNode)activity, result);
        }
    }

    private void addToInitiateElements(FlowNode node, CompilationResult result) {
        if (result != null) {
            if (ModelVisitorUtil.isInitiateNode(node)) {
                this.initiateElement.add(result.getEntryPoint());
                CatchEvent event = (CatchEvent)node.asAnyNode(CatchEvent.class);
                if (event != null && ModelVisitorUtil.isStartOfInlineEventHandler(event) && event.getEventTriggerType() != EventTriggerType.ERROR) {
                    this.initiateElement.add(result.getExitPoint());
                }
            } else {
                Subprocess subprocess;
                Activity activity;
                for (SequenceFlow incomingSequenceFlow : node.getIncomingSequenceFlows()) {
                    if (!ModelVisitorUtil.isTopLevelStart(incomingSequenceFlow.getSource(), true)) continue;
                    this.initiateElement.add(result.getEntryPoint());
                    Set<FlowNode> flowNodeSet = this.conditionalInitiateElementMap.get(result.getEntryPoint());
                    if (flowNodeSet == null) {
                        flowNodeSet = new HashSet<FlowNode>();
                        this.conditionalInitiateElementMap.put(result.getEntryPoint(), flowNodeSet);
                    }
                    flowNodeSet.add(incomingSequenceFlow.getSource());
                }
                if (node.isActivity() && (activity = (Activity)node.asAnyNode(Activity.class)).isSubprocess() && (subprocess = (Subprocess)activity.asAnyNode(Subprocess.class)).isTriggeredByEvent() && !subprocess.getEvents(StartEvent.class, EventTriggerType.ERROR).isEmpty()) {
                    this.inlineErrorSubProcesses.add((SubProcessCompilationResult)result);
                }
            }
        }
    }

    private void addToTerminateElements(FlowNode node, CompilationResult result) {
        if (result != null && ModelVisitorUtil.isTerminateNode(node)) {
            this.terminateElement.add(result.getExitPoint());
        }
    }
}

